/*
 * Decompiled with CFR 0.152.
 */
package jodd.bean;

import jodd.bean.BeanUtil;
import jodd.bean.BeanVisitor;

public class BeanCopy
extends BeanVisitor {
    protected Object destination;
    protected boolean declaredTarget;

    public BeanCopy(Object source, Object destination) {
        this.source = source;
        this.destination = destination;
    }

    public static BeanCopy beans(Object source, Object destination) {
        return new BeanCopy(source, destination);
    }

    public BeanCopy excludeAll() {
        this.blacklist = false;
        return this;
    }

    public BeanCopy exclude(String ... excludes) {
        for (String ex : excludes) {
            this.rules.exclude(ex);
        }
        return this;
    }

    public BeanCopy exclude(String exclude) {
        this.rules.exclude(exclude);
        return this;
    }

    public BeanCopy include(String ... includes) {
        for (String in : includes) {
            this.rules.include(in);
        }
        return this;
    }

    public BeanCopy include(String include) {
        this.rules.include(include);
        return this;
    }

    public BeanCopy includeAs(Class template) {
        this.blacklist = false;
        String[] properties = this.getAllBeanPropertyNames(template, false);
        this.include(properties);
        return this;
    }

    public BeanCopy ignoreNulls(boolean ignoreNulls) {
        this.ignoreNullValues = ignoreNulls;
        return this;
    }

    public BeanCopy declared(boolean declared) {
        this.declared = declared;
        this.declaredTarget = declared;
        return this;
    }

    public BeanCopy declared(boolean declaredSource, boolean declaredTarget) {
        this.declared = declaredSource;
        this.declaredTarget = declaredTarget;
        return this;
    }

    public BeanCopy includeFields(boolean includeFields) {
        this.includeFields = includeFields;
        return this;
    }

    public void copy() {
        this.visit();
    }

    protected boolean visitProperty(String name, Object value) {
        if (this.declaredTarget) {
            BeanUtil.setDeclaredPropertySilent(this.destination, name, value);
        } else {
            BeanUtil.setPropertySilent(this.destination, name, value);
        }
        return true;
    }
}

