/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.db.upgrade.client;

import com.liferay.portal.tools.db.upgrade.client.AppServer;
import com.liferay.portal.tools.db.upgrade.client.Database;
import com.liferay.portal.tools.db.upgrade.client.GogoTelnetClient;
import com.liferay.portal.tools.db.upgrade.client.TeePrintStream;
import com.liferay.portal.tools.db.upgrade.client.util.StringUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import jline.console.ConsoleReader;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class UpgradeClient {
    private static final String _JAVA_HOME = System.getenv("JAVA_HOME");
    private static final Map<String, AppServer> _appServers = new LinkedHashMap<String, AppServer>();
    private static final Map<String, Database> _databases;
    private AppServer _appServer;
    private final Properties _appServerProperties;
    private final File _appServerPropertiesFile;
    private final ConsoleReader _consoleReader = new ConsoleReader();
    private final String _jvmOpts;
    private final File _logFile;
    private final Properties _portalUpgradeDatabaseProperties;
    private final File _portalUpgradeDatabasePropertiesFile;
    private final Properties _portalUpgradeExtProperties;
    private final File _portalUpgradeExtPropertiesFile;
    private final boolean _shell;

    public static void main(String[] args) {
        try {
            Options options = UpgradeClient._getOptions();
            DefaultParser commandLineParser = new DefaultParser();
            CommandLine commandLine = commandLineParser.parse(options, args);
            if (commandLine.hasOption("help")) {
                HelpFormatter helpFormatter = new HelpFormatter();
                helpFormatter.printHelp("Liferay Portal Tools Database Upgrade Client", options);
                return;
            }
            String jvmOpts = null;
            jvmOpts = commandLine.hasOption("jvm-opts") ? commandLine.getOptionValue("jvm-opts") : "-Dfile.encoding=UTF8 -Duser.country=US -Duser.language=en -Duser.timezone=GMT -Xmx2048m ";
            File logFile = null;
            logFile = commandLine.hasOption("log-file") ? new File(commandLine.getOptionValue("log-file")) : new File("upgrade.log");
            if (logFile.exists()) {
                String logFileName = logFile.getName();
                logFile.renameTo(new File(logFileName + "." + logFile.lastModified()));
                logFile = new File(logFileName);
            }
            boolean shell = false;
            if (commandLine.hasOption("shell")) {
                shell = true;
            }
            UpgradeClient upgradeClient = new UpgradeClient(jvmOpts, logFile, shell);
            upgradeClient.upgrade();
        }
        catch (ParseException pe) {
            System.err.println("Unable to parse command line properties");
            pe.printStackTrace();
        }
        catch (Exception e) {
            System.err.println("Error running upgrade");
            e.printStackTrace();
        }
    }

    public UpgradeClient(String jvmOpts, File logFile, boolean shell) throws IOException {
        this._jvmOpts = jvmOpts;
        this._logFile = logFile;
        this._shell = shell;
        this._appServerPropertiesFile = new File("app-server.properties");
        this._appServerProperties = this._readProperties(this._appServerPropertiesFile);
        this._portalUpgradeDatabasePropertiesFile = new File("portal-upgrade-database.properties");
        this._portalUpgradeDatabaseProperties = this._readProperties(this._portalUpgradeDatabasePropertiesFile);
        this._portalUpgradeExtPropertiesFile = new File("portal-upgrade-ext.properties");
        this._portalUpgradeExtProperties = this._readProperties(this._portalUpgradeExtPropertiesFile);
    }

    public void upgrade() throws IOException {
        Process process;
        block47: {
            Throwable throwable;
            this.verifyProperties();
            System.setOut(new TeePrintStream((OutputStream)new FileOutputStream(this._logFile), System.out));
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            ArrayList<String> commands = new ArrayList<String>();
            if (_JAVA_HOME != null) {
                commands.add(_JAVA_HOME + "/bin/java");
            } else {
                commands.add("java");
            }
            commands.add("-cp");
            commands.add(this._getClassPath());
            commands.addAll(Arrays.asList(this._jvmOpts.split(" ")));
            commands.add("-Dexternal-properties=portal-upgrade.properties");
            commands.add("-Dserver.detector.server.id=" + this._appServer.getServerDetectorServerId());
            commands.add("com.liferay.portal.tools.DBUpgrader");
            processBuilder.command(commands);
            processBuilder.redirectErrorStream(true);
            process = processBuilder.start();
            try {
                throwable = null;
                try (InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream());
                     BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                    String line = null;
                    while ((line = bufferedReader.readLine()) != null && !line.equals("Running modules upgrades. Connect to Gogo shell to check the status.")) {
                        System.out.println(line);
                    }
                    System.out.flush();
                }
                catch (Throwable x2) {
                    throwable = x2;
                    throw x2;
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            try {
                throwable = null;
                try (GogoTelnetClient gogoTelnetClient = new GogoTelnetClient();){
                    String line;
                    if (!this._shell && this._isFinished(gogoTelnetClient)) break block47;
                    System.out.println("You are connected to Gogo shell.");
                    this._printHelp();
                    this._consoleReader.setPrompt("g! ");
                    while ((line = this._consoleReader.readLine()) != null && !line.equals("exit")) {
                        if (line.equals("quit")) {
                            break;
                        }
                        if (line.equals("upgrade:help")) {
                            this._printHelp();
                            continue;
                        }
                        System.out.println(gogoTelnetClient.send(line));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this._close(process.getErrorStream());
        this._close(process.getInputStream());
        this._close(process.getOutputStream());
        process.destroy();
    }

    public void verifyProperties() {
        try {
            this._verifyAppServerProperties();
            this._verifyPortalUpgradeDatabaseProperties();
            this._verifyPortalUpgradeExtProperties();
            this._saveProperties();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private static Options _getOptions() {
        Options options = new Options();
        options.addOption(new Option("h", "help", false, "Print this message."));
        options.addOption(new Option("j", "jvm-opts", true, "Set the JVM_OPTS used for the upgrade."));
        options.addOption(new Option("l", "log-file", true, "Set the name of log file."));
        options.addOption(new Option("s", "shell", false, "Automatically connect to GoGo shell."));
        return options;
    }

    private void _appendClassPath(StringBuilder sb, File dir) throws IOException {
        if (dir.exists() && dir.isDirectory()) {
            for (File file : dir.listFiles()) {
                String fileName = file.getName();
                if (file.isFile() && fileName.endsWith("jar")) {
                    sb.append(file.getCanonicalPath());
                    sb.append(File.pathSeparator);
                    continue;
                }
                if (!file.isDirectory()) continue;
                this._appendClassPath(sb, file);
            }
        }
    }

    private void _appendClassPath(StringBuilder sb, List<File> dirs) throws IOException {
        for (File dir : dirs) {
            this._appendClassPath(sb, dir);
        }
    }

    private void _close(Closeable closeable) throws IOException {
        closeable.close();
    }

    private String _getClassPath() throws IOException {
        StringBuilder sb = new StringBuilder();
        String liferayClassPath = System.getenv("LIFERAY_CLASSPATH");
        if (liferayClassPath != null && !liferayClassPath.isEmpty()) {
            sb.append(liferayClassPath);
            sb.append(File.pathSeparator);
        }
        this._appendClassPath(sb, new File("lib"));
        this._appendClassPath(sb, new File("."));
        this._appendClassPath(sb, this._appServer.getGlobalLibDir());
        this._appendClassPath(sb, this._appServer.getExtraLibDirs());
        File portalClassesDir = this._appServer.getPortalClassesDir();
        sb.append(portalClassesDir.getCanonicalPath());
        sb.append(File.pathSeparator);
        this._appendClassPath(sb, this._appServer.getPortalLibDir());
        return sb.toString();
    }

    private String _getRelativeFileName(File baseFile, File pathFile) {
        return this._getRelativeFileName(baseFile.toPath(), pathFile.toPath());
    }

    private String _getRelativeFileName(Path basePath, Path path) {
        Path relativePath = basePath.relativize(path);
        return relativePath.toString();
    }

    private List<String> _getRelativeFileNames(File baseFile, List<File> pathFiles) {
        ArrayList<String> relativeFileNames = new ArrayList<String>(pathFiles.size());
        for (File pathFile : pathFiles) {
            relativeFileNames.add(this._getRelativeFileName(baseFile.toPath(), pathFile.toPath()));
        }
        return relativeFileNames;
    }

    private boolean _isFinished(GogoTelnetClient gogoTelnetClient) throws IOException {
        System.out.print("Checking to see if all upgrades have completed...");
        String upgradeCheck = gogoTelnetClient.send("upgrade:check");
        String upgradeSteps = gogoTelnetClient.send("upgrade:list | grep Registered | grep step");
        if (!upgradeCheck.equals("upgrade:check") || upgradeSteps.contains("true")) {
            System.out.println(" your upgrades have failed, have not started, or are still running.");
            return false;
        }
        System.out.println(" done.");
        return true;
    }

    private void _printHelp() {
        System.out.println("\nUpgrade commands:");
        System.out.println("exit or quit - Exit Gogo Shell");
        System.out.println("upgrade:check - List upgrades that have failed, have not started, or are still running");
        System.out.println("upgrade:execute {module_name} - Execute upgrade for specified module");
        System.out.println("upgrade:help - Show upgrade commands");
        System.out.println("upgrade:list - List registered upgrades");
        System.out.println("upgrade:list {module_name} - List upgrade steps required for specified module");
        System.out.println("upgrade:list | grep Registered - List registered upgrades and their current version");
        System.out.println("upgrade:list | grep Registered | grep steps - List upgrades in progress");
        System.out.println("verify:execute {module_name} - Execute verifier for specified module");
        System.out.println("verify:list - List registered verifiers");
    }

    private Properties _readProperties(File file) {
        Properties properties = new Properties();
        if (file.exists()) {
            try (FileInputStream inputStream = new FileInputStream(file);){
                properties.load(inputStream);
            }
            catch (IOException ioe) {
                System.err.println("Unable to load " + file);
            }
        }
        return properties;
    }

    private void _saveProperties() throws IOException {
        this._store(this._appServerProperties, this._appServerPropertiesFile);
        this._store(this._portalUpgradeDatabaseProperties, this._portalUpgradeDatabasePropertiesFile);
        this._store(this._portalUpgradeExtProperties, this._portalUpgradeExtPropertiesFile);
    }

    private void _store(Properties properties, File file) throws IOException {
        try (PrintWriter printWriter = new PrintWriter(file);){
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                String value = properties.getProperty(key);
                value = value.replace('\\', '/');
                printWriter.println(key + "=" + value);
            }
        }
    }

    private void _verifyAppServerProperties() throws IOException {
        String value = this._appServerProperties.getProperty("server.detector.server.id");
        if (value == null || value.isEmpty()) {
            String response = null;
            while (this._appServer == null) {
                System.out.print("[ ");
                for (String appServer : _appServers.keySet()) {
                    System.out.print(appServer + " ");
                }
                System.out.println("]");
                System.out.println("Please enter your application server (tomcat): ");
                response = this._consoleReader.readLine();
                if (response.isEmpty()) {
                    response = "tomcat";
                }
                this._appServer = _appServers.get(response);
                if (this._appServer != null) continue;
                System.err.println(response + " is an unsupported application server.");
            }
            File dir = this._appServer.getDir();
            File globalLibDir = this._appServer.getGlobalLibDir();
            File portalDir = this._appServer.getPortalDir();
            System.out.println("Please enter your application server directory (" + dir + "): ");
            response = this._consoleReader.readLine();
            if (!response.isEmpty()) {
                this._appServer.setDirName(response);
            }
            System.out.println("Please enter your extra library directories (" + this._appServer.getExtraLibDirNames() + "): ");
            response = this._consoleReader.readLine();
            if (!response.isEmpty()) {
                this._appServer.setExtraLibDirNames(response);
            }
            System.out.println("Please enter your global library directory (" + globalLibDir + "): ");
            response = this._consoleReader.readLine();
            if (!response.isEmpty()) {
                this._appServer.setGlobalLibDirName(response);
            }
            System.out.println("Please enter your portal directory (" + portalDir + "): ");
            response = this._consoleReader.readLine();
            if (!response.isEmpty()) {
                this._appServer.setPortalDirName(response);
            }
            this._appServerProperties.setProperty("dir", dir.getCanonicalPath());
            this._appServerProperties.setProperty("extra.lib.dirs", StringUtil.join(this._getRelativeFileNames(dir, this._appServer.getExtraLibDirs()), ','));
            this._appServerProperties.setProperty("global.lib.dir", this._getRelativeFileName(dir, globalLibDir));
            this._appServerProperties.setProperty("portal.dir", this._getRelativeFileName(dir, portalDir));
            this._appServerProperties.setProperty("server.detector.server.id", this._appServer.getServerDetectorServerId());
        } else {
            this._appServer = new AppServer(this._appServerProperties.getProperty("dir"), this._appServerProperties.getProperty("extra.lib.dirs"), this._appServerProperties.getProperty("global.lib.dir"), this._appServerProperties.getProperty("portal.dir"), value);
        }
    }

    private void _verifyPortalUpgradeDatabaseProperties() throws IOException {
        String value = this._portalUpgradeDatabaseProperties.getProperty("jdbc.default.driverClassName");
        if (value == null || value.isEmpty()) {
            String response = null;
            Database dataSource = null;
            while (dataSource == null) {
                System.out.print("[ ");
                for (String database : _databases.keySet()) {
                    System.out.print(database + " ");
                }
                System.out.println("]");
                System.out.println("Please enter your database (mysql): ");
                response = this._consoleReader.readLine();
                if (response.isEmpty()) {
                    response = "mysql";
                }
                if ((dataSource = _databases.get(response)) != null) continue;
                System.err.println(response + " is an unsupported database.");
            }
            System.out.println("Please enter your database JDBC driver class name (" + dataSource.getClassName() + "): ");
            response = this._consoleReader.readLine();
            if (!response.isEmpty()) {
                dataSource.setClassName(response);
            }
            System.out.println("Please enter your database JDBC driver protocol (" + dataSource.getProtocol() + "): ");
            response = this._consoleReader.readLine();
            if (!response.isEmpty()) {
                dataSource.setProtocol(response);
            }
            System.out.println("Please enter your database host (" + dataSource.getHost() + "): ");
            response = this._consoleReader.readLine();
            if (!response.isEmpty()) {
                dataSource.setHost(response);
            }
            String port = null;
            port = dataSource.getPort() > 0 ? String.valueOf(dataSource.getPort()) : "none";
            System.out.println("Please enter your database port (" + port + "): ");
            response = this._consoleReader.readLine();
            if (!response.isEmpty()) {
                if (response.equals("none")) {
                    dataSource.setPort(0);
                } else {
                    dataSource.setPort(Integer.parseInt(response));
                }
            }
            System.out.println("Please enter your database name (" + dataSource.getDatabaseName() + "): ");
            response = this._consoleReader.readLine();
            if (!response.isEmpty()) {
                dataSource.setDatabaseName(response);
            }
            System.out.println("Please enter your database username: ");
            String username = this._consoleReader.readLine();
            System.out.println("Please enter your database password: ");
            String password = this._consoleReader.readLine();
            this._portalUpgradeDatabaseProperties.setProperty("jdbc.default.driverClassName", dataSource.getClassName());
            this._portalUpgradeDatabaseProperties.setProperty("jdbc.default.password", password);
            this._portalUpgradeDatabaseProperties.setProperty("jdbc.default.url", dataSource.getURL());
            this._portalUpgradeDatabaseProperties.setProperty("jdbc.default.username", username);
        }
    }

    private void _verifyPortalUpgradeExtProperties() throws IOException {
        String value = this._portalUpgradeExtProperties.getProperty("liferay.home");
        if (value == null || value.isEmpty()) {
            System.out.println("Please enter your Liferay home (../../): ");
            String response = this._consoleReader.readLine();
            if (response.isEmpty()) {
                response = "../../";
            }
            File liferayHome = new File(response);
            this._portalUpgradeExtProperties.setProperty("liferay.home", liferayHome.getCanonicalPath());
        }
    }

    static {
        _appServers.put("jboss", AppServer.getJBossEAPAppServer());
        _appServers.put("jonas", AppServer.getJOnASAppServer());
        _appServers.put("resin", AppServer.getResinAppServer());
        _appServers.put("tcserver", AppServer.getTCServerAppServer());
        _appServers.put("tomcat", AppServer.getTomcatAppServer());
        _appServers.put("weblogic", AppServer.getWebLogicAppServer());
        _appServers.put("websphere", AppServer.getWebSphereAppServer());
        _appServers.put("wildfly", AppServer.getWildFlyAppServer());
        _databases = new LinkedHashMap<String, Database>();
        _databases.put("db2", Database.getDB2Database());
        _databases.put("mariadb", Database.getMariaDBDatabase());
        _databases.put("mysql", Database.getMySQLDatabase());
        _databases.put("oracle", Database.getOracleDataSource());
        _databases.put("postgresql", Database.getPostgreSQLDatabase());
        _databases.put("sqlserver", Database.getSQLServerDatabase());
        _databases.put("sybase", Database.getSybaseDatabase());
    }
}

