/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.db.upgrade.client;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;

public class GogoTelnetClient
implements AutoCloseable {
    private final DataInputStream _dataInputStream;
    private final DataOutputStream _dataOutputStream;
    private final Socket _socket;

    public GogoTelnetClient() throws IOException {
        this("localhost", 11311);
    }

    public GogoTelnetClient(String host, int port) throws IOException {
        this._socket = new Socket(host, port);
        this._dataInputStream = new DataInputStream(this._socket.getInputStream());
        this._dataOutputStream = new DataOutputStream(this._socket.getOutputStream());
        this._doHandshake();
    }

    @Override
    public void close() {
        try {
            this._socket.close();
            this._dataInputStream.close();
            this._dataOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String send(String command) throws IOException {
        byte[] bytes = command.getBytes();
        int[] codes = new int[bytes.length + 2];
        for (int i = 0; i < bytes.length; ++i) {
            codes[i] = bytes[i];
        }
        codes[bytes.length] = 13;
        codes[bytes.length + 1] = 10;
        this._sendCommand(codes);
        return this._readUntilNextGogoPrompt();
    }

    private static void _assertCondition(boolean condition) {
        if (!condition) {
            throw new AssertionError();
        }
    }

    private void _doHandshake() throws IOException {
        this._readOneCommand();
        this._readOneCommand();
        this._readOneCommand();
        this._readOneCommand();
        this._sendCommand(255, 251, 24);
        this._readOneCommand();
        this._sendCommand(255, 250, 24, 0, 86, 84, 50, 50, 48, 255, 240);
        this._readUntilNextGogoPrompt();
    }

    private int[] _readOneCommand() throws IOException {
        ArrayList<Integer> bytes = new ArrayList<Integer>();
        int iac = this._dataInputStream.read();
        GogoTelnetClient._assertCondition(iac == 255);
        bytes.add(iac);
        int second = this._dataInputStream.read();
        bytes.add(second);
        if (second == 250) {
            int option = this._dataInputStream.read();
            bytes.add(option);
            int code = this._dataInputStream.read();
            GogoTelnetClient._assertCondition(code == 0 || code == 1);
            bytes.add(code);
            if (code == 0) {
                throw new IllegalStateException();
            }
            if (code == 1) {
                iac = this._dataInputStream.read();
                GogoTelnetClient._assertCondition(iac == 255);
                bytes.add(iac);
                int se = this._dataInputStream.read();
                GogoTelnetClient._assertCondition(se == 240);
                bytes.add(se);
            }
        } else {
            bytes.add(this._dataInputStream.read());
        }
        return this._toIntArray(bytes);
    }

    private String _readUntilNextGogoPrompt() throws IOException {
        StringBuilder sb = new StringBuilder();
        int c = this._dataInputStream.read();
        while (c != -1) {
            sb.append((char)c);
            String s = sb.toString();
            if (s.endsWith("g! ")) break;
            c = this._dataInputStream.read();
        }
        String output = sb.substring(0, sb.length() - 3);
        return output.trim();
    }

    private void _sendCommand(int ... codes) throws IOException {
        for (int code : codes) {
            this._dataOutputStream.write(code);
        }
    }

    private int[] _toIntArray(List<Integer> list) {
        int[] array = new int[list.size()];
        int i = 0;
        for (Integer integer : list) {
            array[i++] = integer;
        }
        return array;
    }
}

