/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.db.upgrade.client;

public class Database {
    private String _className;
    private String _databaseName;
    private String _host;
    private String _params;
    private int _port;
    private String _protocol;

    public static Database getDB2Database() {
        return new Database("com.ibm.db2.jcc.DB2Driver", "jdbc:db2://", "localhost", 50000, "/lportal", ":deferPrepares=false;fullyMaterializeInputStreams=true;fullyMaterializeLobData=true;progresssiveLocators=2;progressiveStreaming=2;");
    }

    public static Database getMariaDBDatabase() {
        return new Database("org.mariadb.jdbc.Driver", "jdbc:mariadb://", "localhost", 0, "/lportal", "?useUnicode=true&characterEncoding=UTF-8&useFastDateParsing=false");
    }

    public static Database getMySQLDatabase() {
        return new Database("com.mysql.jdbc.Driver", "jdbc:mysql://", "localhost", 0, "/lportal", "?characterEncoding=UTF-8&dontTrackOpenResources=true&holdResultsOpenOverStatementClose=true&useFastDateParsing=false&useUnicode=true");
    }

    public static Database getOracleDataSource() {
        return new Database("oracle.jdbc.OracleDriver", "jdbc:oracle:thin:@", "localhost", 1521, ":xe", "");
    }

    public static Database getPostgreSQLDatabase() {
        return new Database("org.postgresql.Driver", "jdbc:postgresql://", "localhost", 5432, "/lportal", "");
    }

    public static Database getSQLServerDatabase() {
        return new Database("com.microsoft.sqlserver.jdbc.SQLServerDriver", "jdbc:sqlserver://", "localhost", 0, "/lportal", "");
    }

    public static Database getSybaseDatabase() {
        return new Database("com.sybase.jdbc4.jdbc.SybDriver", "jdbc:sybase:Tds:", "localhost", 5000, "/lportal", "");
    }

    public String getClassName() {
        return this._className;
    }

    public String getDatabaseName() {
        return this._databaseName;
    }

    public String getHost() {
        return this._host;
    }

    public int getPort() {
        return this._port;
    }

    public String getProtocol() {
        return this._protocol;
    }

    public String getURL() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._protocol);
        sb.append(this._host);
        if (this._port > 0) {
            sb.append(':');
            sb.append(this._port);
        }
        sb.append(this._databaseName);
        sb.append(this._params);
        return sb.toString();
    }

    public void setClassName(String className) {
        this._className = className;
    }

    public void setDatabaseName(String databaseName) {
        this._databaseName = databaseName;
    }

    public void setHost(String host) {
        this._host = host;
    }

    public void setParams(String params) {
        this._params = params;
    }

    public void setPort(int port) {
        this._port = port;
    }

    public void setProtocol(String protocol) {
        this._protocol = protocol;
    }

    private Database(String className, String protocol, String host, int port, String databaseName, String params) {
        this._className = className;
        this._protocol = protocol;
        this._host = host;
        this._port = port;
        this._databaseName = databaseName;
        this._params = params;
    }
}

