/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.db.upgrade.client;

import com.liferay.portal.tools.db.upgrade.client.util.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class AppServer {
    private File _dir;
    private final List<File> _extraLibDirs = new ArrayList<File>();
    private File _globalLibDir;
    private File _portalDir;
    private final String _serverDetectorServerId;

    public static AppServer getJBossEAPAppServer() {
        return new AppServer("../../jboss-eap-6.4.0", "", "/modules/com/liferay/portal/main", "/standalone/deployments/ROOT.war", "jboss");
    }

    public static AppServer getJOnASAppServer() {
        return new AppServer("../../jonas-5.2.3", "", "/lib/ext", "/deploy/liferay-portal", "jonas");
    }

    public static AppServer getResinAppServer() {
        return new AppServer("../../resin-4.0.44", "", "/ext-lib", "/webapps/ROOT", "resin");
    }

    public static AppServer getTCServerAppServer() {
        return new AppServer("../../tc-server-2.9.11", "", "/liferay/lib", "/liferay/webapps/ROOT", "tomcat");
    }

    public static AppServer getTomcatAppServer() {
        return new AppServer("../../tomcat-8.0.32", "/bin", "/lib", "/webapps/ROOT", "tomcat");
    }

    public static AppServer getWebLogicAppServer() {
        return new AppServer("../../weblogic-12.1.3", "", "/domains/liferay/lib", "/domains/liferay/autodeploy/ROOT", "weblogic");
    }

    public static AppServer getWebSphereAppServer() {
        return new AppServer("../../websphere-8.5.5.0", "", "/lib/ext", "/profiles/liferay/installedApps/liferay-cell/liferay-portal.ear/liferay-portal.war", "websphere");
    }

    public static AppServer getWildFlyAppServer() {
        StringBuilder sb = new StringBuilder();
        String extraLibDirPrefix = "/modules/system/layers/base/";
        sb.append(extraLibDirPrefix);
        sb.append("javax/mail,");
        sb.append(extraLibDirPrefix);
        sb.append("javax/persistence,");
        sb.append(extraLibDirPrefix);
        sb.append("javax/servlet,");
        sb.append(extraLibDirPrefix);
        sb.append("javax/transaction");
        return new AppServer("../../wildfly-10.0.0", sb.toString(), "/modules/com/liferay/portal/main", "/standalone/deployments/ROOT.war", "wildfly");
    }

    public AppServer(String dirName, String extraLibDirNames, String globalLibDirName, String portalDirName, String serverDetectorServerId) {
        this._dir = new File(dirName);
        if (extraLibDirNames != null) {
            for (String extraLibDir : extraLibDirNames.split(",")) {
                this._extraLibDirs.add(new File(dirName, extraLibDir));
            }
        }
        this._globalLibDir = new File(dirName, globalLibDirName);
        this._portalDir = new File(dirName, portalDirName);
        this._serverDetectorServerId = serverDetectorServerId;
    }

    public File getDir() {
        return this._dir;
    }

    public String getExtraLibDirNames() {
        return StringUtil.join(this._extraLibDirs, ',');
    }

    public List<File> getExtraLibDirs() {
        return this._extraLibDirs;
    }

    public File getGlobalLibDir() {
        return this._globalLibDir;
    }

    public File getPortalClassesDir() {
        return new File(this._portalDir, "/WEB-INF/classes");
    }

    public File getPortalDir() {
        return this._portalDir;
    }

    public File getPortalLibDir() {
        return new File(this._portalDir, "/WEB-INF/lib");
    }

    public String getServerDetectorServerId() {
        return this._serverDetectorServerId;
    }

    public void setDirName(String dirName) {
        this._dir = new File(dirName);
    }

    public void setExtraLibDirNames(String extraLibDirNames) {
        if (extraLibDirNames != null) {
            for (String extraLibDirName : extraLibDirNames.split(",")) {
                this._extraLibDirs.add(new File(extraLibDirNames, extraLibDirName));
            }
        }
    }

    public void setGlobalLibDirName(String globalLibDirName) {
        this._globalLibDir = new File(this._dir, globalLibDirName);
    }

    public void setPortalDirName(String portalDirName) {
        this._portalDir = new File(this._dir, portalDirName);
    }
}

