/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.target.platform.indexer.client;

import com.liferay.portal.target.platform.indexer.TargetPlatformIndexerUtil;
import com.liferay.portal.target.platform.indexer.internal.DefaultIndexValidator;
import com.liferay.portal.target.platform.indexer.internal.LPKGIndexer;
import com.liferay.portal.tools.target.platform.indexer.client.BytesURLSupport;
import com.liferay.portal.tools.target.platform.indexer.client.Utilities;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class TargetPlatformIndexerClient {
    public static void main(String[] args) throws Exception {
        String liferayHome = System.getProperty("liferay.home");
        if (liferayHome == null) {
            System.err.println("== -Dliferay.home must point to a valid directory");
            return;
        }
        String portalLibDirName = System.getProperty("portal.lib.dir");
        if (portalLibDirName == null) {
            System.err.println("== -Dportal.lib.dir must point to a valid directory");
            return;
        }
        BytesURLSupport.init();
        String indexesFileName = System.getProperty("indexes.file", liferayHome + "/osgi/" + "target-platform" + "/target-platform-indexes-" + System.currentTimeMillis() + ".zip");
        long stopWaitTimeout = Long.parseLong(System.getProperty("stop.wait.timeout", "30000"));
        String moduleFrameworkStaticDirName = System.getProperty("module.framework.static.dir", liferayHome.concat("/osgi/static"));
        String moduleFrameworkModulesDirName = System.getProperty("module.framework.modules.dir", liferayHome.concat("/osgi/modules"));
        String moduleFrameworkPortalDirName = System.getProperty("module.framework.portal.dir", liferayHome.concat("/osgi/portal"));
        String moduleFrameworkMarketplaceDir = System.getProperty("module.framework.marketplace.dir", liferayHome.concat("/osgi/marketplace"));
        List<URI> uris = TargetPlatformIndexerClient._index(indexesFileName, Arrays.asList(new File(portalLibDirName, "util-taglib.jar")), stopWaitTimeout, moduleFrameworkStaticDirName, moduleFrameworkModulesDirName, moduleFrameworkPortalDirName, moduleFrameworkMarketplaceDir);
        if (TargetPlatformIndexerClient._validate(uris)) {
            String integrityPropertiesFileName = System.getProperty("integrity.properties", liferayHome + "/osgi/" + "target-platform" + "/integrity.properties");
            TargetPlatformIndexerClient._updateIntegrityProperties(uris, Paths.get(integrityPropertiesFileName, new String[0]));
        }
    }

    private static List<URI> _index(String indexesFileName, List<File> additionalJarFiles, long stopWaitTimeout, String moduleFrameworkStaticDirName, String moduleFrameworkModulesDirName, String moduleFrameworkPortalDirName, String moduleFrameworkMarketplaceDirName) throws Exception {
        Path indexesFilePath = Paths.get(indexesFileName, new String[0]);
        if (Files.exists(indexesFilePath, new LinkOption[0])) {
            return TargetPlatformIndexerClient._loadIndexes(indexesFilePath);
        }
        ArrayList<URI> uris = new ArrayList<URI>();
        uris.add(TargetPlatformIndexerClient._indexTargetPlatform(additionalJarFiles, stopWaitTimeout, moduleFrameworkStaticDirName, moduleFrameworkModulesDirName, moduleFrameworkPortalDirName));
        uris.addAll(TargetPlatformIndexerClient._indexLPKGFiles(Utilities.listFiles(moduleFrameworkMarketplaceDirName, "*.lpkg")));
        TargetPlatformIndexerClient._saveIndexes(indexesFileName, uris);
        return uris;
    }

    private static List<URI> _indexLPKGFiles(List<File> lpkgFiles) throws Exception {
        ArrayList<URI> uris = new ArrayList<URI>(lpkgFiles.size());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (File lpkgFile : lpkgFiles) {
            LPKGIndexer lpkgIndexer = new LPKGIndexer(lpkgFile);
            lpkgIndexer.index((OutputStream)byteArrayOutputStream);
            String name = lpkgFile.getName();
            byte[] bytes = byteArrayOutputStream.toByteArray();
            URL url = BytesURLSupport.putBytes(name.substring(0, name.length() - 5), bytes);
            TargetPlatformIndexerClient._writeIndexToLPKG(lpkgFile, bytes);
            byteArrayOutputStream.reset();
            uris.add(url.toURI());
        }
        return uris;
    }

    private static URI _indexTargetPlatform(List<File> additionalJarFiles, long stopWaitTimeout, String ... dirNames) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TargetPlatformIndexerUtil.indexTargetPlatform((OutputStream)byteArrayOutputStream, additionalJarFiles, (long)stopWaitTimeout, (String[])dirNames);
        URL url = BytesURLSupport.putBytes("liferay-target-platform", byteArrayOutputStream.toByteArray());
        return url.toURI();
    }

    private static List<URI> _loadIndexes(Path indexesFilePath) throws IOException {
        final ArrayList<URI> uris = new ArrayList<URI>();
        try (FileSystem fileSystem = FileSystems.newFileSystem(indexesFilePath, null);){
            for (Path rootPath : fileSystem.getRootDirectories()) {
                Files.walkFileTree(rootPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path filePath, BasicFileAttributes basicFileAttributes) throws IOException {
                        Path fileNamePath = filePath.getFileName();
                        String fileName = fileNamePath.toString();
                        if (!fileName.endsWith(".xml")) {
                            return FileVisitResult.CONTINUE;
                        }
                        URL url = BytesURLSupport.putBytes(fileName.substring(0, fileName.length() - 4), Files.readAllBytes(filePath));
                        try {
                            uris.add(url.toURI());
                        }
                        catch (URISyntaxException urise) {
                            throw new RuntimeException(urise);
                        }
                        return super.visitFile(filePath, basicFileAttributes);
                    }
                });
            }
        }
        return uris;
    }

    private static void _saveIndexes(String indexesFileName, List<URI> uris) throws IOException {
        Path path = Paths.get(indexesFileName, new String[0]);
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        URI indexesURI = path.toUri();
        try (FileSystem fileSystem = FileSystems.newFileSystem(URI.create("jar:file:" + indexesURI.getPath()), Collections.singletonMap("create", "true"));){
            for (URI uri : uris) {
                URL url = uri.toURL();
                String name = url.getFile();
                int index = name.lastIndexOf(47);
                if (index != -1) {
                    name = name.substring(index + 1);
                }
                if ((index = name.lastIndexOf(46)) != -1) {
                    name = name.substring(0, index);
                }
                name = URLDecoder.decode(name, "UTF-8");
                InputStream inputStream = url.openStream();
                Throwable throwable = null;
                try {
                    Files.copy(inputStream, fileSystem.getPath(name.concat(".xml"), new String[0]), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
        }
        System.out.println("== Saved indexes file at " + indexesFileName);
    }

    private static void _updateIntegrityProperties(List<URI> uris, Path integrityPropertiesPath) throws Exception {
        Collections.sort(uris);
        StringBuilder sb = new StringBuilder();
        for (URI uri : uris) {
            sb.append(Utilities.toIntegrityKey(uri));
            sb.append('=');
            sb.append(Utilities.toChecksum(uri));
            sb.append('\n');
        }
        sb.setLength(sb.length() - 1);
        Files.createDirectories(integrityPropertiesPath.getParent(), new FileAttribute[0]);
        Files.write(integrityPropertiesPath, Collections.singleton(sb.toString()), StandardCharsets.UTF_8, new OpenOption[0]);
        System.out.println("== Saved integrity.properties at " + integrityPropertiesPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean _validate(List<URI> uris) throws Exception {
        long start;
        block4: {
            boolean bl;
            DefaultIndexValidator defaultIndexValidator = new DefaultIndexValidator(Collections.emptyList());
            start = System.currentTimeMillis();
            try {
                List messages = defaultIndexValidator.validate(uris);
                if (messages.isEmpty()) break block4;
                System.out.println("== Validation errors");
                for (String message : messages) {
                    System.out.println("== " + message);
                }
                bl = false;
            }
            catch (Throwable throwable) {
                long duration = System.currentTimeMillis() - start;
                System.out.printf("== Time %02d:%02ds\n", TimeUnit.MILLISECONDS.toMinutes(duration), TimeUnit.MILLISECONDS.toSeconds(duration % 60000L));
                throw throwable;
            }
            long duration = System.currentTimeMillis() - start;
            System.out.printf("== Time %02d:%02ds\n", TimeUnit.MILLISECONDS.toMinutes(duration), TimeUnit.MILLISECONDS.toSeconds(duration % 60000L));
            return bl;
        }
        System.out.println("== Successfully validated");
        boolean bl = true;
        long duration = System.currentTimeMillis() - start;
        System.out.printf("== Time %02d:%02ds\n", TimeUnit.MILLISECONDS.toMinutes(duration), TimeUnit.MILLISECONDS.toSeconds(duration % 60000L));
        return bl;
    }

    private static void _writeIndexToLPKG(File lpkg, byte[] bytes) throws IOException {
        try (FileSystem fileSystem = FileSystems.newFileSystem(lpkg.toPath(), null);){
            Files.write(fileSystem.getPath("index.xml", new String[0]), bytes, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
        }
    }
}

