/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ibm.icu.text;

import com.liferay.ibm.icu.lang.UCharacter;
import com.liferay.ibm.icu.text.DecimalFormat;
import com.liferay.ibm.icu.text.DecimalFormatSymbols;
import com.liferay.ibm.icu.text.NumberFormat;
import java.text.AttributedCharacterIterator;
import java.util.Map;

public final class ScientificFormatHelper {
    private static final char[] SUPERSCRIPT_DIGITS = new char[]{'\u2070', '\u00b9', '\u00b2', '\u00b3', '\u2074', '\u2075', '\u2076', '\u2077', '\u2078', '\u2079'};
    private static final char SUPERSCRIPT_PLUS_SIGN = '\u207a';
    private static final char SUPERSCRIPT_MINUS_SIGN = '\u207b';
    private final String preExponent;

    private ScientificFormatHelper(String preExponent) {
        this.preExponent = preExponent;
    }

    public static ScientificFormatHelper getInstance(DecimalFormatSymbols dfs) {
        StringBuilder preExponent = new StringBuilder();
        preExponent.append(ScientificFormatHelper.getMultiplicationSymbol(dfs));
        char[] digits = dfs.getDigits();
        preExponent.append(digits[1]).append(digits[0]);
        return new ScientificFormatHelper(preExponent.toString());
    }

    private static String getMultiplicationSymbol(DecimalFormatSymbols dfs) {
        return dfs.getExponentMultiplicationSign();
    }

    public String insertMarkup(AttributedCharacterIterator iterator, CharSequence beginMarkup, CharSequence endMarkup) {
        int copyFromOffset = 0;
        StringBuilder result = new StringBuilder();
        boolean exponentSymbolFieldPresent = false;
        boolean exponentFieldPresent = false;
        iterator.first();
        while (iterator.current() != '\uffff') {
            Map<AttributedCharacterIterator.Attribute, Object> attributeSet = iterator.getAttributes();
            if (attributeSet.containsKey(NumberFormat.Field.EXPONENT_SYMBOL)) {
                exponentSymbolFieldPresent = true;
                ScientificFormatHelper.append(iterator, copyFromOffset, iterator.getRunStart(NumberFormat.Field.EXPONENT_SYMBOL), result);
                copyFromOffset = iterator.getRunLimit(NumberFormat.Field.EXPONENT_SYMBOL);
                iterator.setIndex(copyFromOffset);
                result.append(this.preExponent);
                result.append(beginMarkup);
                continue;
            }
            if (attributeSet.containsKey(NumberFormat.Field.EXPONENT)) {
                exponentFieldPresent = true;
                int limit = iterator.getRunLimit(NumberFormat.Field.EXPONENT);
                ScientificFormatHelper.append(iterator, copyFromOffset, limit, result);
                copyFromOffset = limit;
                iterator.setIndex(copyFromOffset);
                result.append(endMarkup);
                continue;
            }
            iterator.next();
        }
        if (!exponentSymbolFieldPresent || !exponentFieldPresent) {
            throw new IllegalArgumentException("Must start with standard e notation.");
        }
        ScientificFormatHelper.append(iterator, copyFromOffset, iterator.getEndIndex(), result);
        return result.toString();
    }

    private static void append(AttributedCharacterIterator iterator, int start, int limit, StringBuilder result) {
        int oldIndex = iterator.getIndex();
        iterator.setIndex(start);
        for (int i = start; i < limit; ++i) {
            result.append(iterator.current());
            iterator.next();
        }
        iterator.setIndex(oldIndex);
    }

    public String toSuperscriptExponentDigits(AttributedCharacterIterator iterator) {
        int copyFromOffset = 0;
        StringBuilder result = new StringBuilder();
        boolean exponentSymbolFieldPresent = false;
        boolean exponentFieldPresent = false;
        iterator.first();
        while (iterator.current() != '\uffff') {
            int limit;
            int start;
            Map<AttributedCharacterIterator.Attribute, Object> attributeSet = iterator.getAttributes();
            if (attributeSet.containsKey(NumberFormat.Field.EXPONENT_SYMBOL)) {
                exponentSymbolFieldPresent = true;
                ScientificFormatHelper.append(iterator, copyFromOffset, iterator.getRunStart(NumberFormat.Field.EXPONENT_SYMBOL), result);
                copyFromOffset = iterator.getRunLimit(NumberFormat.Field.EXPONENT_SYMBOL);
                iterator.setIndex(copyFromOffset);
                result.append(this.preExponent);
                continue;
            }
            if (attributeSet.containsKey(NumberFormat.Field.EXPONENT_SIGN)) {
                start = iterator.getRunStart(NumberFormat.Field.EXPONENT_SIGN);
                limit = iterator.getRunLimit(NumberFormat.Field.EXPONENT_SIGN);
                int aChar = ScientificFormatHelper.char32AtAndAdvance(iterator);
                if (DecimalFormat.minusSigns.contains(aChar)) {
                    ScientificFormatHelper.append(iterator, copyFromOffset, start, result);
                    result.append('\u207b');
                } else if (DecimalFormat.plusSigns.contains(aChar)) {
                    ScientificFormatHelper.append(iterator, copyFromOffset, start, result);
                    result.append('\u207a');
                } else {
                    throw new IllegalArgumentException();
                }
                copyFromOffset = limit;
                iterator.setIndex(copyFromOffset);
                continue;
            }
            if (attributeSet.containsKey(NumberFormat.Field.EXPONENT)) {
                exponentFieldPresent = true;
                start = iterator.getRunStart(NumberFormat.Field.EXPONENT);
                limit = iterator.getRunLimit(NumberFormat.Field.EXPONENT);
                ScientificFormatHelper.append(iterator, copyFromOffset, start, result);
                ScientificFormatHelper.copyAsSuperscript(iterator, start, limit, result);
                copyFromOffset = limit;
                iterator.setIndex(copyFromOffset);
                continue;
            }
            iterator.next();
        }
        if (!exponentSymbolFieldPresent || !exponentFieldPresent) {
            throw new IllegalArgumentException("Must start with standard e notation.");
        }
        ScientificFormatHelper.append(iterator, copyFromOffset, iterator.getEndIndex(), result);
        return result.toString();
    }

    private static void copyAsSuperscript(AttributedCharacterIterator iterator, int start, int limit, StringBuilder result) {
        int oldIndex = iterator.getIndex();
        iterator.setIndex(start);
        while (iterator.getIndex() < limit) {
            int aChar = ScientificFormatHelper.char32AtAndAdvance(iterator);
            int digit = UCharacter.digit(aChar);
            if (digit < 0) {
                throw new IllegalArgumentException();
            }
            result.append(SUPERSCRIPT_DIGITS[digit]);
        }
        iterator.setIndex(oldIndex);
    }

    private static int char32AtAndAdvance(AttributedCharacterIterator iterator) {
        char c2;
        char c1 = iterator.current();
        iterator.next();
        if (UCharacter.isHighSurrogate(c1) && (c2 = iterator.current()) != '\uffff' && UCharacter.isLowSurrogate(c2)) {
            iterator.next();
            return UCharacter.toCodePoint(c1, c2);
        }
        return c1;
    }
}

