/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ibm.icu.text;

import com.liferay.ibm.icu.text.MeasureFormat;
import com.liferay.ibm.icu.text.NumberFormat;
import com.liferay.ibm.icu.util.CurrencyAmount;
import com.liferay.ibm.icu.util.Measure;
import com.liferay.ibm.icu.util.ULocale;
import java.io.ObjectStreamException;
import java.text.FieldPosition;
import java.text.ParsePosition;

class CurrencyFormat
extends MeasureFormat {
    static final long serialVersionUID = -931679363692504634L;
    private NumberFormat fmt;
    private final transient MeasureFormat mf;

    public CurrencyFormat(ULocale locale) {
        this.setLocale(locale, locale);
        this.mf = MeasureFormat.getInstance(locale, MeasureFormat.FormatWidth.WIDE);
        this.fmt = NumberFormat.getCurrencyInstance(locale.toLocale());
    }

    public Object clone() {
        CurrencyFormat result = (CurrencyFormat)super.clone();
        result.fmt = (NumberFormat)this.fmt.clone();
        return result;
    }

    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (!(obj instanceof CurrencyAmount)) {
            throw new IllegalArgumentException("Invalid type: " + obj.getClass().getName());
        }
        CurrencyAmount currency = (CurrencyAmount)obj;
        this.fmt.setCurrency(currency.getCurrency());
        return this.fmt.format(currency.getNumber(), toAppendTo, pos);
    }

    public CurrencyAmount parseObject(String source, ParsePosition pos) {
        return this.fmt.parseCurrency(source, pos);
    }

    public StringBuilder formatMeasures(StringBuilder appendTo, FieldPosition fieldPosition, Measure ... measures) {
        return this.mf.formatMeasures(appendTo, fieldPosition, measures);
    }

    public MeasureFormat.FormatWidth getWidth() {
        return this.mf.getWidth();
    }

    public NumberFormat getNumberFormat() {
        return this.mf.getNumberFormat();
    }

    private Object writeReplace() throws ObjectStreamException {
        return this.mf.toCurrencyProxy();
    }

    private Object readResolve() throws ObjectStreamException {
        return new CurrencyFormat(this.fmt.getLocale(ULocale.ACTUAL_LOCALE));
    }
}

