/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.image.xmp;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class XMPPacketScanner {
    private static final byte[] PACKET_HEADER;
    private static final byte[] PACKET_HEADER_END;
    private static final byte[] PACKET_TRAILER;

    private static boolean skipAfter(InputStream in, byte[] match) throws IOException {
        return XMPPacketScanner.skipAfter(in, match, null);
    }

    private static boolean skipAfter(InputStream in, byte[] match, OutputStream out) throws IOException {
        int b;
        int found = 0;
        int len = match.length;
        while ((b = in.read()) >= 0) {
            if (b == match[found]) {
                if (++found != len) continue;
                return true;
            }
            if (out != null) {
                if (found > 0) {
                    out.write(match, 0, found);
                }
                out.write(b);
            }
            found = 0;
        }
        return false;
    }

    public boolean parse(InputStream in, OutputStream xmlOut) throws IOException {
        boolean foundXMP;
        if (!in.markSupported()) {
            in = new BufferedInputStream(in);
        }
        if (!(foundXMP = XMPPacketScanner.skipAfter(in, PACKET_HEADER))) {
            return false;
        }
        if (!XMPPacketScanner.skipAfter(in, PACKET_HEADER_END)) {
            throw new IOException("Invalid XMP packet header!");
        }
        if (!XMPPacketScanner.skipAfter(in, PACKET_TRAILER, xmlOut)) {
            throw new IOException("XMP packet not properly terminated!");
        }
        return true;
    }

    static {
        try {
            PACKET_HEADER = "<?xpacket begin=".getBytes("US-ASCII");
            PACKET_HEADER_END = "?>".getBytes("US-ASCII");
            PACKET_TRAILER = "<?xpacket".getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Incompatible JVM! US-ASCII encoding not supported.");
        }
    }
}

