/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.app.license.resolver;

import com.liferay.portal.app.license.AppLicenseVerifier;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.SortedMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.util.tracker.ServiceTracker;

public class AppResolverHook
implements ResolverHook {
    private static final Log _log = LogFactoryUtil.getLog(AppResolverHook.class);
    private final ServiceTracker<AppLicenseVerifier, AppLicenseVerifier> _serviceTracker;

    public AppResolverHook(ServiceTracker<AppLicenseVerifier, AppLicenseVerifier> serviceTracker) {
        this._serviceTracker = serviceTracker;
    }

    public void end() {
    }

    public void filterMatches(BundleRequirement requirement, Collection<BundleCapability> candidates) {
    }

    public void filterResolvable(Collection<BundleRevision> candidates) {
        Iterator<BundleRevision> iterator = candidates.iterator();
        while (iterator.hasNext()) {
            BundleRevision bundleRevision = iterator.next();
            try {
                this._filterResolvable(bundleRevision);
            }
            catch (Exception e) {
                _log.error((Object)("Unable to resolve " + bundleRevision.getSymbolicName()), (Throwable)e);
                iterator.remove();
            }
        }
    }

    public void filterSingletonCollisions(BundleCapability singleton, Collection<BundleCapability> collisionCandidates) {
    }

    private void _filterResolvable(BundleRevision bundleRevision) throws Exception {
        Bundle bundle;
        Properties properties;
        String productId;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Resolving bundle " + bundleRevision.getSymbolicName()));
        }
        if ((productId = (String)(properties = this._getAppLicenseProperties(bundle = bundleRevision.getBundle())).get("product-id")) == null) {
            return;
        }
        boolean verified = false;
        String licenseVersion = (String)properties.get("license-version");
        Filter filter = FrameworkUtil.createFilter((String)("(version=" + licenseVersion + ")"));
        SortedMap serviceReferences = this._serviceTracker.getTracked();
        for (ServiceReference serviceReference : serviceReferences.keySet()) {
            if (!filter.match(serviceReference)) continue;
            AppLicenseVerifier appLicenseVerifier = (AppLicenseVerifier)serviceReferences.get(serviceReference);
            String productType = (String)properties.get("product-type");
            String productVersionId = (String)properties.get("product-version-id");
            appLicenseVerifier.verify(bundle, productId, productType, productVersionId);
            verified = true;
            break;
        }
        if (!verified) {
            throw new Exception("Unable to resolve " + AppLicenseVerifier.class.getName());
        }
    }

    private Properties _getAppLicenseProperties(Bundle bundle) throws IOException {
        Properties properties = new Properties();
        URL url = bundle.getEntry("/META-INF/marketplace.properties");
        if (url != null) {
            properties.load(url.openStream());
        }
        return properties;
    }
}

