/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.bootstrap;

import aQute.bnd.header.OSGiHeader;
import aQute.bnd.header.Parameters;
import aQute.bnd.version.Version;
import com.liferay.portal.kernel.concurrent.DefaultNoticeableFuture;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.lpkg.StaticLPKGResolver;
import com.liferay.portal.kernel.module.framework.ThrowableCollector;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.spring.osgi.OSGiBeanProperties;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.ServiceLoader;
import com.liferay.portal.kernel.util.ServiceLoaderCondition;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.module.framework.ModuleFramework;
import com.liferay.portal.util.PropsValues;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.collections.ServiceTrackerMapFactory;
import com.liferay.registry.collections.ServiceTrackerMapFactoryUtil;
import com.liferay.registry.internal.RegistryImpl;
import com.liferay.registry.internal.ServiceTrackerMapFactoryImpl;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.servlet.ServletContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.util.tracker.BundleTracker;
import org.springframework.beans.factory.BeanIsAbstractException;
import org.springframework.context.ApplicationContext;

public class ModuleFrameworkImpl
implements ModuleFramework {
    private static final Log _log = LogFactoryUtil.getLog(ModuleFrameworkImpl.class);
    private Framework _framework;
    private final Map<ApplicationContext, List<ServiceRegistration<?>>> _springContextServices = new ConcurrentHashMap();

    public long addBundle(String location) throws PortalException {
        Bundle bundle = this._addBundle(location, null, true);
        return bundle.getBundleId();
    }

    public long addBundle(String location, InputStream inputStream) throws PortalException {
        Bundle bundle = this._addBundle(location, inputStream, true);
        return bundle.getBundleId();
    }

    public Bundle getBundle(BundleContext bundleContext, InputStream inputStream) throws PortalException {
        try {
            JarInputStream jarInputStream = new JarInputStream(inputStream);
            Manifest manifest = jarInputStream.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            String bundleSymbolicNameAttributeValue = attributes.getValue("Bundle-SymbolicName");
            Parameters parameters = OSGiHeader.parseHeader((String)bundleSymbolicNameAttributeValue);
            Set bundleSymbolicNameSet = parameters.keySet();
            Iterator bundleSymbolicNameIterator = bundleSymbolicNameSet.iterator();
            String bundleSymbolicName = (String)bundleSymbolicNameIterator.next();
            String bundleVersionAttributeValue = attributes.getValue("Bundle-Version");
            Version bundleVersion = Version.parseVersion((String)bundleVersionAttributeValue);
            for (Bundle bundle : bundleContext.getBundles()) {
                Version curBundleVersion = Version.parseVersion((String)String.valueOf(bundle.getVersion()));
                if (!bundleSymbolicName.equals(bundle.getSymbolicName()) || !bundleVersion.equals((Object)curBundleVersion)) continue;
                return bundle;
            }
            return null;
        }
        catch (IOException ioe) {
            throw new PortalException((Throwable)ioe);
        }
    }

    public Bundle getBundle(long bundleId) {
        if (this._framework == null) {
            return null;
        }
        BundleContext bundleContext = this._framework.getBundleContext();
        return bundleContext.getBundle(bundleId);
    }

    public URL getBundleResource(long bundleId, String name) {
        Bundle bundle = this.getBundle(bundleId);
        if (bundle == null) {
            return null;
        }
        return bundle.getResource(name);
    }

    public Framework getFramework() {
        return this._framework;
    }

    public String getState(long bundleId) throws PortalException {
        this._checkPermission();
        Bundle bundle = this.getBundle(bundleId);
        if (bundle == null) {
            throw new PortalException("No bundle with ID " + bundleId);
        }
        int state = bundle.getState();
        if (state == 32) {
            return "active";
        }
        if (state == 2) {
            return "installed";
        }
        if (state == 4) {
            return "resolved";
        }
        if (state == 8) {
            return "starting";
        }
        if (state == 16) {
            return "stopping";
        }
        if (state == 1) {
            return "uninstalled";
        }
        return "";
    }

    public void initFramework() throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initializing the OSGi framework");
        }
        this._initRequiredStartupDirs();
        List serviceLoaderConditions = ServiceLoader.load(ServiceLoaderCondition.class);
        ServiceLoaderCondition serviceLoaderCondition = (ServiceLoaderCondition)serviceLoaderConditions.get(0);
        if (_log.isDebugEnabled()) {
            Class<?> clazz = serviceLoaderCondition.getClass();
            _log.debug((Object)("Using conditional loading to find the OSGi framework factory " + clazz.getName()));
        }
        List frameworkFactories = ServiceLoader.load(FrameworkFactory.class, (ServiceLoaderCondition)serviceLoaderCondition);
        FrameworkFactory frameworkFactory = (FrameworkFactory)frameworkFactories.get(0);
        if (_log.isDebugEnabled()) {
            Class<?> clazz = frameworkFactory.getClass();
            _log.debug((Object)("Using the OSGi framework factory " + clazz.getName()));
        }
        Map<String, String> properties = this._buildFrameworkProperties(frameworkFactory.getClass());
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Creating a new OSGi framework instance");
        }
        this._framework = frameworkFactory.newFramework(properties);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initializing the new OSGi framework instance");
        }
        this._framework.init();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Binding the OSGi framework to the registry API");
        }
        RegistryUtil.setRegistry((Registry)new RegistryImpl(this._framework.getBundleContext()));
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Binding the OSGi framework to the service tracker map factory");
        }
        ServiceTrackerMapFactoryUtil.setServiceTrackerMapFactory((ServiceTrackerMapFactory)new ServiceTrackerMapFactoryImpl(this._framework.getBundleContext()));
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialized the OSGi framework");
        }
    }

    public void registerContext(Object context) {
        if (context == null) {
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Registering context " + context));
        }
        if (context instanceof ApplicationContext && PropsValues.MODULE_FRAMEWORK_REGISTER_LIFERAY_SERVICES) {
            ApplicationContext applicationContext = (ApplicationContext)context;
            this._registerApplicationContext(applicationContext);
        } else if (context instanceof ServletContext) {
            ServletContext servletContext = (ServletContext)context;
            this._registerServletContext(servletContext);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Registered context " + context));
        }
    }

    public void setBundleStartLevel(long bundleId, int startLevel) throws PortalException {
        this._checkPermission();
        Bundle bundle = this.getBundle(bundleId);
        if (bundle == null) {
            throw new PortalException("No bundle with ID " + bundleId);
        }
        BundleStartLevel bundleStartLevel = (BundleStartLevel)bundle.adapt(BundleStartLevel.class);
        bundleStartLevel.setStartLevel(startLevel);
    }

    public void startBundle(Bundle bundle, int options, boolean checkPermissions) throws PortalException {
        if (checkPermissions) {
            this._checkPermission();
        }
        if (this._isFragmentBundle(bundle) || (bundle.getState() & 0x20) == 32) {
            return;
        }
        try {
            bundle.start(options);
        }
        catch (BundleException be) {
            _log.error((Object)be, (Throwable)be);
            throw new PortalException((Throwable)be);
        }
    }

    public void startBundle(long bundleId) throws PortalException {
        this.startBundle(bundleId, 0);
    }

    public void startBundle(long bundleId, int options) throws PortalException {
        Bundle bundle = this.getBundle(bundleId);
        if (bundle == null) {
            throw new PortalException("No bundle with ID " + bundleId);
        }
        this.startBundle(bundle, 0, true);
    }

    public void startFramework() throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Starting the OSGi framework");
        }
        this._framework.start();
        this._setUpPrerequisiteFrameworkServices(this._framework.getBundleContext());
        this._setUpInitialBundles();
        this._startDynamicBundles();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Started the OSGi framework");
        }
    }

    public void startRuntime() throws Exception {
        if (this._framework == null) {
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Starting the OSGi runtime");
        }
        FrameworkStartLevel frameworkStartLevel = (FrameworkStartLevel)this._framework.adapt(FrameworkStartLevel.class);
        frameworkStartLevel.setStartLevel(PropsValues.MODULE_FRAMEWORK_RUNTIME_START_LEVEL, new FrameworkListener[0]);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Started the OSGi runtime");
        }
    }

    public void stopBundle(long bundleId) throws PortalException {
        this.stopBundle(bundleId, 0);
    }

    public void stopBundle(long bundleId, int options) throws PortalException {
        this._checkPermission();
        Bundle bundle = this.getBundle(bundleId);
        if (bundle == null) {
            throw new PortalException("No bundle with ID " + bundleId);
        }
        try {
            bundle.stop(options);
        }
        catch (BundleException be) {
            _log.error((Object)be, (Throwable)be);
            throw new PortalException((Throwable)be);
        }
    }

    public void stopFramework(long timeout) throws Exception {
        ServiceTrackerMapFactory serviceTrackerMapFactory;
        if (this._framework == null) {
            return;
        }
        Registry registry = RegistryUtil.getRegistry();
        if (registry instanceof RegistryImpl) {
            RegistryImpl registryImpl = (RegistryImpl)registry;
            registryImpl.closeServiceTrackers();
        }
        if ((serviceTrackerMapFactory = ServiceTrackerMapFactoryUtil.getServiceTrackerMapFactory()) instanceof ServiceTrackerMapFactoryImpl) {
            ServiceTrackerMapFactoryImpl serviceTrackerMapFactoryImpl = (ServiceTrackerMapFactoryImpl)serviceTrackerMapFactory;
            serviceTrackerMapFactoryImpl.clearServiceTrackerMaps();
        }
        this._framework.stop();
        FrameworkEvent frameworkEvent = this._framework.waitForStop(timeout);
        if (frameworkEvent.getType() == 512) {
            _log.error((Object)("OSGi framework event " + frameworkEvent + " triggered after a " + timeout + "ms timeout"));
        } else if (_log.isInfoEnabled()) {
            _log.info((Object)frameworkEvent);
        }
        RegistryUtil.setRegistry(null);
        ServiceTrackerMapFactoryUtil.setServiceTrackerMapFactory(null);
    }

    public void stopRuntime() throws Exception {
        if (this._framework == null) {
            return;
        }
        FrameworkStartLevel frameworkStartLevel = (FrameworkStartLevel)this._framework.adapt(FrameworkStartLevel.class);
        frameworkStartLevel.setStartLevel(PropsValues.MODULE_FRAMEWORK_BEGINNING_START_LEVEL, new FrameworkListener[0]);
    }

    public void uninstallBundle(long bundleId) throws PortalException {
        this._checkPermission();
        Bundle bundle = this.getBundle(bundleId);
        if (bundle == null) {
            throw new PortalException("No bundle with ID " + bundleId);
        }
        try {
            bundle.uninstall();
        }
        catch (BundleException be) {
            _log.error((Object)be, (Throwable)be);
            throw new PortalException((Throwable)be);
        }
    }

    public void unregisterContext(Object context) {
        if (context == null) {
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Unregistering context " + context));
        }
        if (!(context instanceof ApplicationContext)) {
            return;
        }
        this._unregisterApplicationContext((ApplicationContext)context);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Registered context " + context));
        }
    }

    public void updateBundle(long bundleId) throws PortalException {
        this.updateBundle(bundleId, null);
    }

    public void updateBundle(long bundleId, InputStream inputStream) throws PortalException {
        this._checkPermission();
        Bundle bundle = this.getBundle(bundleId);
        if (bundle == null) {
            throw new PortalException("No bundle with ID " + bundleId);
        }
        try {
            bundle.update(inputStream);
        }
        catch (BundleException be) {
            _log.error((Object)be, (Throwable)be);
            throw new PortalException((Throwable)be);
        }
    }

    private Bundle _addBundle(String location, InputStream inputStream, boolean checkPermission) throws PortalException {
        if (this._framework == null) {
            throw new IllegalStateException("OSGi framework is not initialized");
        }
        if (checkPermission) {
            this._checkPermission();
        }
        BundleContext bundleContext = this._framework.getBundleContext();
        if (inputStream != null) {
            UnsyncBufferedInputStream unsyncBufferedInputStream = new UnsyncBufferedInputStream(inputStream);
            unsyncBufferedInputStream.mark(1024000);
            Bundle bundle = this.getBundle(bundleContext, (InputStream)unsyncBufferedInputStream);
            try {
                unsyncBufferedInputStream.reset();
            }
            catch (IOException ioe) {
                throw new PortalException((Throwable)ioe);
            }
            if (bundle != null) {
                return bundle;
            }
            inputStream = unsyncBufferedInputStream;
        }
        try {
            return bundleContext.installBundle(location, inputStream);
        }
        catch (BundleException be) {
            _log.error((Object)be, (Throwable)be);
            throw new PortalException((Throwable)be);
        }
    }

    private Map<String, String> _buildFrameworkProperties(Class<?> clazz) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Building OSGi framework properties");
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("Bundle-Description", ReleaseInfo.getReleaseInfo());
        properties.put("Bundle-Name", ReleaseInfo.getName());
        properties.put("Bundle-Vendor", ReleaseInfo.getVendor());
        properties.put("Bundle-Version", ReleaseInfo.getVersion());
        properties.put("felix.fileinstall.dir", this._getFelixFileInstallDir());
        properties.put("felix.fileinstall.poll", String.valueOf(PropsValues.MODULE_FRAMEWORK_AUTO_DEPLOY_INTERVAL));
        properties.put("felix.fileinstall.start.level", String.valueOf(PropsValues.MODULE_FRAMEWORK_DYNAMIC_INSTALL_START_LEVEL));
        properties.put("felix.fileinstall.tmpdir", SystemProperties.get((String)"java.io.tmpdir"));
        properties.put("org.osgi.framework.bundle.parent", "app");
        properties.put("org.osgi.framework.storage", PropsValues.MODULE_FRAMEWORK_STATE_DIR);
        properties.put("eclipse.security", null);
        properties.put("java.security.manager", null);
        properties.put("org.osgi.framework.security", null);
        ProtectionDomain protectionDomain = clazz.getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        URL codeSourceURL = codeSource.getLocation();
        properties.put("osgi.framework", codeSourceURL.toExternalForm());
        File frameworkFile = new File(codeSourceURL.getFile());
        properties.put("osgi.install.area", frameworkFile.getParent());
        Properties extraProperties = PropsUtil.getProperties((String)"module.framework.properties.", (boolean)true);
        for (Map.Entry<Object, Object> entry : extraProperties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (value.equals("null")) {
                value = null;
            }
            properties.put(key, value);
        }
        String systemPackagesExtra = this._getSystemPackagesExtra();
        properties.put("org.osgi.framework.system.packages.extra", systemPackagesExtra);
        if (_log.isDebugEnabled()) {
            for (Map.Entry entry : properties.entrySet()) {
                _log.debug((Object)("OSGi framework property key \"" + (String)entry.getKey() + "\" with value \"" + (String)entry.getValue() + "\""));
            }
        }
        return properties;
    }

    private void _checkPermission() throws PrincipalException {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker == null) {
            throw new PrincipalException();
        }
        if (!permissionChecker.isOmniadmin()) {
            throw new PrincipalException.MustBeOmniadmin(permissionChecker);
        }
    }

    private String _getFelixFileInstallDir() {
        return PropsValues.MODULE_FRAMEWORK_PORTAL_DIR + "," + StringUtil.merge((Object[])PropsValues.MODULE_FRAMEWORK_AUTO_DEPLOY_DIRS);
    }

    private Dictionary<String, Object> _getProperties(Object bean, String beanName) {
        HashMapDictionary properties = new HashMapDictionary();
        Map osgiBeanProperties = OSGiBeanProperties.Convert.fromObject((Object)bean);
        if (osgiBeanProperties != null) {
            properties.putAll(osgiBeanProperties);
        }
        properties.put((Object)"bean.id", (Object)beanName);
        properties.put((Object)"original.bean", (Object)Boolean.TRUE);
        properties.put((Object)"service.vendor", (Object)ReleaseInfo.getVendor());
        return properties;
    }

    private String _getSystemPackagesExtra() {
        String[] systemPackagesExtra = PropsValues.MODULE_FRAMEWORK_SYSTEM_PACKAGES_EXTRA;
        StringBundler sb = new StringBundler();
        for (String extraPackage : systemPackagesExtra) {
            sb.append(extraPackage);
            sb.append(",");
        }
        Manifest extraPackagesManifest = null;
        Class<?> clazz = this.getClass();
        InputStream inputStream = clazz.getResourceAsStream("/META-INF/system.packages.extra.mf");
        try {
            extraPackagesManifest = new Manifest(inputStream);
        }
        catch (IOException ioe) {
            ReflectionUtil.throwException((Throwable)ioe);
        }
        Attributes attributes = extraPackagesManifest.getMainAttributes();
        String exportedPackages = attributes.getValue("Export-Package");
        sb.append(exportedPackages);
        if (_log.isDebugEnabled()) {
            String s = sb.toString();
            s = s.replace(",", "\n");
            _log.debug((Object)("The portal's system bundle is exporting the following packages:\n" + s));
        }
        return sb.toString();
    }

    private boolean _hasLazyActivationPolicy(Bundle bundle) {
        Dictionary headers = bundle.getHeaders();
        String fragmentHost = (String)headers.get("Fragment-Host");
        if (fragmentHost != null) {
            return false;
        }
        String activationPolicy = (String)headers.get("Bundle-ActivationPolicy");
        if (activationPolicy == null) {
            return false;
        }
        Parameters parameters = OSGiHeader.parseHeader((String)activationPolicy);
        return parameters.containsKey("lazy");
    }

    private void _initRequiredStartupDirs() {
        String[] dirNames;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initializing required startup directories");
        }
        for (String dirName : dirNames = StringUtil.split((String)this._getFelixFileInstallDir())) {
            FileUtil.mkdirs((String)dirName);
        }
        FileUtil.mkdirs((String)(PropsValues.MODULE_FRAMEWORK_BASE_DIR + "/static"));
    }

    private Bundle _installInitialBundle(String location, InputStream inputStream) {
        try {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Adding initial bundle " + location.toString()));
            }
            Bundle bundle = this._addBundle("reference:" + location, inputStream, false);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Added initial bundle " + bundle));
            }
            if (bundle == null || this._isFragmentBundle(bundle)) {
                return bundle;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Setting bundle " + bundle + " at start level " + PropsValues.MODULE_FRAMEWORK_BEGINNING_START_LEVEL));
            }
            BundleStartLevel bundleStartLevel = (BundleStartLevel)bundle.adapt(BundleStartLevel.class);
            bundleStartLevel.setStartLevel(PropsValues.MODULE_FRAMEWORK_BEGINNING_START_LEVEL);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Starting initial bundle " + bundle));
            }
            bundle.start();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Started bundle " + bundle));
            }
            return bundle;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return null;
        }
    }

    private boolean _isFragmentBundle(Bundle bundle) {
        BundleRevision bundleRevision = (BundleRevision)bundle.adapt(BundleRevision.class);
        return (bundleRevision.getTypes() & 1) != 0;
    }

    private boolean _isIgnoredInterface(String interfaceClassName) {
        for (String ignoredClass : PropsValues.MODULE_FRAMEWORK_SERVICES_IGNORED_INTERFACES) {
            if (ignoredClass.startsWith("!") || !ignoredClass.equals(interfaceClassName) && (!ignoredClass.endsWith("*") || !interfaceClassName.startsWith(ignoredClass.substring(0, ignoredClass.length() - 1)))) continue;
            return true;
        }
        return false;
    }

    private void _registerApplicationContext(ApplicationContext applicationContext) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Register application context");
        }
        ArrayList serviceRegistrations = new ArrayList();
        for (String beanName : applicationContext.getBeanDefinitionNames()) {
            ServiceRegistration<?> serviceRegistration;
            Object bean = null;
            try {
                bean = applicationContext.getBean(beanName);
            }
            catch (BeanIsAbstractException biae) {
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
            if (bean == null || (serviceRegistration = this._registerService(this._framework.getBundleContext(), beanName, bean)) == null) continue;
            serviceRegistrations.add(serviceRegistration);
        }
        this._springContextServices.put(applicationContext, serviceRegistrations);
    }

    private ServiceRegistration<?> _registerService(BundleContext bundleContext, String beanName, Object bean) {
        Set interfaces = OSGiBeanProperties.Service.interfaces((Object)bean);
        interfaces.add(bean.getClass());
        ArrayList<String> names = new ArrayList<String>(interfaces.size());
        for (Class interfaceClass : interfaces) {
            String interfaceClassName = interfaceClass.getName();
            if (this._isIgnoredInterface(interfaceClassName)) continue;
            names.add(interfaceClassName);
        }
        if (names.isEmpty()) {
            return null;
        }
        ServiceRegistration serviceRegistration = bundleContext.registerService(names.toArray(new String[names.size()]), bean, this._getProperties(bean, beanName));
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Registered service as " + serviceRegistration.getReference()));
        }
        return serviceRegistration;
    }

    private void _registerServletContext(ServletContext servletContext) {
        BundleContext bundleContext = this._framework.getBundleContext();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Register servlet context");
        }
        ServiceRegistration serviceRegistration = bundleContext.registerService(new String[]{ServletContext.class.getName()}, (Object)servletContext, this._getProperties(servletContext, "liferayServletContext"));
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Registered servlet context as " + serviceRegistration.getReference()));
        }
    }

    private void _setUpInitialBundles() throws Exception {
        Object inputStream;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Starting initial bundles");
        }
        BundleContext bundleContext = this._framework.getBundleContext();
        ThrowableCollector throwableCollector = new ThrowableCollector();
        HashMapDictionary dictionary = new HashMapDictionary();
        dictionary.put("throwable.collector", "initial.bundles");
        bundleContext.registerService(ThrowableCollector.class, (Object)throwableCollector, (Dictionary)dictionary);
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        final ArrayList<Path> jarPaths = new ArrayList<Path>();
        Files.walkFileTree(Paths.get(PropsValues.MODULE_FRAMEWORK_BASE_DIR, "static"), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path filePath, BasicFileAttributes basicFileAttributes) throws IOException {
                Path fileNamePath = filePath.getFileName();
                String fileName = StringUtil.toLowerCase((String)fileNamePath.toString());
                if (fileName.endsWith(".jar")) {
                    jarPaths.add(filePath.toAbsolutePath());
                }
                return FileVisitResult.CONTINUE;
            }
        });
        File utilTaglibFile = new File(PropsValues.LIFERAY_LIB_PORTAL_DIR, "util-taglib.jar");
        if (utilTaglibFile.exists()) {
            jarPaths.add(utilTaglibFile.toPath());
        } else {
            _log.error((Object)("Missing " + utilTaglibFile));
        }
        Collections.sort(jarPaths);
        for (Path jarPath : jarPaths) {
            inputStream = Files.newInputStream(jarPath, new OpenOption[0]);
            Throwable throwable = null;
            try {
                Bundle bundle = this._installInitialBundle(jarPath.toString(), (InputStream)inputStream);
                if (bundle == null) continue;
                bundles.add(bundle);
            }
            catch (Throwable x2) {
                throwable = x2;
                throw x2;
            }
            finally {
                if (inputStream == null) continue;
                if (throwable != null) {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                ((InputStream)inputStream).close();
            }
        }
        File file = new File(bundleContext.getProperty("lpkg.deployer.dir") + "/" + StaticLPKGResolver.getStaticLPKGFileName());
        if (file.exists()) {
            ZipFile zipFile = new ZipFile(file);
            inputStream = null;
            try {
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                ArrayList<ZipEntry> zipEntries = new ArrayList<ZipEntry>();
                while (enumeration.hasMoreElements()) {
                    ZipEntry zipEntry = enumeration.nextElement();
                    String name = StringUtil.toLowerCase((String)zipEntry.getName());
                    if (!name.endsWith(".jar")) continue;
                    zipEntries.add(zipEntry);
                }
                Collections.sort(zipEntries, new Comparator<ZipEntry>(){

                    @Override
                    public int compare(ZipEntry zipEntry1, ZipEntry zipEntry2) {
                        String name1 = zipEntry1.getName();
                        String name2 = zipEntry2.getName();
                        return name1.compareTo(name2);
                    }
                });
                for (ZipEntry zipEntry : zipEntries) {
                    InputStream inputStream2 = zipFile.getInputStream(zipEntry);
                    Throwable throwable = null;
                    try {
                        Bundle bundle = this._installInitialBundle("/".concat(zipEntry.getName()), inputStream2);
                        if (bundle == null) continue;
                        bundles.add(bundle);
                    }
                    catch (Throwable x2) {
                        throwable = x2;
                        throw x2;
                    }
                    finally {
                        if (inputStream2 == null) continue;
                        if (throwable != null) {
                            try {
                                inputStream2.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        inputStream2.close();
                    }
                }
            }
            catch (Throwable x2) {
                inputStream = x2;
                throw x2;
            }
            finally {
                if (zipFile != null) {
                    if (inputStream != null) {
                        try {
                            zipFile.close();
                        }
                        catch (Throwable x2) {
                            ((Throwable)inputStream).addSuppressed(x2);
                        }
                    } else {
                        zipFile.close();
                    }
                }
            }
        }
        FrameworkStartLevel frameworkStartLevel = (FrameworkStartLevel)this._framework.adapt(FrameworkStartLevel.class);
        frameworkStartLevel.setStartLevel(PropsValues.MODULE_FRAMEWORK_BEGINNING_START_LEVEL, new FrameworkListener[0]);
        for (final Bundle bundle : bundles) {
            if (this._isFragmentBundle(bundle)) continue;
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            BundleTracker<Void> bundleTracker = new BundleTracker<Void>(this._framework.getBundleContext(), 32, null){

                public Void addingBundle(Bundle trackedBundle, BundleEvent bundleEvent) {
                    if (trackedBundle == bundle) {
                        countDownLatch.countDown();
                        this.close();
                    }
                    return null;
                }
            };
            bundleTracker.open();
            countDownLatch.await();
        }
        throwableCollector.rethrow();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Started initial bundles");
        }
        Bundle[] installedBundles = bundleContext.getBundles();
        ArrayList<String> hostBundleSymbolicNames = new ArrayList<String>();
        for (Bundle bundle : installedBundles) {
            Dictionary headers;
            String fragmentHost;
            BundleStartLevel bundleStartLevel = (BundleStartLevel)bundle.adapt(BundleStartLevel.class);
            if (bundleStartLevel.getStartLevel() != PropsValues.MODULE_FRAMEWORK_DYNAMIC_INSTALL_START_LEVEL || (fragmentHost = (String)(headers = bundle.getHeaders()).get("Fragment-Host")) == null) continue;
            int index = fragmentHost.indexOf(59);
            if (index != -1) {
                fragmentHost = fragmentHost.substring(0, index);
            }
            hostBundleSymbolicNames.add(fragmentHost);
        }
        ArrayList<Bundle> hostBundles = new ArrayList<Bundle>();
        for (Bundle bundle : installedBundles) {
            if (!hostBundleSymbolicNames.contains(bundle.getSymbolicName())) continue;
            hostBundles.add(bundle);
        }
        FrameworkWiring frameworkWiring = (FrameworkWiring)this._framework.adapt(FrameworkWiring.class);
        frameworkWiring.refreshBundles(hostBundles, new FrameworkListener[0]);
    }

    private void _setUpPrerequisiteFrameworkServices(BundleContext bundleContext) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Setting up required services");
        }
        Props props = PropsUtil.getProps();
        ServiceRegistration serviceRegistration = bundleContext.registerService(Props.class, (Object)props, this._getProperties(props, Props.class.getName()));
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Registered required service as " + serviceRegistration.getReference()));
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Registered required services");
        }
    }

    private void _startDynamicBundles() throws Exception {
        FrameworkStartLevel frameworkStartLevel = (FrameworkStartLevel)this._framework.adapt(FrameworkStartLevel.class);
        final DefaultNoticeableFuture defaultNoticeableFuture = new DefaultNoticeableFuture();
        frameworkStartLevel.setStartLevel(PropsValues.MODULE_FRAMEWORK_DYNAMIC_INSTALL_START_LEVEL, new FrameworkListener[]{new FrameworkListener(){

            public void frameworkEvent(FrameworkEvent fe) {
                defaultNoticeableFuture.set((Object)fe);
            }
        }});
        FrameworkEvent frameworkEvent = (FrameworkEvent)defaultNoticeableFuture.get();
        if (frameworkEvent.getType() == 2) {
            ReflectionUtil.throwException((Throwable)frameworkEvent.getThrowable());
        }
        BundleContext bundleContext = this._framework.getBundleContext();
        for (Bundle bundle : bundleContext.getBundles()) {
            BundleStartLevel bundleStartLevel;
            BundleRevision bundleRevision;
            if (bundle.getState() != 2 && bundle.getState() != 4 || ((bundleRevision = (BundleRevision)bundle.adapt(BundleRevision.class)).getTypes() & 1) != 0 || (bundleStartLevel = (BundleStartLevel)bundle.adapt(BundleStartLevel.class)).getStartLevel() != PropsValues.MODULE_FRAMEWORK_DYNAMIC_INSTALL_START_LEVEL) continue;
            try {
                bundle.start();
            }
            catch (BundleException be) {
                _log.error((Object)("Unable to start bundle " + bundle.getSymbolicName()), (Throwable)be);
            }
        }
    }

    private void _unregisterApplicationContext(ApplicationContext applicationContext) {
        List<ServiceRegistration<?>> serviceRegistrations = this._springContextServices.remove(applicationContext);
        if (serviceRegistrations == null) {
            return;
        }
        for (ServiceRegistration<?> serviceRegistration : serviceRegistrations) {
            try {
                serviceRegistration.unregister();
            }
            catch (IllegalStateException ise) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)("Service registration " + serviceRegistration + " is already unregistered"));
            }
        }
    }
}

