/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.collection;

import java.io.IOException;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import thredds.inventory.TimedCollection;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.FeatureCollection;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureCollectionIterator;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.StationTimeSeriesFeature;
import ucar.nc2.ft.StationTimeSeriesFeatureCollection;
import ucar.nc2.ft.point.PointIteratorAbstract;
import ucar.nc2.ft.point.StationFeatureImpl;
import ucar.nc2.ft.point.StationHelper;
import ucar.nc2.ft.point.StationTimeSeriesCollectionImpl;
import ucar.nc2.ft.point.collection.CompositeDatasetFactory;
import ucar.nc2.ft.point.collection.CompositeStationCollectionFlattened;
import ucar.nc2.ft.point.collection.UpdateableCollection;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Station;

public class CompositeStationCollection
extends StationTimeSeriesCollectionImpl
implements UpdateableCollection {
    private TimedCollection dataCollection;
    protected List<VariableSimpleIF> dataVariables;

    protected CompositeStationCollection(String name, TimedCollection dataCollection, List<Station> stns, List<VariableSimpleIF> dataVariables) throws IOException {
        super(name);
        this.dataCollection = dataCollection;
        TimedCollection.Dataset td = dataCollection.getPrototype();
        if (td == null) {
            throw new RuntimeException("No datasets in the collection");
        }
        if (stns != null && stns.size() > 0) {
            this.stationHelper = new StationHelper();
            for (Station s : stns) {
                this.stationHelper.addStation(new CompositeStationFeature(s, null, this.dataCollection));
            }
        }
        this.dataVariables = dataVariables;
    }

    @Override
    protected void initStationHelper() {
        TimedCollection.Dataset td = this.dataCollection.getPrototype();
        if (td == null) {
            throw new RuntimeException("No datasets in the collection");
        }
        Formatter errlog = new Formatter();
        FeatureDataset openDataset = null;
        try {
            openDataset = (FeatureDatasetPoint)FeatureDatasetFactoryManager.open(FeatureType.STATION, td.getLocation(), null, errlog);
            List<FeatureCollection> fcList = openDataset.getPointFeatureCollectionList();
            StationTimeSeriesCollectionImpl openCollection = (StationTimeSeriesCollectionImpl)fcList.get(0);
            List<Station> stns = openCollection.getStations();
            this.stationHelper = new StationHelper();
            for (Station s : stns) {
                this.stationHelper.addStation(new CompositeStationFeature(s, null, this.dataCollection));
            }
            this.dataVariables = openDataset.getDataVariables();
        }
        catch (Exception ioe) {
            throw new RuntimeException(td.getLocation(), ioe);
        }
        finally {
            try {
                if (openDataset != null) {
                    openDataset.close();
                }
            }
            catch (Throwable t) {}
        }
    }

    public List<VariableSimpleIF> getDataVariables() {
        if (this.dataVariables == null) {
            this.initStationHelper();
        }
        return this.dataVariables;
    }

    @Override
    public void update() {
        this.dataCollection.update();
    }

    @Override
    public StationTimeSeriesFeatureCollection subset(List<Station> stations) throws IOException {
        if (stations == null) {
            return this;
        }
        return new CompositeStationCollection(this.getName(), this.dataCollection, stations, this.dataVariables);
    }

    @Override
    public StationTimeSeriesFeatureCollection subset(LatLonRect boundingBox) throws IOException {
        if (boundingBox == null) {
            return this;
        }
        List<Station> stations = this.stationHelper.getStations(boundingBox);
        return new CompositeStationCollection(this.getName(), this.dataCollection, stations, this.dataVariables);
    }

    @Override
    public StationTimeSeriesFeature getStationFeature(Station s) throws IOException {
        return new CompositeStationFeature(s, null, this.dataCollection);
    }

    @Override
    public PointFeatureCollection flatten(LatLonRect boundingBox, DateRange dateRange) throws IOException {
        TimedCollection subsetCollection = dateRange != null ? this.dataCollection.subset(dateRange) : this.dataCollection;
        return new CompositeStationCollectionFlattened(this.getName(), boundingBox, dateRange, subsetCollection);
    }

    @Override
    public PointFeatureCollection flatten(List<String> stations, DateRange dateRange, List<VariableSimpleIF> varList) throws IOException {
        TimedCollection subsetCollection = dateRange != null ? this.dataCollection.subset(dateRange) : this.dataCollection;
        return new CompositeStationCollectionFlattened(this.getName(), stations, dateRange, varList, subsetCollection);
    }

    @Override
    public PointFeatureCollectionIterator getPointFeatureCollectionIterator(int bufferSize) throws IOException {
        return new PointFeatureCollectionIterator(){
            Iterator<Station> stationIter;
            {
                this.stationIter = CompositeStationCollection.this.stationHelper.getStations().iterator();
            }

            @Override
            public boolean hasNext() throws IOException {
                return this.stationIter.hasNext();
            }

            @Override
            public PointFeatureCollection next() throws IOException {
                return (PointFeatureCollection)this.stationIter.next();
            }

            @Override
            public void setBufferSize(int bytes) {
            }

            @Override
            public void finish() {
            }
        };
    }

    private class CompositeStationFeature
    extends StationFeatureImpl {
        private TimedCollection collForFeature;

        CompositeStationFeature(Station s, DateUnit timeUnit, TimedCollection collForFeature) {
            super(s, timeUnit, -1);
            this.setDateRange(collForFeature.getDateRange());
            this.collForFeature = collForFeature;
        }

        @Override
        public PointFeatureIterator getPointFeatureIterator(int bufferSize) throws IOException {
            CompositeStationFeatureIterator iter = new CompositeStationFeatureIterator();
            if (this.boundingBox == null || this.dateRange == null || this.npts < 0) {
                iter.setCalculateBounds(this);
            }
            return iter;
        }

        @Override
        public StationTimeSeriesFeature subset(DateRange dateRange) throws IOException {
            if (dateRange == null) {
                return this;
            }
            CompositeStationFeature stnSubset = new CompositeStationFeature(this.s, this.timeUnit, this.collForFeature.subset(dateRange));
            return stnSubset.subset(dateRange);
        }

        @Override
        public PointFeatureCollection subset(LatLonRect boundingBox, DateRange dateRange) throws IOException {
            if (boundingBox != null) {
                if (!boundingBox.contains(this.s.getLatLon())) {
                    return null;
                }
                if (dateRange == null) {
                    return this;
                }
            }
            return this.subset(dateRange);
        }

        private class CompositeStationFeatureIterator
        extends PointIteratorAbstract {
            private int bufferSize = -1;
            private Iterator<TimedCollection.Dataset> iter;
            private FeatureDatasetPoint currentDataset;
            private PointFeatureIterator pfIter = null;
            private boolean finished = false;

            CompositeStationFeatureIterator() {
                this.iter = CompositeStationFeature.this.collForFeature.getDatasets().iterator();
            }

            private PointFeatureIterator getNextIterator() throws IOException {
                if (!this.iter.hasNext()) {
                    return null;
                }
                TimedCollection.Dataset td = this.iter.next();
                Formatter errlog = new Formatter();
                this.currentDataset = (FeatureDatasetPoint)FeatureDatasetFactoryManager.open(FeatureType.STATION, td.getLocation(), null, errlog);
                List<FeatureCollection> fcList = this.currentDataset.getPointFeatureCollectionList();
                StationTimeSeriesFeatureCollection stnCollection = (StationTimeSeriesFeatureCollection)fcList.get(0);
                Station s = stnCollection.getStation(CompositeStationFeature.this.getName());
                if (s == null) {
                    System.out.printf("CompositeStationFeatureIterator dataset: %s missing station %s%n", td.getLocation(), CompositeStationFeature.this.getName());
                    return this.getNextIterator();
                }
                StationTimeSeriesFeature stnFeature = stnCollection.getStationFeature(s);
                if (CompositeDatasetFactory.debug) {
                    System.out.printf("CompositeStationFeatureIterator open dataset: %s for %s%n", td.getLocation(), s.getName());
                }
                return stnFeature.getPointFeatureIterator(this.bufferSize);
            }

            @Override
            public boolean hasNext() throws IOException {
                if (this.pfIter == null) {
                    this.pfIter = this.getNextIterator();
                    if (this.pfIter == null) {
                        this.finish();
                        return false;
                    }
                }
                if (!this.pfIter.hasNext()) {
                    this.pfIter.finish();
                    this.currentDataset.close();
                    if (CompositeDatasetFactory.debug) {
                        System.out.printf("CompositeStationFeatureIterator close dataset: %s%n", this.currentDataset.getLocation());
                    }
                    this.pfIter = this.getNextIterator();
                    return this.hasNext();
                }
                return true;
            }

            @Override
            public PointFeature next() throws IOException {
                CompositeStationFeature.this.npts++;
                return this.pfIter.next();
            }

            @Override
            public void finish() {
                if (this.finished) {
                    return;
                }
                if (this.pfIter != null) {
                    this.pfIter.finish();
                }
                if (this.currentDataset != null) {
                    try {
                        this.currentDataset.close();
                        if (CompositeDatasetFactory.debug) {
                            System.out.printf("CompositeStationFeatureIterator close dataset: %s%n", this.currentDataset.getLocation());
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                this.finishCalcBounds();
                this.finished = true;
            }

            @Override
            public void setBufferSize(int bytes) {
                this.bufferSize = bytes;
            }
        }
    }
}

