/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.equinox.log.bridge.internal;

import org.eclipse.equinox.log.ExtendedLogEntry;
import org.eclipse.equinox.log.SynchronousLogListener;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.service.log.LogEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortalSynchronousLogListener
implements SynchronousLogListener {
    private static final String _FORMAT = "{} {}";
    private static final String _JENKINS_HOME = System.getenv("JENKINS_HOME");

    public void logged(LogEntry logEntry) {
        if (!(logEntry instanceof ExtendedLogEntry)) {
            return;
        }
        ExtendedLogEntry extendedLogEntry = (ExtendedLogEntry)logEntry;
        Object context = extendedLogEntry.getContext();
        if (context instanceof FrameworkLogEntry) {
            FrameworkLogEntry frameworkLogEntry = (FrameworkLogEntry)context;
            this._log(frameworkLogEntry.getEntry(), frameworkLogEntry.getSeverity(), frameworkLogEntry.getMessage(), frameworkLogEntry.getContext(), frameworkLogEntry.getThrowable());
            FrameworkLogEntry[] childFrameworkLogEntries = frameworkLogEntry.getChildren();
            if (childFrameworkLogEntries != null && childFrameworkLogEntries.length > 0) {
                for (FrameworkLogEntry childFrameworkLogEntry : childFrameworkLogEntries) {
                    this._log(childFrameworkLogEntry.getEntry(), childFrameworkLogEntry.getSeverity(), childFrameworkLogEntry.getMessage(), childFrameworkLogEntry.getContext(), childFrameworkLogEntry.getThrowable());
                }
            }
            return;
        }
        Bundle bundle = extendedLogEntry.getBundle();
        this._log(bundle.getSymbolicName(), extendedLogEntry.getLevel(), extendedLogEntry.getMessage(), context, extendedLogEntry.getException());
    }

    private synchronized void _log(String category, int level, String message, Object context, Throwable throwable) {
        String throwableMessage;
        if (context == null) {
            context = "";
        }
        Logger log = LoggerFactory.getLogger((String)"osgi.logging.".concat(category.replace('.', '_')));
        if (level == 4 && log.isDebugEnabled()) {
            log.debug(_FORMAT, new Object[]{message, context, throwable});
        } else if (level == 1 && log.isErrorEnabled()) {
            log.error(_FORMAT, new Object[]{message, context, throwable});
        } else if (level == 3 && log.isInfoEnabled()) {
            log.info(_FORMAT, new Object[]{message, context, throwable});
        } else if (level == 2 && log.isWarnEnabled()) {
            log.warn(_FORMAT, new Object[]{message, context, throwable});
        }
        if (throwable != null && throwable instanceof BundleException && _JENKINS_HOME != null && (throwableMessage = throwable.getMessage()).startsWith("Could not resolve module")) {
            log.error(_FORMAT, new Object[]{"Exiting the JVM", context, throwable});
            System.exit(1);
        }
    }
}

