/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.ListWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class TranslatedList<E, F>
extends ListWrapper<E> {
    private final List<F> _oldList;

    public TranslatedList(List<E> newList, List<F> oldList) {
        super(newList);
        this._oldList = oldList;
    }

    @Override
    public boolean add(E o) {
        this._oldList.add(this.toOldObject(o));
        return super.add(o);
    }

    @Override
    public void add(int index, E element) {
        this._oldList.add(index, this.toOldObject(element));
        super.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        for (E o : c) {
            this._oldList.add(this.toOldObject(o));
        }
        return super.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        for (E o : c) {
            this._oldList.add(index++, this.toOldObject(o));
        }
        return super.addAll(c);
    }

    @Override
    public E remove(int index) {
        this._oldList.remove(index);
        return super.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        this._oldList.remove(this.toOldObject(o));
        return super.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        ArrayList<F> tempList = new ArrayList<F>();
        for (Object o : c) {
            tempList.add(this.toOldObject(o));
        }
        this._oldList.removeAll(tempList);
        return super.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        ArrayList<F> tempList = new ArrayList<F>();
        for (Object o : c) {
            tempList.add(this.toOldObject(o));
        }
        this._oldList.retainAll(tempList);
        return super.retainAll(c);
    }

    @Override
    public E set(int index, E element) {
        this._oldList.set(index, this.toOldObject(element));
        return super.set(index, element);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        List newList = super.subList(fromIndex, toIndex);
        List<F> oldList = this._oldList.subList(fromIndex, toIndex);
        return this.newInstance(newList, oldList);
    }

    protected abstract TranslatedList<E, F> newInstance(List<E> var1, List<F> var2);

    protected abstract F toOldObject(E var1);
}

