/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.concurrent.ConcurrentReferenceValueHashMap;
import com.liferay.portal.kernel.memory.FinalizeManager;
import com.liferay.portal.kernel.util.Validator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringParserFragment {
    private static final Pattern _defaultPattern = Pattern.compile("[^/\\.]+");
    private static final Map<String, StringParserFragment> _stringParserFragments = new ConcurrentReferenceValueHashMap<String, StringParserFragment>(FinalizeManager.SOFT_REFERENCE_FACTORY);
    private final String _name;
    private final Pattern _pattern;
    private final boolean _raw;
    private final String _token;

    public static StringParserFragment create(String chunk) {
        StringParserFragment stringParserFragment = _stringParserFragments.get(chunk);
        if (stringParserFragment == null) {
            stringParserFragment = new StringParserFragment(chunk);
            _stringParserFragments.put(chunk, stringParserFragment);
        }
        return stringParserFragment;
    }

    public String getName() {
        return this._name;
    }

    public String getPattern() {
        return this._pattern.toString();
    }

    public String getToken() {
        return this._token;
    }

    public boolean isRaw() {
        return this._raw;
    }

    public boolean matches(String parameter) {
        Matcher matcher = this._pattern.matcher(parameter);
        return matcher.matches();
    }

    protected StringParserFragment(String fragment) {
        if (fragment == null || fragment.length() < 3) {
            throw new IllegalArgumentException("Fragment is invalid: " + fragment);
        }
        int index = fragment.indexOf(58);
        String name = null;
        if (index < 0) {
            name = fragment.substring(1, fragment.length() - 1);
            this._pattern = _defaultPattern;
        } else {
            name = fragment.substring(1, index);
            String pattern = fragment.substring(index + 1, fragment.length() - 1);
            if (Validator.isNull(pattern)) {
                throw new IllegalArgumentException("Pattern is null: " + fragment);
            }
            this._pattern = Pattern.compile(pattern);
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Name is null: " + fragment);
        }
        if (name.charAt(0) == '%') {
            if ((name = name.substring(1)).isEmpty()) {
                throw new IllegalArgumentException("Name is invalid: " + fragment);
            }
            this._raw = true;
        } else {
            this._raw = false;
        }
        this._name = name;
        this._token = "{".concat(this._name).concat("}");
    }
}

