/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.servlet.PortletSessionTracker;
import com.liferay.portal.kernel.servlet.filters.compoundsessionid.CompoundSessionIdHttpSession;
import com.liferay.portal.kernel.servlet.filters.compoundsessionid.CompoundSessionIdSplitterUtil;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public class PortletSessionListenerManager
implements HttpSessionActivationListener,
HttpSessionAttributeListener,
HttpSessionBindingListener,
HttpSessionListener {
    private static final List<HttpSessionActivationListener> _httpSessionActivationListeners = new ArrayList<HttpSessionActivationListener>();
    private static final List<HttpSessionAttributeListener> _httpSessionAttributeListeners = new ArrayList<HttpSessionAttributeListener>();
    private static final List<HttpSessionBindingListener> _httpSessionBindingListeners = new ArrayList<HttpSessionBindingListener>();
    private static final List<HttpSessionListener> _httpSessionListeners = new ArrayList<HttpSessionListener>();

    public static void addHttpSessionActivationListener(HttpSessionActivationListener httpSessionActivationListener) {
        _httpSessionActivationListeners.add(httpSessionActivationListener);
    }

    public static void addHttpSessionAttributeListener(HttpSessionAttributeListener httpSessionAttributeListener) {
        _httpSessionAttributeListeners.add(httpSessionAttributeListener);
    }

    public static void addHttpSessionBindingListener(HttpSessionBindingListener httpSessionBindingListener) {
        _httpSessionBindingListeners.add(httpSessionBindingListener);
    }

    public static void addHttpSessionListener(HttpSessionListener httpSessionListener) {
        _httpSessionListeners.add(httpSessionListener);
    }

    public static void removeHttpSessionActivationListener(HttpSessionActivationListener httpSessionActivationListener) {
        _httpSessionActivationListeners.remove(httpSessionActivationListener);
    }

    public static void removeHttpSessionAttributeListener(HttpSessionAttributeListener httpSessionAttributeListener) {
        _httpSessionAttributeListeners.remove(httpSessionAttributeListener);
    }

    public static void removeHttpSessionBindingListener(HttpSessionBindingListener httpSessionBindingListener) {
        _httpSessionBindingListeners.remove(httpSessionBindingListener);
    }

    public static void removeHttpSessionListener(HttpSessionListener httpSessionListener) {
        _httpSessionListeners.remove(httpSessionListener);
    }

    public void attributeAdded(HttpSessionBindingEvent httpSessionBindingEvent) {
        if (_httpSessionAttributeListeners.isEmpty()) {
            return;
        }
        httpSessionBindingEvent = this.getHttpSessionBindingEvent(httpSessionBindingEvent);
        for (HttpSessionAttributeListener httpSessionAttributeListener : _httpSessionAttributeListeners) {
            httpSessionAttributeListener.attributeAdded(httpSessionBindingEvent);
        }
    }

    public void attributeRemoved(HttpSessionBindingEvent httpSessionBindingEvent) {
        if (_httpSessionAttributeListeners.isEmpty()) {
            return;
        }
        httpSessionBindingEvent = this.getHttpSessionBindingEvent(httpSessionBindingEvent);
        for (HttpSessionAttributeListener httpSessionAttributeListener : _httpSessionAttributeListeners) {
            httpSessionAttributeListener.attributeRemoved(httpSessionBindingEvent);
        }
    }

    public void attributeReplaced(HttpSessionBindingEvent httpSessionBindingEvent) {
        if (_httpSessionAttributeListeners.isEmpty()) {
            return;
        }
        httpSessionBindingEvent = this.getHttpSessionBindingEvent(httpSessionBindingEvent);
        for (HttpSessionAttributeListener httpSessionAttributeListener : _httpSessionAttributeListeners) {
            httpSessionAttributeListener.attributeReplaced(httpSessionBindingEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionCreated(HttpSessionEvent httpSessionEvent) {
        if (_httpSessionListeners.isEmpty()) {
            return;
        }
        httpSessionEvent = this.getHttpSessionEvent(httpSessionEvent);
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            for (HttpSessionListener httpSessionListener : _httpSessionListeners) {
                Class<?> clazz = httpSessionListener.getClass();
                ClassLoader classLoader = clazz.getClassLoader();
                currentThread.setContextClassLoader(classLoader);
                httpSessionListener.sessionCreated(httpSessionEvent);
            }
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    public void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
        httpSessionEvent = this.getHttpSessionEvent(httpSessionEvent);
        HttpSession session = httpSessionEvent.getSession();
        PortletSessionTracker.invalidate(session.getId());
        for (HttpSessionListener httpSessionListener : _httpSessionListeners) {
            httpSessionListener.sessionDestroyed(httpSessionEvent);
        }
    }

    public void sessionDidActivate(HttpSessionEvent httpSessionEvent) {
        if (_httpSessionActivationListeners.isEmpty()) {
            return;
        }
        httpSessionEvent = this.getHttpSessionEvent(httpSessionEvent);
        for (HttpSessionActivationListener httpSessionActivationListener : _httpSessionActivationListeners) {
            httpSessionActivationListener.sessionDidActivate(httpSessionEvent);
        }
    }

    public void sessionWillPassivate(HttpSessionEvent httpSessionEvent) {
        if (_httpSessionActivationListeners.isEmpty()) {
            return;
        }
        httpSessionEvent = this.getHttpSessionEvent(httpSessionEvent);
        for (HttpSessionActivationListener httpSessionActivationListener : _httpSessionActivationListeners) {
            httpSessionActivationListener.sessionWillPassivate(httpSessionEvent);
        }
    }

    public void valueBound(HttpSessionBindingEvent httpSessionBindingEvent) {
        if (_httpSessionBindingListeners.isEmpty()) {
            return;
        }
        httpSessionBindingEvent = this.getHttpSessionBindingEvent(httpSessionBindingEvent);
        for (HttpSessionBindingListener httpSessionBindingListener : _httpSessionBindingListeners) {
            httpSessionBindingListener.valueBound(httpSessionBindingEvent);
        }
    }

    public void valueUnbound(HttpSessionBindingEvent httpSessionBindingEvent) {
        if (_httpSessionBindingListeners.isEmpty()) {
            return;
        }
        httpSessionBindingEvent = this.getHttpSessionBindingEvent(httpSessionBindingEvent);
        for (HttpSessionBindingListener httpSessionBindingListener : _httpSessionBindingListeners) {
            httpSessionBindingListener.valueUnbound(httpSessionBindingEvent);
        }
    }

    protected HttpSessionBindingEvent getHttpSessionBindingEvent(HttpSessionBindingEvent httpSessionBindingEvent) {
        if (CompoundSessionIdSplitterUtil.hasSessionDelimiter()) {
            CompoundSessionIdHttpSession compoundSessionIdHttpSession = new CompoundSessionIdHttpSession(httpSessionBindingEvent.getSession());
            httpSessionBindingEvent = new HttpSessionBindingEvent((HttpSession)compoundSessionIdHttpSession, httpSessionBindingEvent.getName(), httpSessionBindingEvent.getValue());
        }
        return httpSessionBindingEvent;
    }

    protected HttpSessionEvent getHttpSessionEvent(HttpSessionEvent httpSessionEvent) {
        if (CompoundSessionIdSplitterUtil.hasSessionDelimiter()) {
            CompoundSessionIdHttpSession compoundSessionIdHttpSession = new CompoundSessionIdHttpSession(httpSessionEvent.getSession());
            httpSessionEvent = new HttpSessionEvent((HttpSession)compoundSessionIdHttpSession);
        }
        return httpSessionEvent;
    }
}

