/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.registry.collections.internal;

import com.liferay.registry.Filter;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceRegistration;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import com.liferay.registry.collections.ServiceRegistrationMap;
import com.liferay.registry.collections.ServiceRegistrationMapImpl;
import com.liferay.registry.collections.ServiceTrackerList;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

public class ServiceTrackerCollectionImpl<S>
implements ServiceTrackerList<S> {
    private final Class<S> _clazz;
    private final Filter _filter;
    private final Map<String, Object> _properties;
    private final ServiceRegistrationMap<S> _serviceRegistrations = new ServiceRegistrationMapImpl<S>();
    private final List<EntryWrapper> _services = new CopyOnWriteArrayList<EntryWrapper>();
    private final ServiceTracker<S, S> _serviceTracker;

    public ServiceTrackerCollectionImpl(Class<S> clazz, Filter filter, ServiceTrackerCustomizer<S, S> serviceTrackerCustomizer, Map<String, Object> properties) {
        this._clazz = clazz;
        this._filter = filter;
        this._properties = Collections.unmodifiableMap(properties);
        Registry registry = RegistryUtil.getRegistry();
        if (filter != null) {
            filter = this._getFilter(filter, this._clazz);
            this._serviceTracker = registry.trackServices(filter, new DefaultServiceTrackerCustomizer(serviceTrackerCustomizer));
        } else {
            this._serviceTracker = registry.trackServices(clazz, new DefaultServiceTrackerCustomizer(serviceTrackerCustomizer));
        }
    }

    @Override
    public void add(int index, S service) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(S service) {
        if (service == null) {
            throw new IllegalArgumentException("Service is null");
        }
        if (this._filter != null && !this._filter.matches(this._properties)) {
            throw new IllegalStateException();
        }
        HashMap<String, Object> properties = new HashMap<String, Object>(this._properties);
        Registry registry = RegistryUtil.getRegistry();
        ServiceRegistration<S> serviceRegistration = registry.registerService(this._clazz, service, properties);
        this._serviceRegistrations.put(service, serviceRegistration);
        return true;
    }

    @Override
    public boolean add(S service, Map<String, Object> properties) {
        if (service == null) {
            throw new IllegalArgumentException("Service is null");
        }
        properties = new HashMap<String, Object>(properties);
        properties.putAll(this._properties);
        if (this._filter != null && !this._filter.matches(properties)) {
            throw new IllegalArgumentException("Filter does not match properties " + properties);
        }
        Registry registry = RegistryUtil.getRegistry();
        ServiceRegistration<S> serviceRegistration = registry.registerService(this._clazz, service, properties);
        this._serviceRegistrations.put(service, serviceRegistration);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends S> services) {
        boolean modified = false;
        for (S service : services) {
            if (!this.add(service)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean addAll(int index, Collection<? extends S> services) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        Set set = this._serviceRegistrations.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ServiceRegistration serviceRegistration = (ServiceRegistration)entry.getValue();
            serviceRegistration.unregister();
            iterator.remove();
        }
    }

    @Override
    public void close() {
        this.clear();
        this._serviceTracker.close();
    }

    @Override
    public boolean contains(Object service) {
        return this._services.contains(service);
    }

    @Override
    public boolean containsAll(Collection<?> services) {
        throw new UnsupportedOperationException();
    }

    @Override
    public S get(int index) {
        EntryWrapper entryWrapper = this._services.get(index);
        return (S)entryWrapper._service;
    }

    @Override
    public int indexOf(Object service) {
        return this._services.indexOf(service);
    }

    @Override
    public boolean isEmpty() {
        return this._services.isEmpty();
    }

    @Override
    public Iterator<S> iterator() {
        return new ServiceTrackerIterator(this._services.listIterator());
    }

    @Override
    public int lastIndexOf(Object service) {
        return this._services.lastIndexOf(service);
    }

    @Override
    public ListIterator<S> listIterator() {
        return new ServiceTrackerIterator(this._services.listIterator());
    }

    @Override
    public ListIterator<S> listIterator(int index) {
        return new ServiceTrackerIterator(this._services.listIterator(index));
    }

    @Override
    public void open() {
        this._serviceTracker.open();
    }

    @Override
    public S remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object service) {
        ServiceRegistration serviceRegistration = (ServiceRegistration)this._serviceRegistrations.remove(service);
        if (serviceRegistration == null) {
            return false;
        }
        serviceRegistration.unregister();
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> services) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> services) {
        throw new UnsupportedOperationException();
    }

    @Override
    public S set(int index, S service) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this._services.size();
    }

    @Override
    public List<S> subList(int fromIndex, int toIndex) {
        ArrayList<Object> list = new ArrayList<Object>();
        List<EntryWrapper> subList = this._services.subList(fromIndex, toIndex);
        for (EntryWrapper entryWrapper : subList) {
            list.add(entryWrapper._service);
        }
        return list;
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[0]);
    }

    @Override
    public <T> T[] toArray(T[] services) {
        if (services.length < this._services.size()) {
            Class<?> clazz = services.getClass();
            services = (Object[])Array.newInstance(clazz.getComponentType(), this._services.size());
        }
        for (int i = 0; i < this._services.size(); ++i) {
            EntryWrapper entryWrapper = this._services.get(i);
            services[i] = entryWrapper._service;
        }
        if (services.length > this._services.size()) {
            services[this._services.size()] = null;
        }
        return services;
    }

    private Filter _getFilter(Filter filter, Class<S> clazz) {
        Map<String, Object> properties = Collections.singletonMap("objectClass", clazz.getName());
        if (filter.matches(properties)) {
            return filter;
        }
        Registry registry = RegistryUtil.getRegistry();
        StringBuilder sb = new StringBuilder(5);
        sb.append("(&(objectClass=");
        sb.append(clazz.getName());
        sb.append(")");
        sb.append(filter.toString());
        sb.append(")");
        return registry.getFilter(sb.toString());
    }

    private class ServiceTrackerIterator
    implements ListIterator<S> {
        private final ListIterator<EntryWrapper> _listIterator;

        public ServiceTrackerIterator(ListIterator<EntryWrapper> listIterator) {
            this._listIterator = listIterator;
        }

        @Override
        public void add(S service) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this._listIterator.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this._listIterator.hasPrevious();
        }

        @Override
        public S next() {
            EntryWrapper entryWrapper = this._listIterator.next();
            return entryWrapper._service;
        }

        @Override
        public int nextIndex() {
            return this._listIterator.nextIndex();
        }

        @Override
        public S previous() {
            EntryWrapper entryWrapper = this._listIterator.previous();
            return entryWrapper._service;
        }

        @Override
        public int previousIndex() {
            return this._listIterator.previousIndex();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(S service) {
            throw new UnsupportedOperationException();
        }
    }

    private class EntryWrapper
    implements Comparable<EntryWrapper> {
        private final S _service;
        private final ServiceReference<S> _serviceReference;

        public EntryWrapper(ServiceReference<S> serviceReference, S service) {
            this._serviceReference = serviceReference;
            this._service = service;
        }

        @Override
        public int compareTo(EntryWrapper entryWrapper) {
            return entryWrapper._serviceReference.compareTo(this._serviceReference);
        }
    }

    private class DefaultServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<S, S> {
        private final ServiceTrackerCustomizer<S, S> _serviceTrackerCustomizer;

        public DefaultServiceTrackerCustomizer(ServiceTrackerCustomizer<S, S> serviceTrackerCustomizer) {
            this._serviceTrackerCustomizer = serviceTrackerCustomizer;
        }

        @Override
        public S addingService(ServiceReference<S> serviceReference) {
            Object service = null;
            if (this._serviceTrackerCustomizer != null) {
                service = this._serviceTrackerCustomizer.addingService(serviceReference);
            } else {
                Registry registry = RegistryUtil.getRegistry();
                service = registry.getService(serviceReference);
            }
            this._update(serviceReference, service, false);
            return service;
        }

        @Override
        public void modifiedService(ServiceReference<S> serviceReference, S service) {
            if (this._serviceTrackerCustomizer != null) {
                this._serviceTrackerCustomizer.modifiedService(serviceReference, service);
            }
            this._update(serviceReference, service, false);
        }

        @Override
        public void removedService(ServiceReference<S> serviceReference, S service) {
            if (this._serviceTrackerCustomizer != null) {
                this._serviceTrackerCustomizer.removedService(serviceReference, service);
            }
            this._update(serviceReference, service, true);
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void _update(ServiceReference<S> serviceReference, S service, boolean remove) {
            if (service == null) {
                return;
            }
            EntryWrapper entryWrapper = new EntryWrapper(serviceReference, service);
            List list = ServiceTrackerCollectionImpl.this._services;
            synchronized (list) {
                int index = Collections.binarySearch(ServiceTrackerCollectionImpl.this._services, entryWrapper);
                if (remove) {
                    if (index >= 0) {
                        ServiceTrackerCollectionImpl.this._services.remove(index);
                    }
                } else if (index < 0) {
                    ServiceTrackerCollectionImpl.this._services.add(-index - 1, entryWrapper);
                }
            }
        }
    }
}

