/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.tika.io.IOUtils;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.DigestingParser;
import org.apache.tika.parser.ParseContext;

public class CommonsDigester
implements DigestingParser.Digester {
    private final List<DigestAlgorithm> algorithms = new ArrayList<DigestAlgorithm>();
    private final int markLimit;

    public CommonsDigester(int markLimit, DigestAlgorithm ... algorithms) {
        Collections.addAll(this.algorithms, algorithms);
        if (markLimit < 0) {
            throw new IllegalArgumentException("markLimit must be >= 0");
        }
        this.markLimit = markLimit;
    }

    @Override
    public void digest(InputStream is, Metadata m, ParseContext parseContext) throws IOException {
        TikaInputStream tis = TikaInputStream.get(is);
        long sz = -1L;
        if (tis.hasFile()) {
            sz = tis.getLength();
        }
        if (sz > (long)this.markLimit) {
            this.digestFile(tis.getFile(), m);
            return;
        }
        SimpleBoundedInputStream bis = new SimpleBoundedInputStream(this.markLimit, tis);
        boolean finishedStream = false;
        for (DigestAlgorithm algorithm : this.algorithms) {
            bis.mark(this.markLimit + 1);
            finishedStream = this.digestEach(algorithm, bis, m);
            bis.reset();
            if (finishedStream) continue;
            break;
        }
        if (!finishedStream) {
            this.digestFile(tis.getFile(), m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void digestFile(File f, Metadata m) throws IOException {
        for (DigestAlgorithm algorithm : this.algorithms) {
            FileInputStream is = new FileInputStream(f);
            try {
                this.digestEach(algorithm, is, m);
            }
            finally {
                IOUtils.closeQuietly(is);
            }
        }
    }

    private boolean digestEach(DigestAlgorithm algorithm, InputStream is, Metadata metadata) throws IOException {
        String digest = null;
        try {
            switch (algorithm) {
                case MD2: {
                    digest = DigestUtils.md2Hex((InputStream)is);
                    break;
                }
                case MD5: {
                    digest = DigestUtils.md5Hex((InputStream)is);
                    break;
                }
                case SHA1: {
                    digest = DigestUtils.sha1Hex((InputStream)is);
                    break;
                }
                case SHA256: {
                    digest = DigestUtils.sha256Hex((InputStream)is);
                    break;
                }
                case SHA384: {
                    digest = DigestUtils.sha384Hex((InputStream)is);
                    break;
                }
                case SHA512: {
                    digest = DigestUtils.sha512Hex((InputStream)is);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Sorry, not aware of algorithm: " + algorithm.toString());
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (is instanceof SimpleBoundedInputStream && ((SimpleBoundedInputStream)is).hasHitBound()) {
            return false;
        }
        metadata.set(algorithm.getMetadataKey(), digest);
        return true;
    }

    public static DigestAlgorithm[] parse(String s) {
        assert (s != null);
        ArrayList<DigestAlgorithm> ret = new ArrayList<DigestAlgorithm>();
        for (String algoString : s.split(",")) {
            String uc = algoString.toUpperCase(Locale.ROOT);
            if (uc.equals(DigestAlgorithm.MD2.toString())) {
                ret.add(DigestAlgorithm.MD2);
                continue;
            }
            if (uc.equals(DigestAlgorithm.MD5.toString())) {
                ret.add(DigestAlgorithm.MD5);
                continue;
            }
            if (uc.equals(DigestAlgorithm.SHA1.toString())) {
                ret.add(DigestAlgorithm.SHA1);
                continue;
            }
            if (uc.equals(DigestAlgorithm.SHA256.toString())) {
                ret.add(DigestAlgorithm.SHA256);
                continue;
            }
            if (uc.equals(DigestAlgorithm.SHA384.toString())) {
                ret.add(DigestAlgorithm.SHA384);
                continue;
            }
            if (uc.equals(DigestAlgorithm.SHA512.toString())) {
                ret.add(DigestAlgorithm.SHA512);
                continue;
            }
            StringBuilder sb = new StringBuilder();
            int i = 0;
            for (DigestAlgorithm algo : DigestAlgorithm.values()) {
                if (i++ > 0) {
                    sb.append(", ");
                }
                sb.append(algo.toString());
            }
            throw new IllegalArgumentException("Couldn't match " + s + " with any of: " + sb.toString());
        }
        return ret.toArray(new DigestAlgorithm[ret.size()]);
    }

    private class SimpleBoundedInputStream
    extends InputStream {
        private static final int EOF = -1;
        private final long max;
        private final InputStream in;
        private long pos;
        boolean hitBound = false;

        private SimpleBoundedInputStream(long max, InputStream in) {
            this.max = max;
            this.in = in;
        }

        @Override
        public int read() throws IOException {
            if (this.max >= 0L && this.pos >= this.max) {
                this.hitBound = true;
                return -1;
            }
            int result = this.in.read();
            ++this.pos;
            return result;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.max >= 0L && this.pos >= this.max) {
                return -1;
            }
            long maxRead = this.max >= 0L ? Math.min((long)len, this.max - this.pos) : (long)len;
            int bytesRead = this.in.read(b, off, (int)maxRead);
            if (bytesRead == -1) {
                return -1;
            }
            this.pos += (long)bytesRead;
            return bytesRead;
        }

        @Override
        public long skip(long n) throws IOException {
            long toSkip = this.max >= 0L ? Math.min(n, this.max - this.pos) : n;
            long skippedBytes = this.in.skip(toSkip);
            this.pos += skippedBytes;
            return skippedBytes;
        }

        @Override
        public void reset() throws IOException {
            this.in.reset();
        }

        @Override
        public void mark(int readLimit) {
            this.in.mark(readLimit);
        }

        public boolean hasHitBound() {
            return this.hitBound;
        }
    }

    public static enum DigestAlgorithm {
        MD2,
        MD5,
        SHA1,
        SHA256,
        SHA384,
        SHA512;


        String getMetadataKey() {
            return "X-TIKA:digest:" + this.toString();
        }
    }
}

