/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.rtf;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TaggedInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.rtf.RTFEmbObjHandler;
import org.apache.tika.parser.rtf.TextExtractor;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class RTFParser
extends AbstractParser {
    private static final long serialVersionUID = -4165069489372320313L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MediaType.application("rtf"));
    private static int EMB_OBJ_MAX_BYTES = 0x1400000;

    public static int getMaxBytesForEmbeddedObject() {
        return EMB_OBJ_MAX_BYTES;
    }

    public static void setMaxBytesForEmbeddedObject(int max) {
        EMB_OBJ_MAX_BYTES = max;
    }

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        TaggedInputStream tagged = new TaggedInputStream(stream);
        try {
            XHTMLContentHandler xhtmlHandler = new XHTMLContentHandler(handler, metadata);
            RTFEmbObjHandler embObjHandler = new RTFEmbObjHandler(xhtmlHandler, metadata, context);
            TextExtractor ert = new TextExtractor(xhtmlHandler, metadata, embObjHandler);
            ert.extract(stream);
            metadata.add("Content-Type", "application/rtf");
        }
        catch (IOException e) {
            tagged.throwIfCauseOf(e);
            throw new TikaException("Error parsing an RTF document", e);
        }
    }
}

