/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.DataType;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.PropertyMap;
import com.healthmarketscience.jackcess.Row;
import com.healthmarketscience.jackcess.Table;
import com.healthmarketscience.jackcess.query.Query;
import com.healthmarketscience.jackcess.util.OleBlob;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.IOUtils;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.OfficeOpenXMLExtended;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.html.HtmlParser;
import org.apache.tika.parser.microsoft.AbstractPOIFSExtractor;
import org.apache.tika.parser.microsoft.JackcessParser;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.SAXException;

class JackcessExtractor
extends AbstractPOIFSExtractor {
    static final String TITLE_PROP_KEY = "Title";
    static final String AUTHOR_PROP_KEY = "Author";
    static final String COMPANY_PROP_KEY = "Company";
    static final String TEXT_FORMAT_KEY = "TextFormat";
    static final String CURRENCY_FORMAT_KEY = "Format";
    static final byte TEXT_FORMAT = 0;
    static final byte RICH_TEXT_FORMAT = 1;
    static final ParseContext EMPTY_PARSE_CONTEXT = new ParseContext();
    final NumberFormat currencyFormatter;
    final DateFormat shortDateTimeFormatter;
    final HtmlParser htmlParser = new HtmlParser();

    protected JackcessExtractor(ParseContext context, Locale locale) {
        super(context);
        this.currencyFormatter = NumberFormat.getCurrencyInstance(locale);
        this.shortDateTimeFormatter = DateFormat.getDateInstance(3, locale);
    }

    public void parse(Database db, XHTMLContentHandler xhtml, Metadata metadata) throws IOException, SAXException, TikaException {
        String pw = db.getDatabasePassword();
        if (pw != null) {
            metadata.set(JackcessParser.MDB_PW, pw);
        }
        PropertyMap dbp = db.getDatabaseProperties();
        for (PropertyMap.Property p : dbp) {
            metadata.add(JackcessParser.MDB_PROPERTY_PREFIX + p.getName(), this.toString(p.getValue(), p.getType()));
        }
        PropertyMap up = db.getUserDefinedProperties();
        for (PropertyMap.Property p : up) {
            metadata.add(JackcessParser.USER_DEFINED_PROPERTY_PREFIX + p.getName(), this.toString(p.getValue(), p.getType()));
        }
        HashSet<String> found = new HashSet<String>();
        PropertyMap summaryProperties = db.getSummaryProperties();
        if (summaryProperties != null) {
            PropertyMap.Property company;
            PropertyMap.Property author;
            PropertyMap.Property title = summaryProperties.get(TITLE_PROP_KEY);
            if (title != null) {
                metadata.set(TikaCoreProperties.TITLE, this.toString(title.getValue(), title.getType()));
                found.add(title.getName());
            }
            if ((author = summaryProperties.get(AUTHOR_PROP_KEY)) != null) {
                metadata.set(TikaCoreProperties.CREATOR, this.toString(author.getValue(), author.getType()));
                found.add(author.getName());
            }
            if ((company = summaryProperties.get(COMPANY_PROP_KEY)) != null) {
                metadata.set(OfficeOpenXMLExtended.COMPANY, this.toString(company.getValue(), company.getType()));
                found.add(company.getName());
            }
            for (PropertyMap.Property p : db.getSummaryProperties()) {
                if (found.contains(p.getName())) continue;
                metadata.add("MDB_SUMMARY_PROP:" + p.getName(), this.toString(p.getValue(), p.getType()));
            }
        }
        for (Table table : db.newIterable().setIncludeLinkedTables(false).setIncludeSystemTables(false)) {
            String tableName = table.getName();
            List columns = table.getColumns();
            xhtml.startElement("table", "name", tableName);
            this.addHeaders(columns, xhtml);
            xhtml.startElement("tbody");
            Row r = table.getNextRow();
            while (r != null) {
                xhtml.startElement("tr");
                for (Column c : columns) {
                    this.handleCell(r, c, xhtml);
                }
                xhtml.endElement("tr");
                r = table.getNextRow();
            }
            xhtml.endElement("tbody");
            xhtml.endElement("table");
        }
        for (Query q : db.getQueries()) {
            xhtml.startElement("div", "type", "sqlQuery");
            xhtml.characters(q.toSQLString());
            xhtml.endElement("div");
        }
    }

    private void addHeaders(List<? extends Column> columns, XHTMLContentHandler xhtml) throws SAXException {
        xhtml.startElement("thead");
        xhtml.startElement("tr");
        for (Column column : columns) {
            xhtml.startElement("th");
            xhtml.characters(column.getName());
            xhtml.endElement("th");
        }
        xhtml.endElement("tr");
        xhtml.endElement("thead");
    }

    private void handleCell(Row r, Column c, XHTMLContentHandler handler) throws SAXException, IOException, TikaException {
        handler.startElement("td");
        if (c.getType().equals((Object)DataType.OLE)) {
            this.handleOLE(r, c.getName(), handler);
        } else if (c.getType().equals((Object)DataType.BINARY)) {
            Object obj = r.get((Object)c.getName());
            if (obj != null) {
                byte[] bytes = (byte[])obj;
                this.handleEmbeddedResource(TikaInputStream.get(bytes), null, null, null, handler, false);
            }
        } else {
            Object obj = r.get((Object)c.getName());
            String v = this.toString(obj, c.getType());
            if (this.isRichText(c)) {
                BodyContentHandler h = new BodyContentHandler();
                Metadata m = new Metadata();
                m.set("Content-Type", "text/html; charset=UTF-8");
                try {
                    this.htmlParser.parse(new ByteArrayInputStream(v.getBytes(IOUtils.UTF_8)), h, m, EMPTY_PARSE_CONTEXT);
                    handler.characters(h.toString());
                }
                catch (SAXException e) {
                    handler.characters(v);
                }
            } else {
                handler.characters(v);
            }
        }
        handler.endElement("td");
    }

    private boolean isRichText(Column c) throws IOException {
        if (c == null) {
            return false;
        }
        PropertyMap m = c.getProperties();
        if (m == null) {
            return false;
        }
        if (c.getType() == null || !c.getType().equals((Object)DataType.MEMO)) {
            return false;
        }
        Object b = m.getValue(TEXT_FORMAT_KEY);
        return b instanceof Byte && (Byte)b == 1;
    }

    private String toString(Object value, DataType type) {
        if (value == null) {
            return "";
        }
        if (type == null) {
            return value.toString();
        }
        switch (type) {
            case LONG: {
                return Integer.toString((Integer)value);
            }
            case TEXT: {
                return (String)value;
            }
            case MONEY: {
                return this.formatCurrency(((BigDecimal)value).doubleValue(), type);
            }
            case SHORT_DATE_TIME: {
                return this.formatShortDateTime((Date)value);
            }
            case BOOLEAN: {
                return Boolean.toString((Boolean)value);
            }
            case MEMO: {
                return (String)value;
            }
            case INT: {
                return Short.toString((Short)value);
            }
            case DOUBLE: {
                return Double.toString((Double)value);
            }
            case FLOAT: {
                return Float.toString(((Float)value).floatValue());
            }
            case NUMERIC: {
                return value.toString();
            }
            case BYTE: {
                return Byte.toString((Byte)value);
            }
            case GUID: {
                return value.toString();
            }
        }
        return "";
    }

    private void handleOLE(Row row, String cName, XHTMLContentHandler xhtml) throws IOException, SAXException, TikaException {
        OleBlob blob = row.getBlob(cName);
        if (blob == null) {
            return;
        }
        OleBlob.Content content = blob.getContent();
        if (content == null) {
            return;
        }
        switch (content.getType()) {
            case LINK: {
                xhtml.characters(((OleBlob.LinkContent)content).getLinkPath());
                break;
            }
            case SIMPLE_PACKAGE: {
                OleBlob.SimplePackageContent spc = (OleBlob.SimplePackageContent)content;
                this.handleEmbeddedResource(TikaInputStream.get(spc.getStream()), spc.getFileName(), null, spc.getTypeName(), xhtml, false);
                break;
            }
            case OTHER: {
                OleBlob.OtherContent oc = (OleBlob.OtherContent)content;
                this.handleEmbeddedResource(TikaInputStream.get(oc.getStream()), null, null, oc.getTypeName(), xhtml, false);
                break;
            }
            case COMPOUND_STORAGE: {
                OleBlob.CompoundContent cc = (OleBlob.CompoundContent)content;
                this.handleCompoundContent(cc, xhtml);
            }
        }
    }

    private void handleCompoundContent(OleBlob.CompoundContent cc, XHTMLContentHandler xhtml) throws IOException, SAXException, TikaException {
        NPOIFSFileSystem nfs = new NPOIFSFileSystem(cc.getStream());
        this.handleEmbeddedOfficeDoc(nfs.getRoot(), xhtml);
    }

    String formatCurrency(Double d, DataType type) {
        if (d == null) {
            return "";
        }
        return this.currencyFormatter.format(d);
    }

    String formatShortDateTime(Date d) {
        if (d == null) {
            return "";
        }
        return this.shortDateTimeFormatter.format(d);
    }
}

