/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.io.IOException;
import java.util.HashSet;
import org.apache.poi.hslf.HSLFSlideShow;
import org.apache.poi.hslf.model.HeadersFooters;
import org.apache.poi.hslf.model.MasterSheet;
import org.apache.poi.hslf.model.Notes;
import org.apache.poi.hslf.model.OLEShape;
import org.apache.poi.hslf.model.Shape;
import org.apache.poi.hslf.model.Slide;
import org.apache.poi.hslf.model.Table;
import org.apache.poi.hslf.model.TableCell;
import org.apache.poi.hslf.model.TextRun;
import org.apache.poi.hslf.model.TextShape;
import org.apache.poi.hslf.usermodel.ObjectData;
import org.apache.poi.hslf.usermodel.PictureData;
import org.apache.poi.hslf.usermodel.SlideShow;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.AbstractPOIFSExtractor;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class HSLFExtractor
extends AbstractPOIFSExtractor {
    public HSLFExtractor(ParseContext context) {
        super(context);
    }

    protected void parse(NPOIFSFileSystem filesystem, XHTMLContentHandler xhtml) throws IOException, SAXException, TikaException {
        this.parse(filesystem.getRoot(), xhtml);
    }

    protected void parse(DirectoryNode root, XHTMLContentHandler xhtml) throws IOException, SAXException, TikaException {
        HSLFSlideShow ss = new HSLFSlideShow(root);
        SlideShow _show = new SlideShow(ss);
        Slide[] _slides = _show.getSlides();
        xhtml.startElement("div", "class", "slideShow");
        for (Slide slide : _slides) {
            xhtml.startElement("div", "class", "slide");
            HeadersFooters hf = slide.getHeadersFooters();
            if (hf != null && hf.isHeaderVisible() && hf.getHeaderText() != null) {
                xhtml.startElement("p", "class", "slide-header");
                xhtml.characters(hf.getHeaderText());
                xhtml.endElement("p");
            }
            this.extractMaster(xhtml, slide.getMasterSheet());
            xhtml.startElement("p", "class", "slide-content");
            this.textRunsToText(xhtml, slide.getTextRuns());
            xhtml.endElement("p");
            for (Shape shape : slide.getShapes()) {
                if (!(shape instanceof Table)) continue;
                this.extractTableText(xhtml, (Table)shape);
            }
            if (hf != null && hf.isFooterVisible() && hf.getFooterText() != null) {
                xhtml.startElement("p", "class", "slide-footer");
                xhtml.characters(hf.getFooterText());
                xhtml.endElement("p");
            }
            for (Shape shape : slide.getComments()) {
                xhtml.startElement("p", "class", "slide-comment");
                if (shape.getAuthor() != null) {
                    xhtml.startElement("b");
                    xhtml.characters(shape.getAuthor());
                    xhtml.endElement("b");
                    if (shape.getText() != null) {
                        xhtml.characters(" - ");
                    }
                }
                if (shape.getText() != null) {
                    xhtml.characters(shape.getText());
                }
                xhtml.endElement("p");
            }
            this.handleSlideEmbeddedResources(slide, xhtml);
            xhtml.endElement("div");
        }
        xhtml.endElement("div");
        xhtml.startElement("div", "class", "slideNotes");
        HashSet<Integer> seenNotes = new HashSet<Integer>();
        HeadersFooters hf = _show.getNotesHeadersFooters();
        for (Slide slide : _slides) {
            Integer id;
            Notes notes = slide.getNotesSheet();
            if (notes == null || seenNotes.contains(id = Integer.valueOf(notes._getSheetNumber()))) continue;
            seenNotes.add(id);
            if (hf != null && hf.isHeaderVisible() && hf.getHeaderText() != null) {
                xhtml.startElement("p", "class", "slide-note-header");
                xhtml.characters(hf.getHeaderText());
                xhtml.endElement("p");
            }
            this.textRunsToText(xhtml, notes.getTextRuns());
            if (hf == null || !hf.isFooterVisible() || hf.getFooterText() == null) continue;
            xhtml.startElement("p", "class", "slide-note-footer");
            xhtml.characters(hf.getFooterText());
            xhtml.endElement("p");
        }
        this.handleSlideEmbeddedPictures(_show, xhtml);
        xhtml.endElement("div");
    }

    private void extractMaster(XHTMLContentHandler xhtml, MasterSheet master) throws SAXException {
        if (master == null) {
            return;
        }
        Shape[] shapes = master.getShapes();
        if (shapes == null || shapes.length == 0) {
            return;
        }
        xhtml.startElement("div", "class", "slide-master-content");
        for (Shape shape : shapes) {
            TextShape tsh;
            String text;
            if (shape == null || MasterSheet.isPlaceholder((Shape)shape) || !(shape instanceof TextShape) || (text = (tsh = (TextShape)shape).getText()) == null) continue;
            xhtml.element("p", text);
        }
        xhtml.endElement("div");
    }

    private void extractTableText(XHTMLContentHandler xhtml, Table shape) throws SAXException {
        xhtml.startElement("table");
        for (int row = 0; row < shape.getNumberOfRows(); ++row) {
            xhtml.startElement("tr");
            for (int col = 0; col < shape.getNumberOfColumns(); ++col) {
                TableCell cell = shape.getCell(row, col);
                String txt = "";
                if (cell != null) {
                    txt = cell.getText();
                }
                xhtml.element("td", txt);
            }
            xhtml.endElement("tr");
        }
        xhtml.endElement("table");
    }

    private void textRunsToText(XHTMLContentHandler xhtml, TextRun[] runs) throws SAXException {
        if (runs == null) {
            return;
        }
        for (TextRun run : runs) {
            String txt;
            if (run == null || (txt = run.getText()) == null) continue;
            xhtml.characters(txt);
            xhtml.startElement("br");
            xhtml.endElement("br");
        }
    }

    private void handleSlideEmbeddedPictures(SlideShow slideshow, XHTMLContentHandler xhtml) throws TikaException, SAXException, IOException {
        for (PictureData pic : slideshow.getPictureData()) {
            String mediaType = null;
            switch (pic.getType()) {
                case 2: {
                    mediaType = "application/x-emf";
                    break;
                }
                case 5: {
                    mediaType = "image/jpeg";
                    break;
                }
                case 6: {
                    mediaType = "image/png";
                    break;
                }
                case 3: {
                    mediaType = "application/x-msmetafile";
                    break;
                }
                case 7: {
                    mediaType = "image/bmp";
                }
            }
            this.handleEmbeddedResource(TikaInputStream.get(pic.getData()), null, null, mediaType, xhtml, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSlideEmbeddedResources(Slide slide, XHTMLContentHandler xhtml) throws TikaException, SAXException, IOException {
        Shape[] shapes;
        try {
            shapes = slide.getShapes();
        }
        catch (NullPointerException e) {
            return;
        }
        for (Shape shape : shapes) {
            if (!(shape instanceof OLEShape)) continue;
            OLEShape oleShape = (OLEShape)shape;
            ObjectData data = null;
            try {
                data = oleShape.getObjectData();
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            if (data == null) continue;
            String objID = Integer.toString(oleShape.getObjectID());
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("", "class", "class", "CDATA", "embedded");
            attributes.addAttribute("", "id", "id", "CDATA", objID);
            xhtml.startElement("div", attributes);
            xhtml.endElement("div");
            try (TikaInputStream stream = TikaInputStream.get(data.getData());){
                String mediaType = null;
                if ("Excel.Chart.8".equals(oleShape.getProgID())) {
                    mediaType = "application/vnd.ms-excel";
                }
                this.handleEmbeddedResource(stream, objID, objID, mediaType, xhtml, false);
            }
        }
    }
}

