/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.jdbc.JDBCTableReader;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

class SQLite3TableReader
extends JDBCTableReader {
    DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.ROOT);

    public SQLite3TableReader(Connection connection, String tableName, ParseContext context) {
        super(connection, tableName, context);
    }

    @Override
    protected void handleClob(String tableName, String fieldName, int rowNum, ResultSet resultSet, int columnIndex, ContentHandler handler, ParseContext context) throws SQLException, IOException, SAXException {
    }

    @Override
    protected InputStream getInputStreamFromBlob(ResultSet resultSet, int columnIndex, Blob blob, Metadata m) throws SQLException {
        return TikaInputStream.get(resultSet.getBytes(columnIndex), m);
    }

    @Override
    protected void handleInteger(String columnTypeName, ResultSet rs, int columnIndex, ContentHandler handler) throws SQLException, SAXException {
        if (columnTypeName.equals("TIMESTAMP")) {
            this.addAllCharacters(this.parseDateFromLongString(rs.getString(columnIndex)), handler);
        } else {
            this.addAllCharacters(Integer.toString(rs.getInt(columnIndex)), handler);
        }
    }

    private String parseDateFromLongString(String longString) throws SAXException {
        Date d = new Date(Long.parseLong(longString));
        return this.dateFormat.format(d);
    }
}

