/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.html;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.tika.config.ServiceLoader;
import org.apache.tika.detect.AutoDetectReader;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.CloseShieldInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.html.DefaultHtmlMapper;
import org.apache.tika.parser.html.HtmlHandler;
import org.apache.tika.parser.html.HtmlMapper;
import org.apache.tika.parser.html.XHTMLDowngradeHandler;
import org.ccil.cowan.tagsoup.HTMLSchema;
import org.ccil.cowan.tagsoup.Parser;
import org.ccil.cowan.tagsoup.Schema;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class HtmlParser
extends AbstractParser {
    private static final long serialVersionUID = 7895315240498733128L;
    private static final MediaType XHTML = MediaType.application("xhtml+xml");
    private static final MediaType WAP_XHTML = MediaType.application("vnd.wap.xhtml+xml");
    private static final MediaType X_ASP = MediaType.application("x-asp");
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.unmodifiableSet(new HashSet<MediaType>(Arrays.asList(MediaType.text("html"), XHTML, WAP_XHTML, X_ASP)));
    private static final ServiceLoader LOADER = new ServiceLoader(HtmlParser.class.getClassLoader());
    private static final Schema HTML_SCHEMA = new HTMLSchema();

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        try (AutoDetectReader reader = new AutoDetectReader(new CloseShieldInputStream(stream), metadata, context.get(ServiceLoader.class, LOADER));){
            Charset charset = reader.getCharset();
            String previous = metadata.get("Content-Type");
            MediaType contentType = null;
            if (previous == null || previous.startsWith("text/html")) {
                contentType = new MediaType(MediaType.TEXT_HTML, charset);
            } else if (previous.startsWith("application/xhtml+xml")) {
                contentType = new MediaType(XHTML, charset);
            } else if (previous.startsWith("application/vnd.wap.xhtml+xml")) {
                contentType = new MediaType(WAP_XHTML, charset);
            } else if (previous.startsWith("application/x-asp")) {
                contentType = new MediaType(X_ASP, charset);
            }
            if (contentType != null) {
                metadata.set("Content-Type", contentType.toString());
            }
            metadata.set("Content-Encoding", charset.name());
            HtmlMapper mapper = context.get(HtmlMapper.class, new HtmlParserMapper());
            Parser parser = new Parser();
            Schema schema = context.get(Schema.class, HTML_SCHEMA);
            parser.setProperty("http://www.ccil.org/~cowan/tagsoup/properties/schema", (Object)schema);
            parser.setFeature("http://www.ccil.org/~cowan/tagsoup/features/ignore-bogons", true);
            parser.setContentHandler((ContentHandler)new XHTMLDowngradeHandler(new HtmlHandler(mapper, handler, metadata)));
            parser.parse(reader.asInputSource());
        }
    }

    protected String mapSafeElement(String name) {
        return DefaultHtmlMapper.INSTANCE.mapSafeElement(name);
    }

    protected boolean isDiscardElement(String name) {
        return DefaultHtmlMapper.INSTANCE.isDiscardElement(name);
    }

    public String mapSafeAttribute(String elementName, String attributeName) {
        return DefaultHtmlMapper.INSTANCE.mapSafeAttribute(elementName, attributeName);
    }

    private class HtmlParserMapper
    implements HtmlMapper {
        private HtmlParserMapper() {
        }

        @Override
        public String mapSafeElement(String name) {
            return HtmlParser.this.mapSafeElement(name);
        }

        @Override
        public boolean isDiscardElement(String name) {
            return HtmlParser.this.isDiscardElement(name);
        }

        @Override
        public String mapSafeAttribute(String elementName, String attributeName) {
            return HtmlParser.this.mapSafeAttribute(elementName, attributeName);
        }
    }
}

