/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.subscriptions.test;

import com.liferay.portal.util.test.MailServiceTestUtil;
import com.liferay.portlet.subscriptions.test.BaseSubscriptionTestCase;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseSubscriptionBaseModelTestCase
extends BaseSubscriptionTestCase {
    @Test
    public void testSubscriptionBaseModelWhenInContainerModel() throws Exception {
        long containerModelId = this.addContainerModel(this.creatorUser.getUserId(), 0L);
        long baseModelId = this.addBaseModel(this.creatorUser.getUserId(), containerModelId);
        this.addSubscriptionBaseModel(baseModelId);
        this.updateBaseModel(this.creatorUser.getUserId(), baseModelId);
        Assert.assertEquals((long)1L, (long)MailServiceTestUtil.getInboxSize());
    }

    @Test
    public void testSubscriptionBaseModelWhenInNoViewableContainerModel() throws Exception {
        long containerModelId = this.addContainerModel(this.creatorUser.getUserId(), 0L);
        long baseModelId = this.addBaseModel(this.creatorUser.getUserId(), containerModelId);
        this.addSubscriptionBaseModel(baseModelId);
        this.removeContainerModelResourceViewPermission();
        this.updateBaseModel(this.creatorUser.getUserId(), baseModelId);
        Assert.assertEquals((long)0L, (long)MailServiceTestUtil.getInboxSize());
    }

    @Test
    public void testSubscriptionBaseModelWhenInRootContainerModel() throws Exception {
        long baseModelId = this.addBaseModel(this.creatorUser.getUserId(), 0L);
        this.addSubscriptionBaseModel(baseModelId);
        this.updateBaseModel(this.creatorUser.getUserId(), baseModelId);
        Assert.assertEquals((long)1L, (long)MailServiceTestUtil.getInboxSize());
    }

    protected abstract void addSubscriptionBaseModel(long var1) throws Exception;

    protected abstract void removeContainerModelResourceViewPermission() throws Exception;
}

