/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.social.test;

import com.liferay.portal.events.ServicePreAction;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.test.rule.DeleteAfterTestRun;
import com.liferay.portal.kernel.test.util.GroupTestUtil;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.social.kernel.model.SocialActivity;
import com.liferay.social.kernel.model.SocialActivityFeedEntry;
import com.liferay.social.kernel.model.SocialActivityInterpreter;
import com.liferay.social.kernel.service.SocialActivityLocalServiceUtil;
import com.liferay.trash.kernel.util.TrashUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public abstract class BaseSocialActivityInterpreterTestCase {
    @DeleteAfterTestRun
    protected Group group;
    protected ServiceContext serviceContext;

    @Before
    public void setUp() throws Exception {
        this.group = GroupTestUtil.addGroup();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setAttribute("COMPANY_ID", (Object)TestPropsValues.getCompanyId());
        request.setAttribute("CURRENT_URL", (Object)"http://localhost:80/web/guest/home");
        request.setAttribute("USER", (Object)TestPropsValues.getUser());
        ServicePreAction servicePreAction = new ServicePreAction();
        ThemeDisplay themeDisplay = servicePreAction.initThemeDisplay((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        request.setAttribute("LIFERAY_SHARED_THEME_DISPLAY", (Object)themeDisplay);
        this.serviceContext = ServiceContextFactory.getInstance((HttpServletRequest)request);
    }

    @Test
    public void testActivityInterpreter() throws Exception {
        this.addActivities();
        long time = System.currentTimeMillis();
        this.renameModels();
        if (this.isSupportsTrash()) {
            this.moveModelsToTrash();
            this.checkLinks();
            this.restoreModelsFromTrash();
        }
        this.checkInterpret(time);
    }

    protected abstract void addActivities() throws Exception;

    protected void checkInterpret(long time) throws Exception {
        List<SocialActivity> activities = this.getActivities();
        Assert.assertFalse((boolean)activities.isEmpty());
        HashMap<String, String> entryTitles = new HashMap<String, String>();
        SocialActivityInterpreter activityInterpreter = this.getActivityInterpreter();
        for (SocialActivity activity : activities) {
            String title = activity.getExtraDataValue("title", this.serviceContext.getLocale());
            if (this.isSupportsRename(activity.getClassName()) && Validator.isNotNull((String)title)) {
                if (activity.getCreateDate() < time) {
                    entryTitles.put(activity.getClassName(), title);
                } else {
                    Assert.assertNotNull(entryTitles.get(activity.getClassName()));
                    Assert.assertNotEquals(entryTitles.get(activity.getClassName()), (Object)title);
                }
            }
            if (!this.hasClassName(activityInterpreter, activity.getClassName()) || !this.hasActivityType(activity.getType())) continue;
            SocialActivityFeedEntry activityFeedEntry = activityInterpreter.interpret(activity, this.serviceContext);
            Assert.assertNotNull((Object)activityFeedEntry);
            title = activityFeedEntry.getTitle();
            Assert.assertFalse((String)("Title contains parameters: " + title), (boolean)title.matches("\\{\\d\\}"));
        }
    }

    protected void checkLinks() throws Exception {
        List<SocialActivity> activities = this.getActivities();
        Assert.assertFalse((boolean)activities.isEmpty());
        SocialActivityInterpreter activityInterpreter = this.getActivityInterpreter();
        for (SocialActivity activity : activities) {
            if (!this.hasClassName(activityInterpreter, activity.getClassName()) || !this.hasActivityType(activity.getType())) continue;
            SocialActivityFeedEntry activityFeedEntry = activityInterpreter.interpret(activity, this.serviceContext);
            PortletURL portletURL = TrashUtil.getViewContentURL((HttpServletRequest)this.serviceContext.getRequest(), (String)activity.getClassName(), (long)activity.getClassPK());
            if (Validator.isNull((String)activityFeedEntry.getLink()) && portletURL == null) continue;
            Assert.assertEquals((Object)portletURL.toString(), (Object)activityFeedEntry.getLink());
        }
    }

    protected List<SocialActivity> getActivities() throws Exception {
        ArrayList<SocialActivity> activities = new ArrayList<SocialActivity>(SocialActivityLocalServiceUtil.getGroupActivities((long)this.group.getGroupId(), (int)-1, (int)-1));
        Collections.reverse(activities);
        return activities;
    }

    protected abstract SocialActivityInterpreter getActivityInterpreter();

    protected SocialActivityInterpreter getActivityInterpreter(String portletId, String className) {
        try {
            Registry registry = RegistryUtil.getRegistry();
            Collection socialActivityInterpreters = registry.getServices(SocialActivityInterpreter.class, "(javax.portlet.name=" + portletId + ")");
            for (SocialActivityInterpreter socialActivityInterpreter : socialActivityInterpreters) {
                if (!ArrayUtil.contains((Object[])socialActivityInterpreter.getClassNames(), (Object)className)) continue;
                return socialActivityInterpreter;
            }
            throw new IllegalStateException("No activity interpreter found for class " + className);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract int[] getActivityTypes();

    protected boolean hasActivityType(int activityType) {
        for (int curActivityType : this.getActivityTypes()) {
            if (curActivityType != activityType) continue;
            return true;
        }
        return false;
    }

    protected boolean hasClassName(SocialActivityInterpreter activityInterpreter, String className) {
        for (String curClassName : activityInterpreter.getClassNames()) {
            if (!curClassName.equals(className)) continue;
            return true;
        }
        return false;
    }

    protected boolean isSupportsRename(String className) {
        return true;
    }

    protected boolean isSupportsTrash() {
        return true;
    }

    protected abstract void moveModelsToTrash() throws Exception;

    protected abstract void renameModels() throws Exception;

    protected abstract void restoreModelsFromTrash() throws Exception;
}

