/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify.test;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.test.ReflectionTestUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.verify.VerifyException;
import com.liferay.portal.verify.VerifyProcess;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public abstract class BaseVerifyProcessTestCase {
    private final Queue<ObjectValuePair<Connection, Exception>> _objectValuePairs = new ConcurrentLinkedQueue<ObjectValuePair<Connection, Exception>>();
    private DataAccess.PACL _pacl;

    @Before
    public void setUp() throws Exception {
        this._pacl = (DataAccess.PACL)ReflectionTestUtil.getFieldValue(DataAccess.class, (String)"_pacl");
        ReflectionTestUtil.setFieldValue(DataAccess.class, (String)"_pacl", (Object)new PACLWrapper(this._pacl));
    }

    @After
    public void tearDown() throws Exception {
        if (this._pacl == null) {
            throw new NullPointerException();
        }
        ReflectionTestUtil.setFieldValue(DataAccess.class, (String)"_pacl", (Object)this._pacl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVerify() throws Exception {
        block7: {
            Throwable exception = null;
            try {
                this.doVerify();
            }
            catch (VerifyException ve) {
                exception = ve;
            }
            finally {
                for (ObjectValuePair objectValuePair : this._objectValuePairs) {
                    Connection connection = (Connection)objectValuePair.getKey();
                    if (connection.isClosed()) continue;
                    if (exception == null) {
                        exception = (Exception)objectValuePair.getValue();
                        continue;
                    }
                    exception.addSuppressed((Throwable)objectValuePair.getValue());
                }
                if (exception == null) break block7;
                throw exception;
            }
        }
    }

    protected void doVerify() throws VerifyException {
        VerifyProcess verifyProcess = this.getVerifyProcess();
        verifyProcess.verify();
    }

    protected abstract VerifyProcess getVerifyProcess();

    private class PACLWrapper
    implements DataAccess.PACL {
        private final DataAccess.PACL _pacl;

        public DataSource getDataSource() {
            return this._wrapDataSource(this._pacl.getDataSource());
        }

        public DataSource getDataSource(String location) throws NamingException {
            return this._wrapDataSource(this._pacl.getDataSource(location));
        }

        private PACLWrapper(DataAccess.PACL pacl) {
            this._pacl = pacl;
        }

        private DataSource _wrapDataSource(DataSource dataSource) {
            return (DataSource)ProxyUtil.newProxyInstance((ClassLoader)ClassLoader.getSystemClassLoader(), (Class[])new Class[]{DataSource.class}, (InvocationHandler)new DataSourceInvocationHandler(dataSource));
        }
    }

    private class DataSourceInvocationHandler
    implements InvocationHandler {
        private final Object _instance;

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                Object result = method.invoke(this._instance, args);
                if (result instanceof Connection) {
                    BaseVerifyProcessTestCase.this._objectValuePairs.add(new ObjectValuePair((Object)((Connection)result), (Object)new Exception("Caught an unclosed exception")));
                }
                return result;
            }
            catch (InvocationTargetException ite) {
                throw ite.getTargetException();
            }
        }

        private DataSourceInvocationHandler(Object instance) {
            this._instance = instance;
        }
    }
}

