/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify.test;

import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.settings.CompanyServiceSettingsLocator;
import com.liferay.portal.kernel.settings.ModifiableSettings;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.settings.SettingsException;
import com.liferay.portal.kernel.settings.SettingsFactory;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.PrefsProps;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.verify.VerifyException;
import com.liferay.portal.verify.VerifyProcess;
import com.liferay.portal.verify.test.BaseVerifyProcessTestCase;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import java.util.List;
import javax.portlet.PortletPreferences;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class BaseCompanySettingsVerifyProcessTestCase
extends BaseVerifyProcessTestCase {
    protected CompanyLocalService companyLocalService;
    protected PrefsProps prefsProps;
    protected SettingsFactory settingsFactory;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        Registry registry = RegistryUtil.getRegistry();
        ServiceReference companyLocalServiceReference = registry.getServiceReference(CompanyLocalService.class);
        this.companyLocalService = (CompanyLocalService)registry.getService(companyLocalServiceReference);
        ServiceReference prefsPropsServiceReference = registry.getServiceReference(PrefsProps.class);
        this.prefsProps = (PrefsProps)registry.getService(prefsPropsServiceReference);
        ServiceReference configurationAdminServiceReference = registry.getServiceReference(SettingsFactory.class);
        this.settingsFactory = (SettingsFactory)registry.getService(configurationAdminServiceReference);
        UnicodeProperties properties = new UnicodeProperties();
        this.populateLegacyProperties(properties);
        List companies = this.companyLocalService.getCompanies(false);
        for (Company company : companies) {
            this.companyLocalService.updatePreferences(company.getCompanyId(), properties);
        }
    }

    @Override
    @After
    public void tearDown() throws Exception {
        List companies = this.companyLocalService.getCompanies(false);
        for (Company company : companies) {
            Settings settings = this.getSettings(company.getCompanyId());
            ModifiableSettings modifiableSettings = settings.getModifiableSettings();
            modifiableSettings.reset();
            modifiableSettings.store();
        }
        super.tearDown();
    }

    @Override
    protected void doVerify() throws VerifyException {
        super.doVerify();
        List companies = this.companyLocalService.getCompanies(false);
        for (Company company : companies) {
            PortletPreferences portletPreferences = this.prefsProps.getPreferences(company.getCompanyId(), true);
            Settings settings = this.getSettings(company.getCompanyId());
            Assert.assertNotNull((Object)settings);
            this.doVerify(portletPreferences, settings);
        }
    }

    protected abstract void doVerify(PortletPreferences var1, Settings var2);

    protected Settings getSettings(long companyId) {
        try {
            Settings settings = this.settingsFactory.getSettings((SettingsLocator)new CompanyServiceSettingsLocator(companyId, this.getSettingsId()));
            return settings;
        }
        catch (SettingsException se) {
            throw new IllegalStateException(se);
        }
    }

    protected abstract String getSettingsId();

    @Override
    protected VerifyProcess getVerifyProcess() {
        try {
            Registry registry = RegistryUtil.getRegistry();
            Object[] serviceReferences = registry.getServiceReferences(VerifyProcess.class.getName(), "(&(objectClass=" + VerifyProcess.class.getName() + ")(verify.process.name=" + this.getVerifyProcessName() + "))");
            if (ArrayUtil.isEmpty((Object[])serviceReferences)) {
                throw new IllegalStateException("Unable to get verify process");
            }
            return (VerifyProcess)registry.getService((ServiceReference)serviceReferences[0]);
        }
        catch (Exception ise) {
            throw new IllegalStateException("Unable to get verify process");
        }
    }

    protected abstract String getVerifyProcessName();

    protected abstract void populateLegacyProperties(UnicodeProperties var1);
}

