/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.test.rule.callback;

import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.test.rule.callback.BaseTestCallback;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.test.rule.callback.SybaseDump;
import com.liferay.portal.test.rule.callback.SybaseDumpTransactionLog;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.junit.runner.Description;

public class SybaseDumpTransactionLogTestCallback
extends BaseTestCallback<Void, Void> {
    public static final SybaseDumpTransactionLogTestCallback INSTANCE = new SybaseDumpTransactionLogTestCallback();

    public Void beforeClass(Description description) throws SQLException {
        SybaseDump[] sybaseDumps;
        SybaseDumpTransactionLog sybaseDumpTransactionLog = (SybaseDumpTransactionLog)description.getAnnotation(SybaseDumpTransactionLog.class);
        if (sybaseDumpTransactionLog != null && !ArrayUtil.contains((Object[])(sybaseDumps = sybaseDumpTransactionLog.dumpBefore()), (Object)((Object)SybaseDump.CLASS))) {
            return null;
        }
        this._dumpTransactionLog();
        return null;
    }

    public Void beforeMethod(Description description, Object target) throws SQLException {
        SybaseDump[] sybaseDumps;
        Class testClass = description.getTestClass();
        SybaseDumpTransactionLog sybaseDumpTransactionLog = testClass.getAnnotation(SybaseDumpTransactionLog.class);
        if (sybaseDumpTransactionLog != null && ArrayUtil.contains((Object[])(sybaseDumps = sybaseDumpTransactionLog.dumpBefore()), (Object)((Object)SybaseDump.METHOD))) {
            this._dumpTransactionLog();
        }
        return null;
    }

    private SybaseDumpTransactionLogTestCallback() {
    }

    private void _dumpTransactionLog() throws SQLException {
        DB db = DBManagerUtil.getDB();
        if (db.getDBType() != DBType.SYBASE) {
            return;
        }
        try (Connection connection = DataAccess.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute("dump transaction " + connection.getCatalog() + " with no_log");
        }
    }
}

