/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.test.rule.callback;

import com.liferay.portal.kernel.io.unsync.UnsyncPrintWriter;
import com.liferay.portal.kernel.test.rule.callback.BaseTestCallback;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.hsqldb.server.Server;
import org.junit.runner.Description;

public class HypersonicServerTestCallback
extends BaseTestCallback<Server, Object> {
    public static final String DATABASE_URL_BASE = "jdbc:hsqldb:hsql://localhost/";
    private static final String _HYPERSONIC_TEMP_DIR_NAME = PropsValues.LIFERAY_HOME + "/data/hypersonic_temp/";
    private final String _databaseName;

    public HypersonicServerTestCallback(String databaseName) {
        this._databaseName = databaseName;
    }

    public void afterClass(Description description, Server server) throws Exception {
        try (Connection connection = DriverManager.getConnection(DATABASE_URL_BASE + this._databaseName, "sa", "");
             Statement statement = connection.createStatement();){
            statement.execute("SHUTDOWN COMPACT");
        }
        server.stop();
        this.deleteFolder(Paths.get(_HYPERSONIC_TEMP_DIR_NAME, new String[0]));
    }

    public Server beforeClass(Description description) throws Exception {
        final CountDownLatch startCountDownLatch = new CountDownLatch(1);
        Server server = new Server(){
            private final CountDownLatch _shutdownCountDownLatch = new CountDownLatch(1);

            /*
             * Exception decompiling
             */
            public int stop() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            protected synchronized void setState(int state) {
                super.setState(state);
                if (state == 1) {
                    startCountDownLatch.countDown();
                } else if (state == 16) {
                    this._shutdownCountDownLatch.countDown();
                }
            }
        };
        try (Connection connection = DriverManager.getConnection(PropsValues.JDBC_DEFAULT_URL, "sa", "");
             Statement statement = connection.createStatement();){
            statement.execute("BACKUP DATABASE TO '" + _HYPERSONIC_TEMP_DIR_NAME + "' BLOCKING AS FILES");
        }
        server.setErrWriter((PrintWriter)new UnsyncPrintWriter(new File(_HYPERSONIC_TEMP_DIR_NAME, this._databaseName + ".err.log")));
        server.setLogWriter((PrintWriter)new UnsyncPrintWriter(new File(_HYPERSONIC_TEMP_DIR_NAME, this._databaseName + ".std.log")));
        server.setDatabaseName(0, this._databaseName);
        server.setDatabasePath(0, _HYPERSONIC_TEMP_DIR_NAME + this._databaseName);
        server.start();
        if (!startCountDownLatch.await(1L, TimeUnit.MINUTES)) {
            throw new IllegalStateException("Unable to start up Hypersonic " + this._databaseName);
        }
        return server;
    }

    protected void copyFile(String fileName, Path fromFolderPath, Path toFolderPath) throws IOException {
        Path filePath = fromFolderPath.resolve(fileName);
        if (Files.exists(filePath, new LinkOption[0])) {
            Files.createDirectories(toFolderPath, new FileAttribute[0]);
            Files.copy(filePath, toFolderPath.resolve(fileName), new CopyOption[0]);
        }
    }

    protected void deleteFolder(Path folderPath) throws IOException {
        if (!Files.exists(folderPath, new LinkOption[0])) {
            return;
        }
        Files.walkFileTree(folderPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path dirPath, IOException ioe) throws IOException {
                if (ioe != null) {
                    throw ioe;
                }
                Files.delete(dirPath);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path filePath, BasicFileAttributes basicFileAttributes) throws IOException {
                Files.delete(filePath);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    static /* synthetic */ String access$000(HypersonicServerTestCallback x0) {
        return x0._databaseName;
    }
}

