/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.test.rule.callback;

import com.liferay.portal.kernel.test.rule.callback.BaseTestCallback;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import org.junit.Assert;
import org.junit.runner.Description;

public class CITimeoutTestCallback
extends BaseTestCallback<Long, Object> {
    public static final CITimeoutTestCallback INSTANCE = new CITimeoutTestCallback();
    private static final String _CI_TIMEOUT_TEST_CLASS_MESSAGE = "CI_TIMEOUT_TEST_CLASS_MESSAGE";

    public void afterClass(Description description, Long startTime) {
        long testTime = System.currentTimeMillis() - startTime;
        if (testTime <= TestPropsValues.CI_TEST_TIMEOUT_TIME) {
            return;
        }
        String message = description.getClassName() + " spent " + testTime + "ms and surpassed the timeout threshold " + TestPropsValues.CI_TEST_TIMEOUT_TIME + "ms.";
        System.setProperty(_CI_TIMEOUT_TEST_CLASS_MESSAGE, message);
        Assert.fail((String)(message + " Marked it as failed and aborting subsequent tests."));
    }

    public Long beforeClass(Description description) {
        String message = System.getProperty(_CI_TIMEOUT_TEST_CLASS_MESSAGE);
        if (message != null) {
            Assert.fail((String)("Abort running " + description.getClassName() + " due to : " + message));
        }
        return System.currentTimeMillis();
    }

    private CITimeoutTestCallback() {
    }
}

