/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.test.rule;

import com.liferay.portal.kernel.process.ClassPathUtil;
import com.liferay.portal.kernel.test.rule.AggregateTestRule;
import com.liferay.portal.kernel.test.rule.BaseTestRule;
import com.liferay.portal.kernel.test.rule.callback.CompanyProviderTestCallback;
import com.liferay.portal.kernel.test.rule.callback.DeleteAfterTestRunTestCallback;
import com.liferay.portal.kernel.test.rule.callback.TestCallback;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.test.rule.LogAssertionTestRule;
import com.liferay.portal.test.rule.callback.CITimeoutTestCallback;
import com.liferay.portal.test.rule.callback.ClearThreadLocalTestCallback;
import com.liferay.portal.test.rule.callback.LogAssertionTestCallback;
import com.liferay.portal.test.rule.callback.MainServletTestCallback;
import com.liferay.portal.test.rule.callback.SybaseDumpTransactionLogTestCallback;
import com.liferay.portal.test.rule.callback.UniqueStringRandomizerBumperTestCallback;
import com.liferay.portal.util.InitUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.util.log4j.Log4JUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletContext;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.springframework.mock.web.MockServletContext;

public class LiferayIntegrationTestRule
extends AggregateTestRule {
    private static final TestRule _ciTimeoutTestRule = new BaseTestRule((TestCallback)CITimeoutTestCallback.INSTANCE);
    private static final TestRule _clearThreadLocalTestRule = new BaseTestRule((TestCallback)ClearThreadLocalTestCallback.INSTANCE);
    private static final TestRule _companyProviderTestRule = new BaseTestRule((TestCallback)CompanyProviderTestCallback.INSTANCE);
    private static final TestRule _deleteAfterTestRunTestRule = new BaseTestRule((TestCallback)DeleteAfterTestRunTestCallback.INSTANCE);
    private static final TestRule _mainServletTestRule = new BaseTestRule((TestCallback)MainServletTestCallback.INSTANCE);
    private static final TestRule _springInitializationTestRule = new TestRule(){

        public Statement apply(Statement statement, Description description) {
            return new BaseTestRule.StatementWrapper(statement){

                public void evaluate() throws Throwable {
                    if (!InitUtil.isInitialized()) {
                        ServerDetector.init((String)"tomcat");
                        List configLocations = ListUtil.fromArray((Object[])PropsUtil.getArray((String)"spring.configs"));
                        boolean configureLog4j = false;
                        if (GetterUtil.getBoolean((String)SystemProperties.get((String)"log4j.configure.on.startup"), (boolean)true)) {
                            SystemProperties.set((String)"log4j.configure.on.startup", (String)"false");
                            configureLog4j = true;
                        }
                        ClassPathUtil.initializeClassPaths((ServletContext)new MockServletContext());
                        InitUtil.initWithSpring((List)configLocations, (boolean)true, (boolean)true);
                        if (configureLog4j) {
                            Log4JUtil.configureLog4J((ClassLoader)InitUtil.class.getClassLoader());
                            LogAssertionTestCallback.startAssert(Collections.emptyList());
                        }
                        if (System.getProperty("external-properties") == null) {
                            System.setProperty("external-properties", "portal-test.properties");
                        }
                    }
                    this.statement.evaluate();
                }
            };
        }
    };
    private static final TestRule _sybaseDumpTransactionLogTestRule = new BaseTestRule((TestCallback)SybaseDumpTransactionLogTestCallback.INSTANCE);
    private static final TestRule _uniqueStringRandomizerBumperTestRule = new BaseTestRule((TestCallback)UniqueStringRandomizerBumperTestCallback.INSTANCE);

    public LiferayIntegrationTestRule() {
        super(false, LiferayIntegrationTestRule._getTestRules());
    }

    private static TestRule[] _getTestRules() {
        ArrayList<Object> testRules = new ArrayList<Object>();
        if (System.getenv("JENKINS_HOME") != null) {
            testRules.add(_ciTimeoutTestRule);
        }
        testRules.add((Object)LogAssertionTestRule.INSTANCE);
        testRules.add(_springInitializationTestRule);
        testRules.add(_sybaseDumpTransactionLogTestRule);
        testRules.add(_clearThreadLocalTestRule);
        testRules.add(_uniqueStringRandomizerBumperTestRule);
        testRules.add(_mainServletTestRule);
        testRules.add(_companyProviderTestRule);
        testRules.add(_deleteAfterTestRunTestRule);
        return testRules.toArray(new TestRule[testRules.size()]);
    }
}

