/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.test.rule;

import com.liferay.portal.aspectj.WeavingClassLoader;
import com.liferay.portal.kernel.process.ClassPathUtil;
import com.liferay.portal.kernel.process.ProcessCallable;
import com.liferay.portal.kernel.process.ProcessException;
import com.liferay.portal.kernel.test.ReflectionTestUtil;
import com.liferay.portal.kernel.test.rule.NewEnvTestRule;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.test.rule.AdviseWith;
import com.liferay.util.SerializableUtil;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.List;
import org.aspectj.lang.annotation.Aspect;
import org.junit.runner.Description;

public class AspectJNewEnvTestRule
extends NewEnvTestRule {
    public static final AspectJNewEnvTestRule INSTANCE = new AspectJNewEnvTestRule();

    protected List<String> createArguments(Description description) {
        List arguments = super.createArguments(description);
        AdviseWith adviseWith = (AdviseWith)description.getAnnotation(AdviseWith.class);
        if (adviseWith == null) {
            return arguments;
        }
        Object[] adviceClasses = adviseWith.adviceClasses();
        if (ArrayUtil.isEmpty((Object[])adviceClasses)) {
            return arguments;
        }
        StringBundler sb = new StringBundler(adviceClasses.length * 2 + 1);
        sb.append("-DaspectClasses=");
        for (Object adviceClass : adviceClasses) {
            Aspect aspect = ((Class)adviceClass).getAnnotation(Aspect.class);
            if (aspect == null) {
                throw new IllegalArgumentException("Class " + ((Class)adviceClass).getName() + " is not an aspect");
            }
            sb.append(((Class)adviceClass).getName());
            sb.append(",");
        }
        sb.setIndex(sb.index() - 1);
        arguments.add(sb.toString());
        return arguments;
    }

    protected ClassLoader createClassLoader(Description description) {
        AdviseWith adviseWith = (AdviseWith)description.getAnnotation(AdviseWith.class);
        if (adviseWith == null) {
            return super.createClassLoader(description);
        }
        Object[] adviceClasses = adviseWith.adviceClasses();
        if (ArrayUtil.isEmpty((Object[])adviceClasses)) {
            return super.createClassLoader(description);
        }
        for (Object adviceClass : adviceClasses) {
            Aspect aspect = ((Class)adviceClass).getAnnotation(Aspect.class);
            if (aspect != null) continue;
            throw new IllegalArgumentException("Class " + ((Class)adviceClass).getName() + " is not an aspect");
        }
        String className = description.getClassName();
        File dumpDir = new File(System.getProperty("junit.aspectj.dump"), className.concat(".").concat(description.getMethodName()));
        try {
            return new WeavingClassLoader(ClassPathUtil.getClassPathURLs((String)CLASS_PATH), (Class[])adviceClasses, dumpDir);
        }
        catch (MalformedURLException murle) {
            throw new RuntimeException(murle);
        }
    }

    protected ProcessCallable<Serializable> processProcessCallable(ProcessCallable<Serializable> processCallable, MethodKey methodKey) {
        Class clazz = methodKey.getDeclaringClass();
        String className = clazz.getName();
        File dumpDir = new File(System.getProperty("junit.aspectj.dump"), className.concat(".").concat(methodKey.getMethodName()));
        return new SwitchClassLoaderProcessCallable(processCallable, dumpDir);
    }

    private AspectJNewEnvTestRule() {
    }

    private static class SwitchClassLoaderProcessCallable
    implements ProcessCallable<Serializable> {
        private static final long serialVersionUID = 1L;
        private final File _dumpDir;
        private final byte[] _encodedProcessCallable;
        private final String _toString;

        public SwitchClassLoaderProcessCallable(ProcessCallable<Serializable> processCallable, File dumpDir) {
            this._dumpDir = dumpDir;
            this._encodedProcessCallable = SerializableUtil.serialize(processCallable);
            this._toString = processCallable.toString();
        }

        public Serializable call() throws ProcessException {
            AspectJNewEnvTestRule.attachProcess((String)("Attached " + this.toString()));
            String[] aspectClassNames = StringUtil.split((String)System.getProperty("aspectClasses"));
            Class[] aspectClasses = new Class[aspectClassNames.length];
            Thread currentThread = Thread.currentThread();
            ClassLoader contextClassLoader = currentThread.getContextClassLoader();
            try {
                for (int i = 0; i < aspectClassNames.length; ++i) {
                    aspectClasses[i] = contextClassLoader.loadClass(aspectClassNames[i]);
                }
                WeavingClassLoader weavingClassLoader = new WeavingClassLoader(ClassPathUtil.getClassPathURLs((String)ClassPathUtil.getJVMClassPath((boolean)true)), aspectClasses, this._dumpDir);
                currentThread.setContextClassLoader((ClassLoader)weavingClassLoader);
                Serializable serializable = (Serializable)ReflectionTestUtil.invoke((Object)SerializableUtil.deserialize((byte[])this._encodedProcessCallable, (ClassLoader)weavingClassLoader), (String)"call", (Class[])new Class[0], (Object[])new Object[0]);
                return serializable;
            }
            catch (Exception e) {
                throw new ProcessException((Throwable)e);
            }
            finally {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }

        public String toString() {
            return this._toString;
        }
    }
}

