/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.test.randomizerbumpers;

import com.liferay.portal.kernel.io.DummyWriter;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.test.randomizerbumpers.RandomizerBumper;
import com.liferay.portal.kernel.util.StringBundler;
import java.io.InputStream;
import java.io.Writer;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.WriteOutContentHandler;

public class TikaSafeRandomizerBumper
implements RandomizerBumper<byte[]> {
    public static final TikaSafeRandomizerBumper INSTANCE = new TikaSafeRandomizerBumper(null);
    private static final Log _log = LogFactoryUtil.getLog(TikaSafeRandomizerBumper.class);
    private final String _contentType;

    public TikaSafeRandomizerBumper(String contentType) {
        this._contentType = contentType;
    }

    public boolean accept(byte[] randomValue) {
        try {
            ParseContext parserContext = new ParseContext();
            AutoDetectParser parser = new AutoDetectParser(new TikaConfig());
            parserContext.set(Parser.class, parser);
            Metadata metadata = new Metadata();
            parser.parse((InputStream)new UnsyncByteArrayInputStream(randomValue), new WriteOutContentHandler((Writer)new DummyWriter()), metadata, parserContext);
            if (this._contentType == null) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Accepted: " + TikaSafeRandomizerBumper.byteArrayToString(randomValue)));
                }
                return true;
            }
            String contentType = metadata.get("Content-Type");
            if (contentType.contains(this._contentType)) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Accepted: " + TikaSafeRandomizerBumper.byteArrayToString(randomValue)));
                }
                return true;
            }
            return false;
        }
        catch (Throwable t) {
            return false;
        }
    }

    protected static String byteArrayToString(byte[] byteArray) {
        StringBundler sb = new StringBundler(byteArray.length * 3 + 1);
        sb.append("{");
        for (byte b : byteArray) {
            sb.append("(byte)");
            sb.append((int)b);
            sb.append(", ");
        }
        sb.setIndex(sb.index() - 1);
        sb.append("}");
        return sb.toString();
    }
}

