/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.test;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.messaging.SynchronousDestination;
import com.liferay.portal.kernel.messaging.sender.SynchronousMessageSender;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelper;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelperUtil;
import com.liferay.portal.kernel.search.SearchEngineHelperUtil;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourceActionLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.test.util.RoleTestUtil;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.model.impl.PortletImpl;
import com.liferay.portal.repository.liferayrepository.LiferayRepository;
import com.liferay.portal.service.test.PortalRegisterTestUtil;
import com.liferay.portal.tools.DBUpgrader;
import com.liferay.portal.util.PortalInstances;
import com.liferay.registry.Filter;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.dependency.ServiceDependencyListener;
import com.liferay.registry.dependency.ServiceDependencyManager;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class ServiceTestUtil {
    public static final int RETRY_COUNT = 10;
    public static final int THREAD_COUNT = 10;
    private static final Log _log = LogFactoryUtil.getLog(ServiceTestUtil.class);

    @Deprecated
    public static void addResourcePermission(Role role, String resourceName, int scope, String primKey, String actionId) throws Exception {
        RoleTestUtil.addResourcePermission((Role)role, (String)resourceName, (int)scope, (String)primKey, (String)actionId);
    }

    @Deprecated
    public static void addResourcePermission(String roleName, String resourceName, int scope, String primKey, String actionId) throws Exception {
        RoleTestUtil.addResourcePermission((String)roleName, (String)resourceName, (int)scope, (String)primKey, (String)actionId);
    }

    @Deprecated
    public static Role addRole(String roleName, int roleType) throws Exception {
        return RoleTestUtil.addRole((String)roleName, (int)roleType);
    }

    @Deprecated
    public static Role addRole(String roleName, int roleType, String resourceName, int scope, String primKey, String actionId) throws Exception {
        return RoleTestUtil.addRole((String)roleName, (int)roleType, (String)resourceName, (int)scope, (String)primKey, (String)actionId);
    }

    public static void initMainServletServices() {
        try {
            DBUpgrader.upgrade();
        }
        catch (Throwable t) {
            _log.error((Object)t, t);
        }
        MessageBusUtil messageBusUtil = new MessageBusUtil();
        messageBusUtil.setSynchronousMessageSenderMode(SynchronousMessageSender.Mode.DEFAULT);
        ServiceDependencyManager schedulerServiceDependencyManager = new ServiceDependencyManager();
        schedulerServiceDependencyManager.addServiceDependencyListener(new ServiceDependencyListener(){

            public void dependenciesFulfilled() {
                try {
                    SchedulerEngineHelperUtil.start();
                }
                catch (Exception e) {
                    _log.error((Object)e, (Throwable)e);
                }
            }

            public void destroy() {
            }
        });
        Registry registry = RegistryUtil.getRegistry();
        Filter filter = registry.getFilter("(objectClass=com.liferay.portal.scheduler.quartz.internal.QuartzSchemaManager)");
        schedulerServiceDependencyManager.registerDependencies(new Class[]{SchedulerEngineHelper.class}, new Filter[]{filter});
        try {
            DBUpgrader.verify();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public static void initPermissions() {
        try {
            PortalInstances.addCompanyId((long)TestPropsValues.getCompanyId());
            ServiceTestUtil.setUser(TestPropsValues.getUser());
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public static void initServices() {
        ServiceTestUtil._setThreadLocals();
        try {
            SearchEngineHelperUtil.initialize((long)TestPropsValues.getCompanyId());
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public static void initStaticServices() {
        PortalRegisterTestUtil.registerIndexers();
        if (TestPropsValues.DL_FILE_ENTRY_PROCESSORS_TRIGGER_SYNCHRONOUSLY) {
            ServiceDependencyManager serviceDependencyManager = new ServiceDependencyManager();
            Filter audioProcessorFilter = ServiceTestUtil._registerDestinationFilter("liferay/document_library_audio_processor");
            Filter imageProcessFilter = ServiceTestUtil._registerDestinationFilter("liferay/document_library_image_processor");
            Filter pdfProcessorFilter = ServiceTestUtil._registerDestinationFilter("liferay/document_library_pdf_processor");
            Filter rawMetaDataProcessorFilter = ServiceTestUtil._registerDestinationFilter("liferay/document_library_raw_metadata_processor");
            Filter videoProcessorFilter = ServiceTestUtil._registerDestinationFilter("liferay/document_library_video_processor");
            serviceDependencyManager.registerDependencies(new Filter[]{audioProcessorFilter, imageProcessFilter, pdfProcessorFilter, rawMetaDataProcessorFilter, videoProcessorFilter});
            serviceDependencyManager.waitForDependencies();
            ServiceTestUtil._replaceWithSynchronousDestination("liferay/document_library_audio_processor");
            ServiceTestUtil._replaceWithSynchronousDestination("liferay/document_library_image_processor");
            ServiceTestUtil._replaceWithSynchronousDestination("liferay/document_library_pdf_processor");
            ServiceTestUtil._replaceWithSynchronousDestination("liferay/document_library_raw_metadata_processor");
            ServiceTestUtil._replaceWithSynchronousDestination("liferay/document_library_video_processor");
        }
        ServiceTestUtil._checkClassNames();
        try {
            ServiceTestUtil._checkResourceActions();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        PortalRegisterTestUtil.registerWorkflowHandlers();
        try {
            CompanyLocalServiceUtil.checkCompany((String)TestPropsValues.COMPANY_WEB_ID);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public static Date newDate() throws Exception {
        return new Date();
    }

    public static Date newDate(int month, int day, int year) throws Exception {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(2, month);
        calendar.set(5, day);
        calendar.set(1, year);
        return calendar.getTime();
    }

    public static void setUser(User user) throws Exception {
        if (user == null) {
            return;
        }
        PrincipalThreadLocal.setName((long)user.getUserId());
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
        PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
    }

    private static void _checkClassNames() {
        PortalUtil.getClassNameId((String)LiferayRepository.class.getName());
    }

    private static void _checkResourceActions() throws Exception {
        for (int i = 0; i < 200; ++i) {
            String portletId = String.valueOf(i);
            PortletImpl portlet = new PortletImpl();
            portlet.setPortletId(portletId);
            portlet.setPortletModes(new HashMap());
            List portletActions = ResourceActionsUtil.getPortletResourceActions((String)portletId);
            ResourceActionLocalServiceUtil.checkResourceActions((String)portletId, (List)portletActions);
            List modelNames = ResourceActionsUtil.getPortletModelResources((String)portletId);
            for (String modelName : modelNames) {
                List modelActions = ResourceActionsUtil.getModelResourceActions((String)modelName);
                ResourceActionLocalServiceUtil.checkResourceActions((String)modelName, (List)modelActions);
            }
        }
    }

    private static Filter _registerDestinationFilter(String destinationName) {
        Registry registry = RegistryUtil.getRegistry();
        return registry.getFilter("(&(destination.name=" + destinationName + ")(objectClass=" + Destination.class.getName() + "))");
    }

    private static void _replaceWithSynchronousDestination(String name) {
        SynchronousDestination baseDestination = new SynchronousDestination();
        baseDestination.setName(name);
        MessageBus messageBus = MessageBusUtil.getMessageBus();
        messageBus.replace((Destination)baseDestination);
    }

    private static void _setThreadLocals() {
        LocaleThreadLocal.setThemeDisplayLocale((Locale)new Locale("en", "US"));
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setPathMain("path");
        serviceContext.setPortalURL("http://tests:8080");
        ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
    }
}

