/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.search.dummy.DummyIndexer;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceRegistration;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import com.liferay.registry.collections.StringServiceRegistrationMap;
import com.liferay.registry.collections.StringServiceRegistrationMapImpl;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class TestIndexerRegistry
implements IndexerRegistry {
    private static final Log _log = LogFactoryUtil.getLog(TestIndexerRegistry.class);
    private final Indexer<?> _dummyIndexer = new DummyIndexer();
    private final Map<String, Indexer<? extends Object>> _indexers = new ConcurrentHashMap<String, Indexer<? extends Object>>();
    private final StringServiceRegistrationMap<Indexer<?>> _serviceRegistrations = new StringServiceRegistrationMapImpl();
    private ServiceTracker<Indexer<?>, Indexer<?>> _serviceTracker;

    public TestIndexerRegistry() {
        Registry registry = RegistryUtil.getRegistry();
        this._serviceTracker = registry.trackServices(Indexer.class, (ServiceTrackerCustomizer)new IndexerServiceTrackerCustomizer());
        this._serviceTracker.open();
    }

    public void destroy() {
        if (this._serviceTracker != null) {
            this._serviceTracker.close();
        }
        this._serviceTracker = null;
    }

    public <T> Indexer<T> getIndexer(Class<T> clazz) {
        return this.getIndexer(clazz.getName());
    }

    public <T> Indexer<T> getIndexer(String className) {
        return this._indexers.get(className);
    }

    public Set<Indexer<?>> getIndexers() {
        return new HashSet(this._indexers.values());
    }

    public <T> Indexer<T> nullSafeGetIndexer(Class<T> clazz) {
        return this.nullSafeGetIndexer(clazz.getName());
    }

    public <T> Indexer<T> nullSafeGetIndexer(String className) {
        Indexer<T> indexer = this.getIndexer(className);
        if (indexer != null) {
            return indexer;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("No indexer found for " + className));
        }
        return this._dummyIndexer;
    }

    public void register(Indexer<?> indexer) {
        Registry registry = RegistryUtil.getRegistry();
        ServiceRegistration serviceRegistration = registry.registerService(Indexer.class, indexer);
        this._serviceRegistrations.put((Object)indexer.getClassName(), (Object)serviceRegistration);
    }

    public void unregister(Indexer<?> indexer) {
        this.unregister(indexer.getClassName());
    }

    public void unregister(String className) {
        ServiceRegistration serviceRegistration = (ServiceRegistration)this._serviceRegistrations.remove((Object)className);
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
        }
    }

    private class IndexerServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<Indexer<?>, Indexer<?>> {
        private IndexerServiceTrackerCustomizer() {
        }

        public Indexer<?> addingService(ServiceReference<Indexer<?>> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            Indexer indexer = (Indexer)registry.getService(serviceReference);
            Class<?> clazz = indexer.getClass();
            TestIndexerRegistry.this._indexers.put(clazz.getName(), indexer);
            TestIndexerRegistry.this._indexers.put(indexer.getClassName(), indexer);
            return indexer;
        }

        public void modifiedService(ServiceReference<Indexer<?>> serviceReference, Indexer<?> indexer) {
        }

        public void removedService(ServiceReference<Indexer<?>> serviceReference, Indexer<?> indexer) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            Class<?> clazz = indexer.getClass();
            TestIndexerRegistry.this._indexers.remove(clazz.getName());
            TestIndexerRegistry.this._indexers.remove(indexer.getClassName());
        }
    }
}

