/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.search.SearchResult;
import com.liferay.portal.kernel.search.result.SearchResultTranslator;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.util.FastDateFormatFactory;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.search.test.SearchTestUtil;
import com.liferay.portal.search.test.TestIndexerRegistry;
import com.liferay.registry.BasicRegistryImpl;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.stubbing.Answer;
import org.powermock.api.mockito.PowerMockito;

public abstract class BaseSearchResultUtilTestCase
extends PowerMockito {
    @Mock
    protected AssetRenderer assetRenderer;
    @Mock
    protected AssetRendererFactory<?> assetRendererFactory;
    @Mock
    protected ClassNameLocalService classNameLocalService;
    protected SearchResultTranslator searchResultTranslator;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)((Object)this));
        this.setUpRegistryUtil();
        this.setUpClassNameLocalService();
        this.setUpFastDateFormatFactoryUtil();
        this.setUpIndexerRegistry();
        this.setUpPropsUtil();
        this.setUpSearchResultTranslator();
    }

    protected void assertEmptyCommentRelatedSearchResults(SearchResult searchResult) {
        List commentRelatedSearchResults = searchResult.getCommentRelatedSearchResults();
        Assert.assertTrue((boolean)commentRelatedSearchResults.isEmpty());
    }

    protected void assertEmptyFileEntryRelatedSearchResults(SearchResult searchResult) {
        List fileEntryRelatedSearchResults = searchResult.getFileEntryRelatedSearchResults();
        Assert.assertTrue((boolean)fileEntryRelatedSearchResults.isEmpty());
    }

    protected void assertEmptyVersions(SearchResult searchResult) {
        List versions = searchResult.getVersions();
        Assert.assertTrue((boolean)versions.isEmpty());
    }

    protected SearchResult assertOneSearchResult(Document document) {
        List<SearchResult> searchResults = SearchTestUtil.getSearchResults(this.searchResultTranslator, document);
        Assert.assertEquals((long)1L, (long)searchResults.size());
        return searchResults.get(0);
    }

    protected abstract SearchResultTranslator createSearchResultTranslator();

    protected void setUpClassNameLocalService() throws Exception {
        ClassName className = (ClassName)Mockito.mock(ClassName.class);
        BaseSearchResultUtilTestCase.when((Object)this.classNameLocalService.getClassName(SearchTestUtil.ATTACHMENT_OWNER_CLASS_NAME_ID)).thenReturn((Object)className);
        BaseSearchResultUtilTestCase.when((Object)className.getClassName()).thenReturn((Object)SearchTestUtil.ATTACHMENT_OWNER_CLASS_NAME);
    }

    protected void setUpFastDateFormatFactoryUtil() {
        FastDateFormatFactoryUtil fastDateFormatFactoryUtil = new FastDateFormatFactoryUtil();
        fastDateFormatFactoryUtil.setFastDateFormatFactory((FastDateFormatFactory)BaseSearchResultUtilTestCase.mock(FastDateFormatFactory.class));
    }

    protected void setUpIndexerRegistry() {
        Registry registry = RegistryUtil.getRegistry();
        registry.registerService(IndexerRegistry.class, (Object)new TestIndexerRegistry());
    }

    protected void setUpPropsUtil() {
        PropsUtil.setProps((Props)((Props)Mockito.mock(Props.class)));
    }

    protected void setUpRegistryUtil() {
        RegistryUtil.setRegistry((Registry)new BasicRegistryImpl());
        BaseSearchResultUtilTestCase.mockStatic(AssetRendererFactoryRegistryUtil.class, (Answer)Mockito.CALLS_REAL_METHODS);
    }

    protected void setUpSearchResultTranslator() {
        this.searchResultTranslator = this.createSearchResultTranslator();
    }
}

