/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scripting;

import com.liferay.portal.kernel.scripting.ScriptingExecutor;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolDependencies;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public abstract class ScriptingExecutorTestCase {
    private ScriptingExecutor _scriptingExecutor;

    @BeforeClass
    public static void setUpClass() throws Exception {
        ToolDependencies.wireCaches();
    }

    public abstract String getScriptExtension();

    public abstract ScriptingExecutor getScriptingExecutor();

    @Before
    public void setUp() {
        this._scriptingExecutor = this.getScriptingExecutor();
    }

    @Test
    public void testBindingInputVariables() throws Exception {
        HashMap<String, Object> inputObjects = new HashMap<String, Object>();
        inputObjects.put("variable", "string");
        Set<String> outputNames = Collections.emptySet();
        this.execute(inputObjects, outputNames, "binding-input");
    }

    @Test
    public void testSimpleScript() throws Exception {
        Map<String, Object> inputObjects = Collections.emptyMap();
        Set<String> outputNames = Collections.emptySet();
        this.execute(inputObjects, outputNames, "simple");
    }

    protected Map<String, Object> execute(Map<String, Object> inputObjects, Set<String> outputNames, String fileName) throws Exception {
        String script = this.getScript(fileName + this.getScriptExtension());
        return this._scriptingExecutor.eval(null, inputObjects, outputNames, script);
    }

    protected String getScript(String name) throws IOException {
        Class<?> clazz = this.getClass();
        InputStream inputStream = clazz.getResourceAsStream("dependencies/" + name);
        return StringUtil.read((InputStream)inputStream);
    }
}

