/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar.test;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetLink;
import com.liferay.asset.kernel.service.AssetEntryLocalServiceUtil;
import com.liferay.asset.kernel.service.AssetLinkLocalServiceUtil;
import com.liferay.dynamic.data.mapping.kernel.DDMTemplate;
import com.liferay.exportimport.kernel.configuration.ExportImportConfigurationSettingsMapFactory;
import com.liferay.exportimport.kernel.lar.ExportImportDateUtil;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.PortletDataHandler;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.service.ExportImportConfigurationLocalServiceUtil;
import com.liferay.exportimport.kernel.service.ExportImportLocalServiceUtil;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.template.TemplateHandler;
import com.liferay.portal.kernel.test.util.GroupTestUtil;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.lar.test.BaseExportImportTestCase;
import com.liferay.portal.util.test.LayoutTestUtil;
import com.liferay.portlet.dynamicdatamapping.util.test.DDMTemplateTestUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.portlet.PortletPreferences;
import org.junit.Assert;
import org.junit.Test;

public abstract class BasePortletExportImportTestCase
extends BaseExportImportTestCase {
    public String getNamespace() {
        return null;
    }

    public String getPortletId() throws Exception {
        return null;
    }

    @Test
    public void testExportImportAssetLinks() throws Exception {
        StagedModel stagedModel = this.addStagedModel(this.group.getGroupId());
        StagedModel relatedStagedModel1 = this.addStagedModel(this.group.getGroupId());
        StagedModel relatedStagedModel2 = this.addStagedModel(this.group.getGroupId());
        this.addAssetLink(stagedModel, relatedStagedModel1, 1);
        this.addAssetLink(stagedModel, relatedStagedModel2, 2);
        this.exportImportPortlet(this.getPortletId());
        StagedModel importedStagedModel = this.getStagedModel(this.getStagedModelUuid(stagedModel), this.importedGroup.getGroupId());
        Assert.assertNotNull((Object)importedStagedModel);
        this.validateImportedLinks(stagedModel, importedStagedModel);
    }

    @Test
    public void testExportImportDeletions() throws Exception {
        StagedModel stagedModel = this.addStagedModel(this.group.getGroupId());
        if (stagedModel == null) {
            return;
        }
        String stagedModelUuid = this.getStagedModelUuid(stagedModel);
        this.exportImportPortlet(this.getPortletId());
        this.deleteStagedModel(stagedModel);
        this.exportImportPortlet(this.getPortletId());
        StagedModel importedStagedModel = this.getStagedModel(stagedModelUuid, this.importedGroup.getGroupId());
        Assert.assertNotNull((Object)importedStagedModel);
        LinkedHashMap<String, String[]> exportParameterMap = new LinkedHashMap<String, String[]>();
        exportParameterMap.put("DELETIONS", new String[]{String.valueOf(true)});
        this.exportImportPortlet(this.getPortletId(), exportParameterMap, this.getImportParameterMap());
        importedStagedModel = this.getStagedModel(stagedModelUuid, this.importedGroup.getGroupId());
        Assert.assertNotNull((Object)importedStagedModel);
        LinkedHashMap<String, String[]> importParameterMap = new LinkedHashMap<String, String[]>();
        importParameterMap.put("DELETIONS", new String[]{String.valueOf(true)});
        this.exportImportPortlet(this.getPortletId(), exportParameterMap, importParameterMap);
        try {
            importedStagedModel = this.getStagedModel(stagedModelUuid, this.importedGroup.getGroupId());
            Assert.assertNull((Object)importedStagedModel);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Test
    public void testExportImportDisplayStyleFromCurrentGroup() throws Exception {
        this.testExportImportDisplayStyle(this.group.getGroupId(), "");
    }

    @Test
    public void testExportImportDisplayStyleFromDifferentGroup() throws Exception {
        Group group2 = GroupTestUtil.addGroup();
        this.testExportImportDisplayStyle(group2.getGroupId(), "");
    }

    @Test
    public void testExportImportDisplayStyleFromGlobalScope() throws Exception {
        Group companyGroup = GroupLocalServiceUtil.getCompanyGroup((long)this.group.getCompanyId());
        this.testExportImportDisplayStyle(companyGroup.getGroupId(), "company");
    }

    @Test
    public void testExportImportDisplayStyleFromLayoutScope() throws Exception {
        this.testExportImportDisplayStyle(this.group.getGroupId(), "layout");
    }

    @Test
    public void testExportImportInvalidAvailableLocales() throws Exception {
        this.testExportImportAvailableLocales(Arrays.asList(LocaleUtil.US, LocaleUtil.SPAIN), Arrays.asList(LocaleUtil.US, LocaleUtil.GERMANY), true);
    }

    @Test
    public void testExportImportValidAvailableLocales() throws Exception {
        this.testExportImportAvailableLocales(Arrays.asList(LocaleUtil.US, LocaleUtil.SPAIN), Arrays.asList(LocaleUtil.US, LocaleUtil.SPAIN, LocaleUtil.GERMANY), false);
    }

    @Test
    public void testUpdateLastPublishDate() throws Exception {
        Date lastPublishDate = new Date(System.currentTimeMillis() - 3600000L);
        Date stagedModelCreationDate = new Date(lastPublishDate.getTime() + 60000L);
        StagedModel stagedModel = this.addStagedModel(this.group.getGroupId(), stagedModelCreationDate);
        if (stagedModel == null) {
            return;
        }
        LayoutTestUtil.addPortletToLayout(TestPropsValues.getUserId(), this.layout, this.getPortletId(), "column-1", new HashMap<String, String[]>());
        PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.getStrictPortletSetup((Layout)this.layout, (String)this.getPortletId());
        portletPreferences.setValue("last-publish-date", String.valueOf(lastPublishDate.getTime()));
        portletPreferences.store();
        LinkedHashMap<String, String[]> exportParameterMap = new LinkedHashMap<String, String[]>();
        exportParameterMap.put("UPDATE_LAST_PUBLISH_DATE", new String[]{String.valueOf(true)});
        exportParameterMap.put("range", new String[]{"fromLastPublishDate"});
        LinkedHashMap<String, String[]> importParameterMap = new LinkedHashMap<String, String[]>();
        portletPreferences = PortletPreferencesFactoryUtil.getStrictPortletSetup((Layout)this.layout, (String)this.getPortletId());
        Date oldLastPublishDate = ExportImportDateUtil.getLastPublishDate((PortletPreferences)portletPreferences);
        this.exportImportPortlet(this.getPortletId(), exportParameterMap, importParameterMap);
        portletPreferences = PortletPreferencesFactoryUtil.getStrictPortletSetup((Layout)this.layout, (String)this.getPortletId());
        Date newLastPublishDate = ExportImportDateUtil.getLastPublishDate((PortletPreferences)portletPreferences);
        Assert.assertTrue((boolean)newLastPublishDate.after(oldLastPublishDate));
        StagedModel importedStagedModel = this.getStagedModel(this.getStagedModelUuid(stagedModel), this.importedGroup.getGroupId());
        Assert.assertNotNull((Object)importedStagedModel);
    }

    @Test
    public void testVersioning1() throws Exception {
        if (!this.isVersioningEnabled()) {
            return;
        }
        StagedModel stagedModel = this.addStagedModel(this.group.getGroupId());
        this.addVersion(stagedModel);
        this.exportImportPortlet(this.getPortletId());
        this.validateVersions();
    }

    @Test
    public void testVersioning2() throws Exception {
        if (!this.isVersioningEnabled()) {
            return;
        }
        StagedModel stagedModel = this.addStagedModel(this.group.getGroupId());
        Thread.sleep(4000L);
        this.exportImportPortlet(this.getPortletId());
        this.validateVersions();
        this.addVersion(stagedModel);
        this.exportImportPortlet(this.getPortletId());
        this.validateVersions();
    }

    @Test
    public void testVersioningDeleteFirst() throws Exception {
        if (!this.isVersioningEnabled()) {
            return;
        }
        StagedModel stagedModel = this.addStagedModel(this.group.getGroupId());
        stagedModel = this.addVersion(stagedModel);
        this.exportImportPortlet(this.getPortletId());
        this.validateVersions();
        this.deleteFirstVersion(stagedModel);
        this.exportImportPortlet(this.getPortletId());
        this.validateVersions();
    }

    @Test
    public void testVersioningDeleteLatest() throws Exception {
        if (!this.isVersioningEnabled()) {
            return;
        }
        StagedModel stagedModel = this.addStagedModel(this.group.getGroupId());
        stagedModel = this.addVersion(stagedModel);
        this.exportImportPortlet(this.getPortletId());
        this.validateVersions();
        this.deleteLatestVersion(stagedModel);
        this.exportImportPortlet(this.getPortletId());
        this.validateVersions();
    }

    @Test
    public void testVersioningExportImportTwice() throws Exception {
        if (!this.isVersioningEnabled()) {
            return;
        }
        StagedModel stagedModel = this.addStagedModel(this.group.getGroupId());
        this.addVersion(stagedModel);
        this.exportImportPortlet(this.getPortletId());
        this.validateVersions();
        this.exportImportPortlet(this.getPortletId());
        this.validateVersions();
    }

    protected void addParameter(Map<String, String[]> parameterMap, String name, boolean value) {
        this.addParameter(parameterMap, this.getNamespace(), name, value);
    }

    protected StagedModel addVersion(StagedModel stagedModel) throws Exception {
        return null;
    }

    protected void deleteFirstVersion(StagedModel stagedModel) throws Exception {
    }

    protected void deleteLatestVersion(StagedModel stagedModel) throws Exception {
    }

    protected void exportImportPortlet(String portletId) throws Exception {
        this.exportImportPortlet(portletId, new LinkedHashMap<String, String[]>(), new LinkedHashMap<String, String[]>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportImportPortlet(String portletId, Map<String, String[]> exportParameterMap, Map<String, String[]> importParameterMap) throws Exception {
        User user = TestPropsValues.getUser();
        MapUtil.merge(this.getExportParameterMap(), exportParameterMap);
        Map settingsMap = ExportImportConfigurationSettingsMapFactory.buildExportPortletSettingsMap((User)user, (long)this.layout.getPlid(), (long)this.layout.getGroupId(), (String)portletId, exportParameterMap, (String)"");
        ExportImportConfiguration exportImportConfiguration = ExportImportConfigurationLocalServiceUtil.addDraftExportImportConfiguration((long)user.getUserId(), (int)5, (Map)settingsMap);
        ExportImportThreadLocal.setPortletStagingInProcess((boolean)true);
        try {
            this.larFile = ExportImportLocalServiceUtil.exportPortletInfoAsFile((ExportImportConfiguration)exportImportConfiguration);
            this.importedLayout = LayoutTestUtil.addLayout(this.importedGroup);
            MapUtil.merge(this.getImportParameterMap(), importParameterMap);
            settingsMap = ExportImportConfigurationSettingsMapFactory.buildImportPortletSettingsMap((User)user, (long)this.importedLayout.getPlid(), (long)this.importedGroup.getGroupId(), (String)portletId, importParameterMap);
            exportImportConfiguration = ExportImportConfigurationLocalServiceUtil.addExportImportConfiguration((long)user.getUserId(), (long)this.importedGroup.getGroupId(), (String)"", (String)"", (int)7, (Map)settingsMap, (int)2, (ServiceContext)new ServiceContext());
            ExportImportLocalServiceUtil.importPortletDataDeletions((ExportImportConfiguration)exportImportConfiguration, (File)this.larFile);
            ExportImportLocalServiceUtil.importPortletInfo((ExportImportConfiguration)exportImportConfiguration, (File)this.larFile);
        }
        finally {
            ExportImportThreadLocal.setPortletStagingInProcess((boolean)false);
        }
    }

    protected PortletPreferences getImportedPortletPreferences(Map<String, String[]> preferenceMap) throws Exception {
        String portletId = LayoutTestUtil.addPortletToLayout(TestPropsValues.getUserId(), this.layout, this.getPortletId(), "column-1", preferenceMap);
        this.exportImportPortlet(portletId);
        return LayoutTestUtil.getPortletPreferences(this.importedLayout, portletId);
    }

    protected boolean isVersioningEnabled() {
        return false;
    }

    protected void testExportImportAvailableLocales(Collection<Locale> sourceAvailableLocales, Collection<Locale> targetAvailableLocales, boolean expectFailure) throws Exception {
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)this.group.getCompanyId(), (String)this.getPortletId());
        if (portlet == null) {
            return;
        }
        PortletDataHandler portletDataHandler = portlet.getPortletDataHandlerInstance();
        if (!portletDataHandler.isDataLocalized()) {
            Assert.assertTrue((String)"This test does not apply", (boolean)true);
            return;
        }
        GroupTestUtil.updateDisplaySettings((long)this.group.getGroupId(), sourceAvailableLocales, null);
        GroupTestUtil.updateDisplaySettings((long)this.importedGroup.getGroupId(), targetAvailableLocales, null);
        try {
            this.exportImportPortlet(this.getPortletId());
            Assert.assertFalse((boolean)expectFailure);
        }
        catch (LocaleException le) {
            Assert.assertTrue((boolean)expectFailure);
        }
    }

    protected void testExportImportDisplayStyle(long displayStyleGroupId, String scopeType) throws Exception {
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)this.group.getCompanyId(), (String)this.getPortletId());
        if (portlet == null) {
            return;
        }
        if (scopeType.equals("layout") && !portlet.isScopeable()) {
            Assert.assertTrue((String)"This test does not apply", (boolean)true);
            return;
        }
        TemplateHandler templateHandler = portlet.getTemplateHandlerInstance();
        if (templateHandler == null) {
            Assert.assertTrue((String)"This test does not apply", (boolean)true);
            return;
        }
        String className = templateHandler.getClassName();
        long resourceClassNameId = PortalUtil.getClassNameId((String)"com.liferay.portlet.display.template.PortletDisplayTemplate");
        DDMTemplate ddmTemplate = DDMTemplateTestUtil.addTemplate((long)displayStyleGroupId, (long)PortalUtil.getClassNameId((String)className), (long)0L, (long)resourceClassNameId);
        HashMap<String, String[]> preferenceMap = new HashMap<String, String[]>();
        String displayStyle = "ddmTemplate_" + ddmTemplate.getTemplateKey();
        preferenceMap.put("displayStyle", new String[]{displayStyle});
        preferenceMap.put("displayStyleGroupId", new String[]{String.valueOf(ddmTemplate.getGroupId())});
        if (scopeType.equals("layout")) {
            preferenceMap.put("lfrScopeLayoutUuid", new String[]{this.layout.getUuid()});
        }
        preferenceMap.put("lfrScopeType", new String[]{scopeType});
        PortletPreferences portletPreferences = this.getImportedPortletPreferences(preferenceMap);
        String importedDisplayStyle = portletPreferences.getValue("displayStyle", "");
        Assert.assertEquals((Object)displayStyle, (Object)importedDisplayStyle);
        long importedDisplayStyleGroupId = GetterUtil.getLong((String)portletPreferences.getValue("displayStyleGroupId", null));
        long expectedDisplayStyleGroupId = this.importedGroup.getGroupId();
        if (scopeType.equals("company")) {
            Group companyGroup = GroupLocalServiceUtil.getCompanyGroup((long)this.importedGroup.getCompanyId());
            expectedDisplayStyleGroupId = companyGroup.getGroupId();
        } else if (displayStyleGroupId != this.group.getGroupId()) {
            expectedDisplayStyleGroupId = displayStyleGroupId;
        }
        Assert.assertEquals((long)expectedDisplayStyleGroupId, (long)importedDisplayStyleGroupId);
    }

    protected void validateImportedLinks(StagedModel originalStagedModel, StagedModel importedStagedModel) throws PortalException {
        AssetEntry originalAssetEntry = this.getAssetEntry(originalStagedModel);
        List originalAssetLinks = AssetLinkLocalServiceUtil.getLinks((long)originalAssetEntry.getEntryId());
        AssetEntry importedAssetEntry = this.getAssetEntry(importedStagedModel);
        List importedAssetLinks = AssetLinkLocalServiceUtil.getLinks((long)importedAssetEntry.getEntryId());
        Assert.assertEquals((long)originalAssetLinks.size(), (long)importedAssetLinks.size());
        block0: for (AssetLink originalLink : originalAssetLinks) {
            AssetEntry sourceAssetEntry = AssetEntryLocalServiceUtil.getEntry((long)originalLink.getEntryId1());
            AssetEntry targetAssetEntry = AssetEntryLocalServiceUtil.getEntry((long)originalLink.getEntryId2());
            Iterator iterator = importedAssetLinks.iterator();
            while (iterator.hasNext()) {
                AssetLink importedLink = (AssetLink)iterator.next();
                AssetEntry importedLinkSourceAssetEntry = AssetEntryLocalServiceUtil.getEntry((long)importedLink.getEntryId1());
                AssetEntry importedLinkTargetAssetEntry = AssetEntryLocalServiceUtil.getEntry((long)importedLink.getEntryId2());
                if (!Objects.equals(sourceAssetEntry.getClassUuid(), importedLinkSourceAssetEntry.getClassUuid()) || !Objects.equals(targetAssetEntry.getClassUuid(), importedLinkTargetAssetEntry.getClassUuid())) continue;
                Assert.assertEquals((long)originalLink.getWeight(), (long)importedLink.getWeight());
                Assert.assertEquals((long)originalLink.getType(), (long)importedLink.getType());
                iterator.remove();
                continue block0;
            }
        }
        Assert.assertEquals((long)0L, (long)importedAssetLinks.size());
    }

    protected void validateVersions() throws Exception {
    }
}

