/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar.test;

import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataContextFactoryUtil;
import com.liferay.exportimport.kernel.lar.PortletDataHandler;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.test.rule.DeleteAfterTestRun;
import com.liferay.portal.kernel.test.util.GroupTestUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.zip.ZipWriter;
import com.liferay.portal.kernel.zip.ZipWriterFactoryUtil;
import com.liferay.portlet.PortletPreferencesImpl;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.portlet.PortletPreferences;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class BasePortletDataHandlerTestCase {
    protected Element missingReferencesElement;
    protected PortletDataContext portletDataContext;
    protected PortletDataHandler portletDataHandler;
    protected String portletId;
    protected Element rootElement;
    @DeleteAfterTestRun
    protected Group stagingGroup;
    protected ZipWriter zipWriter;

    @Before
    public void setUp() throws Exception {
        this.stagingGroup = GroupTestUtil.addGroup();
        this.portletId = this.getPortletId();
        this.portletDataHandler = this.getPortletDataHandler(this.portletId);
    }

    @Test
    public void testPrepareManifestSummary() throws Exception {
        this.initExport();
        this.addStagedModels();
        this.portletDataContext.setEndDate(this.getEndDate());
        this.portletDataHandler.prepareManifestSummary(this.portletDataContext);
        ManifestSummary manifestSummary = this.portletDataContext.getManifestSummary();
        ManifestSummary expectedManifestSummary = (ManifestSummary)manifestSummary.clone();
        manifestSummary.resetCounters();
        this.portletDataHandler.exportData(this.portletDataContext, this.portletId, (PortletPreferences)new PortletPreferencesImpl());
        this.checkManifestSummary(expectedManifestSummary);
    }

    protected void addBooleanParameter(Map<String, String[]> parameterMap, String namespace, String name, boolean value) {
        PortletDataHandlerBoolean portletDataHandlerBoolean = new PortletDataHandlerBoolean(namespace, name);
        parameterMap.put(portletDataHandlerBoolean.getNamespacedControlName(), new String[]{String.valueOf(value)});
    }

    protected void addParameters(Map<String, String[]> parameterMap) {
    }

    protected abstract void addStagedModels() throws Exception;

    protected void checkManifestSummary(ManifestSummary expectedManifestSummary) {
        ManifestSummary manifestSummary = this.portletDataContext.getManifestSummary();
        for (String manifestSummaryKey : manifestSummary.getManifestSummaryKeys()) {
            Assert.assertFalse((boolean)manifestSummaryKey.endsWith("referrer-class-name-all"));
            Assert.assertFalse((boolean)manifestSummaryKey.endsWith("referrer-class-name-any"));
        }
        for (String manifestSummaryKey : expectedManifestSummary.getManifestSummaryKeys()) {
            String[] keyParts = StringUtil.split((String)manifestSummaryKey, (String)"#");
            long expectedModelAdditionCount = expectedManifestSummary.getModelAdditionCount(manifestSummaryKey);
            StagedModelType stagedModelType = new StagedModelType(keyParts[0]);
            if (keyParts.length > 1) {
                stagedModelType = new StagedModelType(keyParts[0], keyParts[1]);
            }
            long modelAdditionCount = manifestSummary.getModelAdditionCount(stagedModelType);
            if (expectedModelAdditionCount == 0L) {
                Assert.assertFalse((modelAdditionCount > 0L ? 1 : 0) != 0);
                continue;
            }
            Assert.assertEquals((long)expectedModelAdditionCount, (long)modelAdditionCount);
        }
    }

    protected Date getEndDate() {
        return new Date();
    }

    protected PortletDataHandler getPortletDataHandler(String portletId) {
        try {
            Registry registry = RegistryUtil.getRegistry();
            Collection portletDataHandlers = registry.getServices(PortletDataHandler.class, "(javax.portlet.name=" + portletId + ")");
            Iterator iterator = portletDataHandlers.iterator();
            return (PortletDataHandler)iterator.next();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract String getPortletId();

    protected Date getStartDate() {
        return new Date(System.currentTimeMillis() - 3600000L);
    }

    protected void initExport() throws Exception {
        LinkedHashMap<String, String[]> parameterMap = new LinkedHashMap<String, String[]>();
        this.addParameters(parameterMap);
        this.zipWriter = ZipWriterFactoryUtil.getZipWriter();
        this.portletDataContext = PortletDataContextFactoryUtil.createExportPortletDataContext((long)this.stagingGroup.getCompanyId(), (long)this.stagingGroup.getGroupId(), parameterMap, (Date)this.getStartDate(), (Date)this.getEndDate(), (ZipWriter)this.zipWriter);
        this.rootElement = SAXReaderUtil.createElement((String)"root");
        this.portletDataContext.setExportDataRootElement(this.rootElement);
        this.missingReferencesElement = SAXReaderUtil.createElement((String)"missing-references");
        this.portletDataContext.setMissingReferencesElement(this.missingReferencesElement);
    }
}

