/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.map.ValuePool;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.CharacterType;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.Type;

public final class NumberType
extends Type {
    static final int tinyintPrecision = 3;
    static final int smallintPrecision = 5;
    static final int integerPrecision = 10;
    static final int bigintPrecision = 19;
    static final int doublePrecision = 0;
    public static final int defaultNumericPrecision = 128;
    public static final int defaultNumericScale = 32;
    public static final int maxNumericPrecision = Integer.MAX_VALUE;
    static final int bigintSquareNumericPrecision = 40;
    public static final int TINYINT_WIDTH = 8;
    public static final int SMALLINT_WIDTH = 16;
    public static final int INTEGER_WIDTH = 32;
    public static final int BIGINT_WIDTH = 64;
    public static final int DOUBLE_WIDTH = 128;
    public static final int DECIMAL_WIDTH = 256;
    public static final Type SQL_NUMERIC_DEFAULT_INT = new NumberType(2, 128L, 0);
    public static final BigDecimal MAX_DOUBLE = BigDecimal.valueOf(Double.MAX_VALUE);
    public static final BigDecimal MAX_LONG = BigDecimal.valueOf(Long.MAX_VALUE);
    public static final BigDecimal MIN_LONG = BigDecimal.valueOf(Long.MIN_VALUE);
    public static final BigDecimal MAX_INT = BigDecimal.valueOf(Integer.MAX_VALUE);
    public static final BigDecimal MIN_INT = BigDecimal.valueOf(Integer.MIN_VALUE);
    public static final BigInteger MIN_LONG_BI = MIN_LONG.toBigInteger();
    public static final BigInteger MAX_LONG_BI = MAX_LONG.toBigInteger();
    final int typeWidth;

    public NumberType(int type, long precision, int scale) {
        super(2, type, precision, scale);
        switch (type) {
            case -6: {
                this.typeWidth = 8;
                break;
            }
            case 5: {
                this.typeWidth = 16;
                break;
            }
            case 4: {
                this.typeWidth = 32;
                break;
            }
            case 25: {
                this.typeWidth = 64;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                this.typeWidth = 128;
                break;
            }
            case 2: 
            case 3: {
                this.typeWidth = 256;
                break;
            }
            default: {
                throw Error.runtimeError(201, "NumberType");
            }
        }
    }

    public int getPrecision() {
        switch (this.typeCode) {
            case -6: 
            case 4: 
            case 5: 
            case 25: {
                return this.typeWidth;
            }
            case 6: 
            case 7: 
            case 8: {
                return 64;
            }
            case 2: 
            case 3: {
                return (int)this.precision;
            }
        }
        throw Error.runtimeError(201, "NumberType");
    }

    public int getDecimalPrecision() {
        switch (this.typeCode) {
            case -6: {
                return 3;
            }
            case 5: {
                return 5;
            }
            case 4: {
                return 10;
            }
            case 25: {
                return 19;
            }
            case 6: 
            case 7: 
            case 8: {
                return this.displaySize() - 1;
            }
            case 2: 
            case 3: {
                return (int)this.precision;
            }
        }
        throw Error.runtimeError(201, "NumberType");
    }

    @Override
    public int displaySize() {
        switch (this.typeCode) {
            case 2: 
            case 3: {
                if (this.scale == 0) {
                    if (this.precision == 0L) {
                        return 646456995;
                    }
                    return (int)this.precision + 1;
                }
                if (this.precision == (long)this.scale) {
                    return (int)this.precision + 3;
                }
                return (int)this.precision + 2;
            }
            case 6: 
            case 7: 
            case 8: {
                return 23;
            }
            case 25: {
                return 20;
            }
            case 4: {
                return 11;
            }
            case 5: {
                return 6;
            }
            case -6: {
                return 4;
            }
        }
        throw Error.runtimeError(201, "NumberType");
    }

    @Override
    public int getJDBCTypeCode() {
        return this.typeCode == 25 ? -5 : this.typeCode;
    }

    @Override
    public Class getJDBCClass() {
        switch (this.typeCode) {
            case -6: 
            case 4: 
            case 5: {
                return Integer.class;
            }
            case 25: {
                return Long.class;
            }
            case 6: 
            case 7: 
            case 8: {
                return Double.class;
            }
            case 2: 
            case 3: {
                return BigDecimal.class;
            }
        }
        throw Error.runtimeError(201, "NumberType");
    }

    @Override
    public String getJDBCClassName() {
        switch (this.typeCode) {
            case -6: 
            case 4: 
            case 5: {
                return "java.lang.Integer";
            }
            case 25: {
                return "java.lang.Long";
            }
            case 6: 
            case 7: 
            case 8: {
                return "java.lang.Double";
            }
            case 2: 
            case 3: {
                return "java.math.BigDecimal";
            }
        }
        throw Error.runtimeError(201, "NumberType");
    }

    @Override
    public int getJDBCPrecision() {
        return this.getPrecision();
    }

    @Override
    public String getNameString() {
        switch (this.typeCode) {
            case -6: {
                return "TINYINT";
            }
            case 5: {
                return "SMALLINT";
            }
            case 4: {
                return "INTEGER";
            }
            case 25: {
                return "BIGINT";
            }
            case 7: {
                return "REAL";
            }
            case 6: {
                return "FLOAT";
            }
            case 8: {
                return "DOUBLE";
            }
            case 2: {
                return "NUMERIC";
            }
            case 3: {
                return "DECIMAL";
            }
        }
        throw Error.runtimeError(201, "NumberType");
    }

    @Override
    public String getFullNameString() {
        switch (this.typeCode) {
            case 8: {
                return "DOUBLE PRECISION";
            }
        }
        return this.getNameString();
    }

    @Override
    public String getDefinition() {
        switch (this.typeCode) {
            case 2: 
            case 3: {
                StringBuffer sb = new StringBuffer(16);
                sb.append(this.getNameString());
                sb.append('(');
                sb.append(this.precision);
                if (this.scale != 0) {
                    sb.append(',');
                    sb.append(this.scale);
                }
                sb.append(')');
                return sb.toString();
            }
        }
        return this.getNameString();
    }

    @Override
    public long getMaxPrecision() {
        switch (this.typeCode) {
            case 2: 
            case 3: {
                return Integer.MAX_VALUE;
            }
        }
        return this.getNumericPrecisionInRadix();
    }

    @Override
    public int getMaxScale() {
        switch (this.typeCode) {
            case 2: 
            case 3: {
                return Short.MAX_VALUE;
            }
        }
        return 0;
    }

    @Override
    public boolean acceptsPrecision() {
        switch (this.typeCode) {
            case 2: 
            case 3: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean acceptsScale() {
        switch (this.typeCode) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getPrecisionRadix() {
        if (this.typeCode == 3 || this.typeCode == 2) {
            return 10;
        }
        return 2;
    }

    @Override
    public boolean isNumberType() {
        return true;
    }

    @Override
    public boolean isIntegralType() {
        switch (this.typeCode) {
            case 6: 
            case 7: 
            case 8: {
                return false;
            }
            case 2: 
            case 3: {
                return this.scale == 0;
            }
        }
        return true;
    }

    @Override
    public boolean isExactNumberType() {
        switch (this.typeCode) {
            case 6: 
            case 7: 
            case 8: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isDecimalType() {
        switch (this.typeCode) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public int getNominalWidth() {
        return this.typeWidth;
    }

    @Override
    public int precedenceDegree(Type other) {
        if (other.isNumberType()) {
            int otherWidth = ((NumberType)other).typeWidth;
            return otherWidth - this.typeWidth;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public Type getAggregateType(Type other) {
        if (other == null) {
            return this;
        }
        if (other == SQL_ALL_TYPES) {
            return this;
        }
        if (this == other) {
            return this;
        }
        if (other.isCharacterType()) {
            return other.getAggregateType(this);
        }
        switch (other.typeCode) {
            case -6: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 25: {
                break;
            }
            default: {
                throw Error.error(5562);
            }
        }
        if (this.typeWidth == 128) {
            return this;
        }
        if (((NumberType)other).typeWidth == 128) {
            return other;
        }
        if (this.typeWidth <= 64 && ((NumberType)other).typeWidth <= 64) {
            return this.typeWidth > ((NumberType)other).typeWidth ? this : other;
        }
        int newScale = this.scale > other.scale ? this.scale : other.scale;
        long newDigits = this.precision - (long)this.scale > other.precision - (long)other.scale ? this.precision - (long)this.scale : other.precision - (long)other.scale;
        return NumberType.getNumberType(3, newDigits + (long)newScale, newScale);
    }

    @Override
    public Type getCombinedType(Session session, Type other, int operation) {
        long newDigits;
        int newScale;
        if (other.typeCode == 0) {
            other = this;
        }
        switch (operation) {
            case 32: 
            case 35: {
                break;
            }
            case 34: {
                if (!other.isIntervalType()) break;
                return other.getCombinedType(session, this, 34);
            }
            default: {
                return this.getAggregateType(other);
            }
        }
        if (!other.isNumberType()) {
            throw Error.error(5562);
        }
        if (this.typeWidth == 128 || ((NumberType)other).typeWidth == 128) {
            return Type.SQL_DOUBLE;
        }
        if (operation != 35 || session.database.sqlAvgScale == 0) {
            int sum = operation == 35 ? this.typeWidth : this.typeWidth + ((NumberType)other).typeWidth;
            if (sum <= 32) {
                return Type.SQL_INTEGER;
            }
            if (sum <= 64) {
                return Type.SQL_BIGINT;
            }
        }
        switch (operation) {
            case 32: {
                newScale = this.scale > other.scale ? this.scale : other.scale;
                newDigits = this.getDecimalPrecision() - this.scale > ((NumberType)other).getDecimalPrecision() - other.scale ? (long)(this.getDecimalPrecision() - this.scale) : (long)(((NumberType)other).getDecimalPrecision() - other.scale);
                ++newDigits;
                break;
            }
            case 35: {
                newDigits = this.getDecimalPrecision() - this.scale + other.scale;
                int n = newScale = this.scale > other.scale ? this.scale : other.scale;
                if (session.database.sqlAvgScale <= newScale) break;
                newScale = session.database.sqlAvgScale;
                break;
            }
            case 34: {
                newDigits = this.getDecimalPrecision() - this.scale + ((NumberType)other).getDecimalPrecision() - other.scale;
                newScale = this.scale + other.scale;
                break;
            }
            default: {
                throw Error.runtimeError(201, "NumberType");
            }
        }
        return NumberType.getNumberType(3, (long)newScale + newDigits, newScale);
    }

    @Override
    public int compare(Session session, Object a, Object b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        switch (this.typeCode) {
            case -6: 
            case 4: 
            case 5: {
                if (b instanceof Integer) {
                    int bi;
                    int ai = ((Number)a).intValue();
                    return ai > (bi = ((Number)b).intValue()) ? 1 : (bi > ai ? -1 : 0);
                }
                if (b instanceof Double) {
                    double bi;
                    double ai = ((Number)a).doubleValue();
                    return ai > (bi = ((Number)b).doubleValue()) ? 1 : (bi > ai ? -1 : 0);
                }
                if (b instanceof BigDecimal) {
                    BigDecimal ad = NumberType.convertToDecimal(a);
                    return ad.compareTo((BigDecimal)b);
                }
            }
            case 25: {
                if (b instanceof Long) {
                    long longb;
                    long longa = ((Number)a).longValue();
                    return longa > (longb = ((Number)b).longValue()) ? 1 : (longb > longa ? -1 : 0);
                }
                if (b instanceof Double) {
                    BigDecimal ad = BigDecimal.valueOf(((Number)a).longValue());
                    BigDecimal bd = new BigDecimal((Double)b);
                    return ad.compareTo(bd);
                }
                if (b instanceof BigDecimal) {
                    BigDecimal ad = NumberType.convertToDecimal(a);
                    return ad.compareTo((BigDecimal)b);
                }
            }
            case 6: 
            case 7: 
            case 8: {
                double ad = ((Number)a).doubleValue();
                double bd = ((Number)b).doubleValue();
                if (Double.isNaN(ad)) {
                    return Double.isNaN(bd) ? 0 : -1;
                }
                if (Double.isNaN(bd)) {
                    return 1;
                }
                return Double.compare(ad, bd);
            }
            case 2: 
            case 3: {
                BigDecimal bd = NumberType.convertToDecimal(b);
                return ((BigDecimal)a).compareTo(bd);
            }
        }
        throw Error.runtimeError(201, "NumberType");
    }

    @Override
    public Object convertToTypeLimits(SessionInterface session, Object a) {
        if (a == null) {
            return null;
        }
        switch (this.typeCode) {
            case -6: 
            case 4: 
            case 5: 
            case 25: {
                return a;
            }
            case 6: 
            case 7: 
            case 8: {
                return a;
            }
            case 2: 
            case 3: {
                int p;
                BigDecimal dec = (BigDecimal)a;
                if (this.scale != dec.scale()) {
                    dec = dec.setScale(this.scale, 5);
                }
                if ((long)(p = JavaSystem.precision(dec)) > this.precision) {
                    throw Error.error(3403);
                }
                return dec;
            }
        }
        throw Error.runtimeError(201, "NumberType");
    }

    @Override
    public Object convertToType(SessionInterface session, Object a, Type otherType) {
        if (a == null) {
            return a;
        }
        if (otherType.typeCode == this.typeCode) {
            switch (this.typeCode) {
                case 2: 
                case 3: {
                    BigDecimal dec = (BigDecimal)a;
                    if (this.scale != dec.scale()) {
                        dec = dec.setScale(this.scale, 5);
                    }
                    if ((long)JavaSystem.precision(dec) > this.precision) {
                        throw Error.error(3403);
                    }
                    return dec;
                }
            }
            return a;
        }
        if (otherType.isIntervalType()) {
            int startType = ((IntervalType)otherType).startIntervalType;
            switch (startType) {
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: {
                    double value = ((IntervalType)otherType).convertToDoubleStartUnits(a);
                    return this.convertToType(session, value, Type.SQL_DOUBLE);
                }
            }
        }
        switch (otherType.typeCode) {
            case 40: {
                a = ((ClobData)a).getSubString(session, 0L, (int)((ClobData)a).length(session));
            }
            case 1: 
            case 12: {
                a = session.getScanner().convertToNumber((String)a, this);
                a = this.convertToDefaultType(session, a);
                return this.convertToTypeLimits(session, a);
            }
            case -6: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 25: {
                break;
            }
            case 14: 
            case 15: {
                if (otherType.precision == 1L) {
                    if (((BinaryData)a).getBytes()[0] == 0) {
                        a = ValuePool.INTEGER_0;
                        break;
                    }
                    a = ValuePool.INTEGER_1;
                    break;
                }
            }
            default: {
                throw Error.error(5561);
            }
        }
        switch (this.typeCode) {
            case -6: 
            case 4: 
            case 5: {
                return NumberType.convertToInt(session, a, this.typeCode);
            }
            case 25: {
                return NumberType.convertToLong(session, a);
            }
            case 6: 
            case 7: 
            case 8: {
                return NumberType.convertToDouble(a);
            }
            case 2: 
            case 3: {
                BigDecimal value = null;
                if (this.scale == 0 && a instanceof Double) {
                    double d = ((Number)a).doubleValue();
                    if (session instanceof Session && !((Session)session).database.sqlConvertTruncate) {
                        d = Math.rint(d);
                    }
                    if (Double.isInfinite(d) || Double.isNaN(d)) {
                        throw Error.error(3403);
                    }
                    value = BigDecimal.valueOf(d);
                }
                if (value == null) {
                    value = NumberType.convertToDecimal(a);
                }
                return this.convertToTypeLimits(session, value);
            }
        }
        throw Error.error(5561);
    }

    @Override
    public Object convertToTypeJDBC(SessionInterface session, Object a, Type otherType) {
        if (a == null) {
            return a;
        }
        if (otherType.isLobType()) {
            throw Error.error(5561);
        }
        switch (otherType.typeCode) {
            case 16: {
                a = (Boolean)a != false ? ValuePool.INTEGER_1 : ValuePool.INTEGER_0;
                otherType = Type.SQL_INTEGER;
            }
        }
        return this.convertToType(session, a, otherType);
    }

    @Override
    public Object convertToDefaultType(SessionInterface session, Object a) {
        if (a == null) {
            return a;
        }
        if (a instanceof Number) {
            if (a instanceof BigInteger) {
                a = new BigDecimal((BigInteger)a);
            } else if (a instanceof Float) {
                a = new Double(((Float)a).doubleValue());
            } else if (a instanceof Byte) {
                a = ValuePool.getInt(((Byte)a).intValue());
            } else if (a instanceof Short) {
                a = ValuePool.getInt(((Short)a).intValue());
            }
            if (a instanceof Integer) {
                NumberType otherType = Type.SQL_INTEGER;
            } else if (a instanceof Long) {
                NumberType otherType = Type.SQL_BIGINT;
            } else if (a instanceof Double) {
                NumberType otherType = Type.SQL_DOUBLE;
            } else if (a instanceof BigDecimal) {
                NumberType otherType = Type.SQL_DECIMAL_DEFAULT;
            } else {
                throw Error.error(5561);
            }
            switch (this.typeCode) {
                case -6: 
                case 4: 
                case 5: {
                    return NumberType.convertToInt(session, a, 4);
                }
                case 25: {
                    return NumberType.convertToLong(session, a);
                }
                case 6: 
                case 7: 
                case 8: {
                    return NumberType.convertToDouble(a);
                }
                case 2: 
                case 3: {
                    a = NumberType.convertToDecimal(a);
                    BigDecimal dec = (BigDecimal)a;
                    if (this.scale != dec.scale()) {
                        dec = dec.setScale(this.scale, 5);
                    }
                    return dec;
                }
            }
            throw Error.error(5561);
        }
        if (!(a instanceof String)) {
            throw Error.error(5561);
        }
        CharacterType otherType = Type.SQL_VARCHAR;
        return this.convertToType(session, a, otherType);
    }

    @Override
    public Object convertJavaToSQL(SessionInterface session, Object a) {
        return this.convertToDefaultType(session, a);
    }

    static Integer convertToInt(SessionInterface session, Object a, int type) {
        int value;
        if (a instanceof Integer) {
            if (type == 4) {
                return (Integer)a;
            }
            value = (Integer)a;
        } else if (a instanceof Long) {
            long temp = (Long)a;
            if (Integer.MAX_VALUE < temp || temp < Integer.MIN_VALUE) {
                throw Error.error(3403);
            }
            value = (int)temp;
        } else if (a instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)a;
            if (bd.compareTo(MAX_INT) > 0 || bd.compareTo(MIN_INT) < 0) {
                throw Error.error(3403);
            }
            value = bd.intValue();
        } else if (a instanceof Double || a instanceof Float) {
            double d = ((Number)a).doubleValue();
            if (session instanceof Session && !((Session)session).database.sqlConvertTruncate) {
                d = Math.rint(d);
            }
            if (Double.isInfinite(d) || Double.isNaN(d) || d >= 2.147483648E9 || d <= -2.147483649E9) {
                throw Error.error(3403);
            }
            value = (int)d;
        } else {
            throw Error.error(5561);
        }
        if (type == -6 ? 127 < value || value < -128 : type == 5 && (Short.MAX_VALUE < value || value < Short.MIN_VALUE)) {
            throw Error.error(3403);
        }
        return value;
    }

    static Long convertToLong(SessionInterface session, Object a) {
        if (a instanceof Integer) {
            return ValuePool.getLong(((Integer)a).intValue());
        }
        if (a instanceof Long) {
            return (Long)a;
        }
        if (a instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)a;
            if (bd.compareTo(MAX_LONG) > 0 || bd.compareTo(MIN_LONG) < 0) {
                throw Error.error(3403);
            }
            return ValuePool.getLong(bd.longValue());
        }
        if (a instanceof Double || a instanceof Float) {
            double d = ((Number)a).doubleValue();
            if (session instanceof Session && !((Session)session).database.sqlConvertTruncate) {
                d = Math.rint(d);
            }
            if (Double.isInfinite(d) || Double.isNaN(d) || d >= 9.223372036854776E18 || d <= -9.223372036854776E18) {
                throw Error.error(3403);
            }
            return ValuePool.getLong((long)d);
        }
        throw Error.error(5561);
    }

    private static Double convertToDouble(Object a) {
        if (a instanceof Double) {
            return (Double)a;
        }
        double value = NumberType.toDouble(a);
        return ValuePool.getDouble(Double.doubleToLongBits(value));
    }

    public static double toDouble(Object a) {
        double value;
        if (a instanceof Double) {
            return (Double)a;
        }
        if (a instanceof BigDecimal) {
            int signum;
            BigDecimal bd = (BigDecimal)a;
            value = bd.doubleValue();
            BigDecimal bdd = new BigDecimal(value + (double)(signum = bd.signum()));
            if (bdd.compareTo(bd) != signum) {
                throw Error.error(3403);
            }
        } else if (a instanceof Number) {
            value = ((Number)a).doubleValue();
        } else {
            throw Error.error(3471);
        }
        return value;
    }

    private static BigDecimal convertToDecimal(Object a) {
        if (a instanceof BigDecimal) {
            return (BigDecimal)a;
        }
        if (a instanceof Integer || a instanceof Long) {
            return BigDecimal.valueOf(((Number)a).longValue());
        }
        if (a instanceof Double) {
            double value = ((Number)a).doubleValue();
            if (Double.isInfinite(value) || Double.isNaN(value)) {
                throw Error.error(3403);
            }
            return BigDecimal.valueOf(value);
        }
        throw Error.runtimeError(201, "NumberType");
    }

    @Override
    public String convertToString(Object a) {
        if (a == null) {
            return null;
        }
        switch (this.typeCode) {
            case -6: 
            case 4: 
            case 5: 
            case 25: {
                return a.toString();
            }
            case 7: 
            case 8: {
                double value = (Double)a;
                if (value == Double.NEGATIVE_INFINITY) {
                    return "-1E0/0";
                }
                if (value == Double.POSITIVE_INFINITY) {
                    return "1E0/0";
                }
                if (Double.isNaN(value)) {
                    return "0E0/0E0";
                }
                String s = Double.toString(value);
                if (s.indexOf(69) < 0) {
                    s = s.concat("E0");
                }
                return s;
            }
            case 2: 
            case 3: {
                return JavaSystem.toString((BigDecimal)a);
            }
        }
        throw Error.runtimeError(201, "NumberType");
    }

    @Override
    public String convertToSQLString(Object a) {
        if (a == null) {
            return "NULL";
        }
        return this.convertToString(a);
    }

    @Override
    public boolean canConvertFrom(Type otherType) {
        if (otherType.typeCode == 0) {
            return true;
        }
        if (otherType.isNumberType()) {
            return true;
        }
        if (otherType.isIntervalType()) {
            return true;
        }
        if (otherType.isCharacterType()) {
            return true;
        }
        return otherType.isBitType() && otherType.precision == 1L;
    }

    @Override
    public int canMoveFrom(Type otherType) {
        if (otherType == this) {
            return 0;
        }
        switch (this.typeCode) {
            case -6: {
                if (otherType.typeCode != 5 && otherType.typeCode != 4) break;
                return 1;
            }
            case 5: {
                if (otherType.typeCode == -6) {
                    return 0;
                }
                if (otherType.typeCode != 4) break;
                return 1;
            }
            case 4: {
                if (otherType.typeCode != 5 && otherType.typeCode != -6) break;
                return 0;
            }
            case 25: {
                break;
            }
            case 2: 
            case 3: {
                if (otherType.typeCode != 3 && otherType.typeCode != 2 || this.scale != otherType.scale) break;
                if (this.precision >= otherType.precision) {
                    return 0;
                }
                return 1;
            }
            case 6: 
            case 7: 
            case 8: {
                if (otherType.typeCode != 7 && otherType.typeCode != 6 && otherType.typeCode != 8) break;
                return 0;
            }
        }
        return -1;
    }

    @Override
    public int compareToTypeRange(Object o) {
        if (!(o instanceof Number)) {
            return 0;
        }
        if (o instanceof Integer || o instanceof Long) {
            int max;
            int min;
            long temp = ((Number)o).longValue();
            switch (this.typeCode) {
                case -6: {
                    min = -128;
                    max = 127;
                    break;
                }
                case 5: {
                    min = Short.MIN_VALUE;
                    max = Short.MAX_VALUE;
                    break;
                }
                case 4: {
                    min = Integer.MIN_VALUE;
                    max = Integer.MAX_VALUE;
                    break;
                }
                case 25: {
                    return 0;
                }
                case 2: 
                case 3: {
                    if (this.precision - (long)this.scale > 18L) {
                        return 0;
                    }
                    if (this.precision - (long)this.scale > 9L && o instanceof Integer) {
                        return 0;
                    }
                    BigDecimal dec = NumberType.convertToDecimal(o);
                    int s = dec.scale();
                    int p = JavaSystem.precision(dec);
                    if (s < 0) {
                        p -= s;
                        s = 0;
                    }
                    return this.precision - (long)this.scale >= (long)(p - s) ? 0 : dec.signum();
                }
                default: {
                    return 0;
                }
            }
            if ((long)max < temp) {
                return 1;
            }
            if (temp < (long)min) {
                return -1;
            }
            return 0;
        }
        return 0;
    }

    @Override
    public Object add(Session session, Object a, Object b, Type otherType) {
        if (a == null || b == null) {
            return null;
        }
        switch (this.typeCode) {
            case 6: 
            case 7: 
            case 8: {
                double ad = ((Number)a).doubleValue();
                double bd = ((Number)b).doubleValue();
                return ValuePool.getDouble(Double.doubleToLongBits(ad + bd));
            }
            case 2: 
            case 3: {
                a = this.convertToDefaultType(null, a);
                b = this.convertToDefaultType(null, b);
                BigDecimal abd = (BigDecimal)a;
                BigDecimal bbd = (BigDecimal)b;
                abd = abd.add(bbd);
                return this.convertToTypeLimits(null, abd);
            }
            case -6: 
            case 4: 
            case 5: {
                int ai = ((Number)a).intValue();
                int bi = ((Number)b).intValue();
                return ValuePool.getInt(ai + bi);
            }
            case 25: {
                long longa = ((Number)a).longValue();
                long longb = ((Number)b).longValue();
                return ValuePool.getLong(longa + longb);
            }
        }
        throw Error.runtimeError(201, "NumberType");
    }

    @Override
    public Object subtract(Session session, Object a, Object b, Type otherType) {
        if (a == null || b == null) {
            return null;
        }
        switch (this.typeCode) {
            case 6: 
            case 7: 
            case 8: {
                double ad = ((Number)a).doubleValue();
                double bd = ((Number)b).doubleValue();
                return ValuePool.getDouble(Double.doubleToLongBits(ad - bd));
            }
            case 2: 
            case 3: {
                a = this.convertToDefaultType(null, a);
                b = this.convertToDefaultType(null, b);
                BigDecimal abd = (BigDecimal)a;
                BigDecimal bbd = (BigDecimal)b;
                abd = abd.subtract(bbd);
                return this.convertToTypeLimits(null, abd);
            }
            case -6: 
            case 4: 
            case 5: {
                int ai = ((Number)a).intValue();
                int bi = ((Number)b).intValue();
                return ValuePool.getInt(ai - bi);
            }
            case 25: {
                long longa = ((Number)a).longValue();
                long longb = ((Number)b).longValue();
                return ValuePool.getLong(longa - longb);
            }
        }
        throw Error.runtimeError(201, "NumberType");
    }

    @Override
    public Object multiply(Object a, Object b) {
        if (a == null || b == null) {
            return null;
        }
        switch (this.typeCode) {
            case 6: 
            case 7: 
            case 8: {
                double ad = ((Number)a).doubleValue();
                double bd = ((Number)b).doubleValue();
                return ValuePool.getDouble(Double.doubleToLongBits(ad * bd));
            }
            case 2: 
            case 3: {
                if (!(a instanceof BigDecimal)) {
                    a = this.convertToDefaultType(null, a);
                }
                if (!(b instanceof BigDecimal)) {
                    b = this.convertToDefaultType(null, b);
                }
                BigDecimal abd = (BigDecimal)a;
                BigDecimal bbd = (BigDecimal)b;
                BigDecimal bd = abd.multiply(bbd);
                return this.convertToTypeLimits(null, bd);
            }
            case -6: 
            case 4: 
            case 5: {
                int ai = ((Number)a).intValue();
                int bi = ((Number)b).intValue();
                return ValuePool.getInt(ai * bi);
            }
            case 25: {
                long longa = ((Number)a).longValue();
                long longb = ((Number)b).longValue();
                return ValuePool.getLong(longa * longb);
            }
        }
        throw Error.runtimeError(201, "NumberType");
    }

    @Override
    public Object divide(Session session, Object a, Object b) {
        if (a == null || b == null) {
            return null;
        }
        switch (this.typeCode) {
            case 6: 
            case 7: 
            case 8: {
                double ad = ((Number)a).doubleValue();
                double bd = ((Number)b).doubleValue();
                if (bd == 0.0 && (session == null || session.database.sqlDoubleNaN)) {
                    throw Error.error(3432);
                }
                return ValuePool.getDouble(Double.doubleToLongBits(ad / bd));
            }
            case 2: 
            case 3: {
                if (!(a instanceof BigDecimal)) {
                    a = this.convertToDefaultType(null, a);
                }
                if (!(b instanceof BigDecimal)) {
                    b = this.convertToDefaultType(null, b);
                }
                BigDecimal abd = (BigDecimal)a;
                BigDecimal bbd = (BigDecimal)b;
                if (bbd.signum() == 0) {
                    throw Error.error(3432);
                }
                BigDecimal bd = abd.divide(bbd, this.scale, 1);
                return this.convertToTypeLimits(null, bd);
            }
            case -6: 
            case 4: 
            case 5: {
                int ai = ((Number)a).intValue();
                int bi = ((Number)b).intValue();
                if (bi == 0) {
                    throw Error.error(3432);
                }
                return ValuePool.getInt(ai / bi);
            }
            case 25: {
                long al = ((Number)a).longValue();
                long bl = ((Number)b).longValue();
                if (bl == 0L) {
                    throw Error.error(3432);
                }
                return ValuePool.getLong(al / bl);
            }
        }
        throw Error.runtimeError(201, "NumberType");
    }

    public Object modulo(Session session, Object a, Object b, Type otherType) {
        if (!otherType.isNumberType()) {
            throw Error.error(5561);
        }
        a = this.truncate(a, this.scale);
        b = ((NumberType)otherType).truncate(b, otherType.scale);
        Object temp = this.divide(null, a, b);
        switch (this.typeCode) {
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                temp = this.truncate(temp, 0);
            }
        }
        temp = this.multiply(temp, b);
        temp = this.subtract(session, a, temp, this);
        return otherType.convertToType(null, temp, this);
    }

    @Override
    public Object absolute(Object a) {
        return this.isNegative(a) ? this.negate(a) : a;
    }

    @Override
    public Object negate(Object a) {
        if (a == null) {
            return null;
        }
        switch (this.typeCode) {
            case 6: 
            case 7: 
            case 8: {
                double ad = -((Number)a).doubleValue();
                return ValuePool.getDouble(Double.doubleToLongBits(ad));
            }
            case 2: 
            case 3: {
                return ((BigDecimal)a).negate();
            }
            case -6: {
                int value = ((Number)a).intValue();
                if (value == -128) {
                    throw Error.error(3403);
                }
                return ValuePool.getInt(-value);
            }
            case 5: {
                int value = ((Number)a).intValue();
                if (value == Short.MIN_VALUE) {
                    throw Error.error(3403);
                }
                return ValuePool.getInt(-value);
            }
            case 4: {
                int value = ((Number)a).intValue();
                if (value == Integer.MIN_VALUE) {
                    throw Error.error(3403);
                }
                return ValuePool.getInt(-value);
            }
            case 25: {
                long value = ((Number)a).longValue();
                if (value == Long.MIN_VALUE) {
                    throw Error.error(3403);
                }
                return ValuePool.getLong(-value);
            }
        }
        throw Error.runtimeError(201, "NumberType");
    }

    public int getNumericPrecisionInRadix() {
        switch (this.typeCode) {
            case -6: {
                return 8;
            }
            case 5: {
                return 16;
            }
            case 4: {
                return 32;
            }
            case 25: {
                return 64;
            }
            case 6: 
            case 7: 
            case 8: {
                return 64;
            }
            case 2: 
            case 3: {
                return (int)this.precision;
            }
        }
        throw Error.runtimeError(201, "NumberType");
    }

    public Type getIntegralType() {
        switch (this.typeCode) {
            case 6: 
            case 7: 
            case 8: {
                return SQL_NUMERIC_DEFAULT_INT;
            }
            case 2: 
            case 3: {
                return this.scale == 0 ? this : new NumberType(this.typeCode, this.precision, 0);
            }
        }
        return this;
    }

    public static boolean isZero(Object a) {
        if (a instanceof BigDecimal) {
            return ((BigDecimal)a).signum() == 0;
        }
        if (a instanceof Double) {
            return (Double)a == 0.0 || ((Double)a).isNaN();
        }
        return ((Number)a).longValue() == 0L;
    }

    public boolean isNegative(Object a) {
        if (a == null) {
            return false;
        }
        switch (this.typeCode) {
            case 6: 
            case 7: 
            case 8: {
                double ad = ((Number)a).doubleValue();
                return ad < 0.0;
            }
            case 2: 
            case 3: {
                return ((BigDecimal)a).signum() < 0;
            }
            case -6: 
            case 4: 
            case 5: {
                return ((Number)a).intValue() < 0;
            }
            case 25: {
                return ((Number)a).longValue() < 0L;
            }
        }
        throw Error.runtimeError(201, "NumberType");
    }

    public int compareToZero(Object a) {
        if (a == null) {
            return 0;
        }
        switch (this.typeCode) {
            case 6: 
            case 7: 
            case 8: {
                double ad = ((Number)a).doubleValue();
                return ad == 0.0 ? 0 : (ad < 0.0 ? -1 : 1);
            }
            case 2: 
            case 3: {
                return ((BigDecimal)a).signum();
            }
            case -6: 
            case 4: 
            case 5: {
                int ai = ((Number)a).intValue();
                return ai == 0 ? 0 : (ai < 0 ? -1 : 1);
            }
            case 25: {
                long al = ((Number)a).longValue();
                return al == 0L ? 0 : (al < 0L ? -1 : 1);
            }
        }
        throw Error.runtimeError(201, "NumberType");
    }

    public static long scaledDecimal(Object a, int scale) {
        if (a == null) {
            return 0L;
        }
        if (scale == 0) {
            return 0L;
        }
        BigDecimal value = (BigDecimal)a;
        if (value.scale() == 0) {
            return 0L;
        }
        value = value.setScale(0, 3);
        value = ((BigDecimal)a).subtract(value);
        return value.movePointRight(scale).longValue();
    }

    public static boolean isInLongLimits(BigDecimal result) {
        return MIN_LONG.compareTo(result) <= 0 && MAX_LONG.compareTo(result) >= 0;
    }

    public static boolean isInLongLimits(BigInteger result) {
        return MIN_LONG_BI.compareTo(result) <= 0 && MAX_LONG_BI.compareTo(result) >= 0;
    }

    public Object ceiling(Object a) {
        if (a == null) {
            return null;
        }
        switch (this.typeCode) {
            case 6: 
            case 7: 
            case 8: {
                double ad = Math.ceil((Double)a);
                if (Double.isInfinite(ad)) {
                    throw Error.error(3403);
                }
                return ValuePool.getDouble(Double.doubleToLongBits(ad));
            }
            case 2: 
            case 3: {
                BigDecimal value = ((BigDecimal)a).setScale(0, 2);
                return value;
            }
        }
        return a;
    }

    public Object floor(Object a) {
        if (a == null) {
            return null;
        }
        switch (this.typeCode) {
            case 6: 
            case 7: 
            case 8: {
                double value = Math.floor((Double)a);
                if (Double.isInfinite(value)) {
                    throw Error.error(3403);
                }
                return ValuePool.getDouble(Double.doubleToLongBits(value));
            }
            case 2: 
            case 3: {
                BigDecimal value = ((BigDecimal)a).setScale(0, 3);
                return value;
            }
        }
        return a;
    }

    public Object truncate(Object a, int s) {
        if (a == null) {
            return null;
        }
        BigDecimal dec = NumberType.convertToDecimal(a);
        dec = dec.setScale(s, 1);
        if (this.typeCode == 3 || this.typeCode == 2) {
            dec = dec.setScale(this.scale, 1);
        }
        a = this.convertToDefaultType(null, dec);
        return this.convertToTypeLimits(null, a);
    }

    public Object round(Object a, int s) {
        if (a == null) {
            return null;
        }
        BigDecimal dec = NumberType.convertToDecimal(a);
        switch (this.typeCode) {
            case 8: {
                dec = dec.setScale(s, 6);
                break;
            }
            default: {
                dec = dec.setScale(s, 4);
                dec = dec.setScale(this.scale, 1);
            }
        }
        a = this.convertToDefaultType(null, dec);
        return this.convertToTypeLimits(null, a);
    }

    public static NumberType getNumberType(int type, long precision, int scale) {
        switch (type) {
            case 4: {
                return SQL_INTEGER;
            }
            case 5: {
                return SQL_SMALLINT;
            }
            case 25: {
                return SQL_BIGINT;
            }
            case -6: {
                return TINYINT;
            }
            case 7: 
            case 8: {
                return SQL_DOUBLE;
            }
            case 2: 
            case 3: {
                return new NumberType(type, precision, scale);
            }
        }
        throw Error.runtimeError(201, "NumberType");
    }
}

