/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.File;
import java.io.IOException;
import org.hsqldb.Database;
import org.hsqldb.persist.RAFile;
import org.hsqldb.persist.RAFileNIO;
import org.hsqldb.persist.RandomAccessInterface;

public final class RAFileHybrid
implements RandomAccessInterface {
    final Database database;
    final String fileName;
    final boolean isReadOnly;
    boolean preNio;
    boolean isNio;
    long initialMaxLength = 0x800000L;
    RandomAccessInterface store;

    public RAFileHybrid(Database database, String name, boolean readOnly) throws IOException {
        this.database = database;
        this.fileName = name;
        this.isReadOnly = readOnly;
        File fi = new File(name);
        long fileLength = fi.length();
        this.newStore(fileLength);
    }

    @Override
    public long length() throws IOException {
        return this.store.length();
    }

    @Override
    public void seek(long position) throws IOException {
        this.store.seek(position);
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.store.getFilePointer();
    }

    @Override
    public int read() throws IOException {
        return this.store.read();
    }

    @Override
    public void read(byte[] b, int offset, int length) throws IOException {
        this.store.read(b, offset, length);
    }

    @Override
    public void write(byte[] b, int offset, int length) throws IOException {
        this.store.write(b, offset, length);
    }

    @Override
    public int readInt() throws IOException {
        return this.store.readInt();
    }

    @Override
    public void writeInt(int i) throws IOException {
        this.store.writeInt(i);
    }

    @Override
    public long readLong() throws IOException {
        return this.store.readLong();
    }

    @Override
    public void writeLong(long i) throws IOException {
        this.store.writeLong(i);
    }

    @Override
    public void close() throws IOException {
        this.store.close();
    }

    @Override
    public boolean isReadOnly() {
        return this.store.isReadOnly();
    }

    @Override
    public boolean ensureLength(long newLength) {
        if (newLength <= this.initialMaxLength) {
            return this.store.ensureLength(newLength);
        }
        if (this.preNio) {
            try {
                this.newStore(newLength);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.store.ensureLength(newLength)) {
            return true;
        }
        if (this.isNio) {
            try {
                this.newStore(newLength);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.store.ensureLength(newLength);
    }

    @Override
    public boolean setLength(long newLength) {
        return this.store.setLength(newLength);
    }

    public Database getDatabase() {
        return null;
    }

    @Override
    public void synch() {
        this.store.synch();
    }

    void newStore(long requiredPosition) throws IOException {
        long currentPosition = 0L;
        if (this.store == null) {
            this.preNio = requiredPosition <= this.database.logger.propNioMaxSize;
        } else {
            currentPosition = this.store.getFilePointer();
            this.store.synch();
            this.store.close();
        }
        if (this.preNio && this.initialMaxLength <= requiredPosition) {
            try {
                this.store = new RAFileNIO(this.database.logger, this.fileName, this.isReadOnly, requiredPosition, this.database.logger.propNioMaxSize);
                this.store.seek(currentPosition);
                this.preNio = false;
                this.isNio = true;
                return;
            }
            catch (Throwable e) {
                this.preNio = false;
            }
        }
        this.isNio = false;
        this.store = new RAFile(this.database.logger, this.fileName, this.isReadOnly, true, false);
        this.store.seek(currentPosition);
    }
}

