/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.Database;
import org.hsqldb.error.Error;
import org.hsqldb.persist.LobStore;
import org.hsqldb.persist.RAFile;
import org.hsqldb.persist.RAFileSimple;
import org.hsqldb.persist.RandomAccessInterface;

public class LobStoreRAFile
implements LobStore {
    final int lobBlockSize;
    RandomAccessInterface file;
    Database database;

    public LobStoreRAFile(Database database, int lobBlockSize) {
        this.lobBlockSize = lobBlockSize;
        this.database = database;
        try {
            String name = database.getPath() + ".lobs";
            boolean exists = database.logger.getFileAccess().isStreamElement(name);
            if (exists) {
                this.openFile();
            }
        }
        catch (Throwable t) {
            throw Error.error(466, t);
        }
    }

    private void openFile() {
        try {
            String name = this.database.getPath() + ".lobs";
            boolean readonly = this.database.isFilesReadOnly();
            this.file = this.database.logger.isStoredFileAccess() ? RAFile.newScaledRAFile(this.database, name, readonly, 3) : new RAFileSimple(this.database.logger, name, readonly ? "r" : "rws");
        }
        catch (Throwable t) {
            throw Error.error(466, t);
        }
    }

    @Override
    public byte[] getBlockBytes(int blockAddress, int blockCount) {
        if (this.file == null) {
            throw Error.error(452);
        }
        try {
            long address = (long)blockAddress * (long)this.lobBlockSize;
            int count = blockCount * this.lobBlockSize;
            byte[] dataBytes = new byte[count];
            this.file.seek(address);
            this.file.read(dataBytes, 0, count);
            return dataBytes;
        }
        catch (Throwable t) {
            throw Error.error(466, t);
        }
    }

    @Override
    public void setBlockBytes(byte[] dataBytes, int blockAddress, int blockCount) {
        if (this.file == null) {
            this.openFile();
        }
        try {
            long address = (long)blockAddress * (long)this.lobBlockSize;
            int count = blockCount * this.lobBlockSize;
            this.file.seek(address);
            this.file.write(dataBytes, 0, count);
        }
        catch (Throwable t) {
            throw Error.error(466, t);
        }
    }

    @Override
    public void setBlockBytes(byte[] dataBytes, long position, int offset, int length) {
        if (length == 0) {
            return;
        }
        if (this.file == null) {
            this.openFile();
        }
        try {
            this.file.seek(position);
            this.file.write(dataBytes, offset, length);
        }
        catch (Throwable t) {
            throw Error.error(466, t);
        }
    }

    @Override
    public int getBlockSize() {
        return this.lobBlockSize;
    }

    @Override
    public long getLength() {
        if (this.file == null) {
            this.openFile();
        }
        try {
            return this.file.length();
        }
        catch (Throwable t) {
            throw Error.error(466, t);
        }
    }

    @Override
    public void setLength(long length) {
        try {
            if (this.file != null) {
                this.file.setLength(length);
                this.file.synch();
            }
        }
        catch (Throwable t) {
            throw Error.error(466, t);
        }
    }

    @Override
    public void close() {
        try {
            if (this.file != null) {
                this.file.synch();
                this.file.close();
            }
        }
        catch (Throwable t) {
            throw Error.error(466, t);
        }
    }

    @Override
    public void synch() {
        if (this.file != null) {
            this.file.synch();
        }
    }
}

