/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.util.concurrent.atomic.AtomicInteger;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.lib.IntIndex;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.persist.BitMapCachedObject;
import org.hsqldb.persist.BlockObjectStore;
import org.hsqldb.persist.CachedObjectBase;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.DataSpaceManager;
import org.hsqldb.persist.DirectoryBlockCachedObject;
import org.hsqldb.persist.IntArrayCachedObject;
import org.hsqldb.persist.TableSpaceManager;
import org.hsqldb.persist.TableSpaceManagerBlocks;

public class DataSpaceManagerBlocks
implements DataSpaceManager {
    DataFileCache cache;
    TableSpaceManagerBlocks defaultSpaceManager;
    TableSpaceManagerBlocks directorySpaceManager;
    IntKeyHashMap spaceManagerList;
    BlockObjectStore rootStore;
    BlockObjectStore directoryStore;
    BlockObjectStore bitMapStore;
    IntArrayCachedObject rootBlock;
    AtomicInteger spaceIdSequence = new AtomicInteger(8);
    IntIndex emptySpaceList;
    int released = 0;
    static final int blockSize = 2048;
    static final int fileBlockItemCountLimit = 65536;
    int bitmapIntSize;
    int bitmapStorageSize;
    int fileBlockItemCount;
    int fileBlockSize;
    int dataFileScale;
    BlockAccessor ba;

    public DataSpaceManagerBlocks(DataFileCache dataFileCache) {
        this.cache = dataFileCache;
        this.dataFileScale = this.cache.getDataFileScale();
        this.fileBlockSize = this.cache.database.logger.getDataFileSpaces() * 1024 * 1024;
        this.fileBlockItemCount = this.fileBlockSize / this.dataFileScale;
        this.bitmapIntSize = this.fileBlockItemCount / 32;
        this.bitmapStorageSize = 4 * this.bitmapIntSize;
        if (this.bitmapStorageSize < 4096) {
            this.bitmapStorageSize = 4096;
        }
        this.ba = new BlockAccessor();
        this.spaceManagerList = new IntKeyHashMap();
        this.emptySpaceList = new IntIndex(32, false);
        this.directorySpaceManager = new TableSpaceManagerBlocks(this, 1, this.fileBlockSize, 16, this.dataFileScale, 0);
        this.defaultSpaceManager = new TableSpaceManagerBlocks(this, 7, this.fileBlockSize, this.cache.database.logger.propMaxFreeBlocks, this.dataFileScale, this.cache.database.logger.propMinReuse);
        this.spaceManagerList.put(1, this.directorySpaceManager);
        this.spaceManagerList.put(7, this.defaultSpaceManager);
        this.rootStore = new BlockObjectStore(this.cache, this.directorySpaceManager, IntArrayCachedObject.class, 8192, 2048);
        this.directoryStore = new BlockObjectStore(this.cache, this.directorySpaceManager, DirectoryBlockCachedObject.class, 24576, 2048);
        this.bitMapStore = new BlockObjectStore(this.cache, this.directorySpaceManager, BitMapCachedObject.class, this.bitmapStorageSize, this.bitmapIntSize);
        if (this.cache.spaceManagerPosition == 0L) {
            this.initialiseNewSpaceDirectory();
            this.cache.spaceManagerPosition = this.rootBlock.getPos() * (long)this.dataFileScale;
        } else {
            long pos = this.cache.spaceManagerPosition / (long)this.dataFileScale;
            this.rootBlock = (IntArrayCachedObject)this.rootStore.get(pos, true);
            if (this.getBlockIndexLimit() == 0) {
                throw Error.error(452);
            }
            this.initialiseSpaceList();
            this.initialiseTableSpace(this.directorySpaceManager);
            this.initialiseTableSpace(this.defaultSpaceManager);
        }
    }

    private void initialiseNewSpaceDirectory() {
        long currentSize = this.cache.getFileFreePos();
        long totalBlocks = currentSize / (long)this.fileBlockSize + 1L;
        long lastFreePosition = this.cache.enlargeFileSpace(totalBlocks * (long)this.fileBlockSize - currentSize);
        this.defaultSpaceManager.initialiseFileBlock(null, lastFreePosition, this.cache.getFileFreePos());
        long defaultSpaceBlockCount = totalBlocks;
        long directorySpaceBlockCount = this.calculateDirectorySpaceBlocks(totalBlocks);
        lastFreePosition = this.cache.enlargeFileSpace(directorySpaceBlockCount * (long)this.fileBlockSize);
        this.directorySpaceManager.initialiseFileBlock(null, lastFreePosition, this.cache.getFileFreePos());
        IntArrayCachedObject root = new IntArrayCachedObject(2048);
        this.rootStore.add(root, true);
        this.rootBlock = root;
        this.createFileBlocksInDirectory((int)defaultSpaceBlockCount, (int)directorySpaceBlockCount, 1);
        this.createFileBlocksInDirectory(0, (int)defaultSpaceBlockCount, 7);
    }

    private long calculateDirectorySpaceBlocks(long blockCount) {
        long currentSize = this.calculateDirectorySpaceSize(blockCount);
        long currentBlocks = currentSize / (long)this.fileBlockSize + 1L;
        currentSize += this.calculateDirectorySpaceSize(currentBlocks);
        currentBlocks = currentSize / (long)this.fileBlockSize + 1L;
        return currentBlocks;
    }

    private long calculateDirectorySpaceSize(long blockCount) {
        long blockLimit = ArrayUtil.getBinaryMultipleCeiling(blockCount + 1L, 2048L);
        long currentSize = 4L * blockLimit;
        currentSize += 12L * blockLimit;
        return currentSize += (long)this.bitmapStorageSize * (blockCount + 1L);
    }

    private void ensureDirectorySpaceAvailable(int blockCount) {
        int dirObjectSize = this.bitmapStorageSize * blockCount + 24576;
        if (!this.directorySpaceManager.hasFileRoom(dirObjectSize)) {
            int index = this.getBlockIndexLimit();
            int dirBlockCount = dirObjectSize / this.fileBlockSize + 1;
            long filePosition = this.cache.enlargeFileSpace((long)dirBlockCount * (long)this.fileBlockSize);
            this.directorySpaceManager.addFileBlock(filePosition, filePosition + (long)(dirBlockCount * this.fileBlockSize));
            this.createFileBlocksInDirectory(index, dirBlockCount, 1);
            index = this.getBlockIndexLimit();
            if ((long)index * (long)this.fileBlockSize != this.cache.getFileFreePos()) {
                this.cache.logSevereEvent("space manager end file pos different from data file: " + index * this.fileBlockSize + ", " + this.cache.getFileFreePos(), null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFileBlocks(int tableId, int blockCount) {
        this.cache.writeLock.lock();
        try {
            long index = this.getExistingBlockIndex(tableId, blockCount);
            if (index > 0L) {
                long l = index * (long)this.fileBlockSize;
                return l;
            }
            long l = this.getNewFileBlocks(tableId, blockCount);
            return l;
        }
        finally {
            this.cache.writeLock.unlock();
        }
    }

    private long getNewFileBlocks(int tableId, int blockCount) {
        this.ensureDirectorySpaceAvailable(blockCount);
        return this.getNewFileBlocksNoCheck(tableId, blockCount);
    }

    private long getNewFileBlocksNoCheck(int tableId, int blockCount) {
        long index = this.getBlockIndexLimit();
        long filePosition = index * (long)this.fileBlockSize;
        long delta = filePosition + (long)blockCount * (long)this.fileBlockSize - this.cache.getFileFreePos();
        if (delta > 0L) {
            this.cache.enlargeFileSpace(delta);
        }
        this.createFileBlocksInDirectory((int)index, blockCount, tableId);
        return filePosition;
    }

    private void createFileBlocksInDirectory(int fileBlockIndex, int blockCount, int tableId) {
        for (int i = 0; i < blockCount; ++i) {
            this.createFileBlockInDirectory(fileBlockIndex + i, tableId);
        }
    }

    private void createFileBlockInDirectory(int fileBlockIndex, int tableId) {
        BitMapCachedObject bitMap = new BitMapCachedObject(this.bitmapIntSize);
        this.bitMapStore.add(bitMap, false);
        int bitmapBlockPos = (int)(bitMap.getPos() * (long)this.dataFileScale / 4096L);
        int blockOffset = fileBlockIndex % 2048;
        DirectoryBlockCachedObject directory = this.getDirectory(fileBlockIndex, true);
        if (directory == null) {
            this.createDirectory(fileBlockIndex);
            directory = this.getDirectory(fileBlockIndex, true);
        }
        directory.getTableIdArray()[blockOffset] = tableId;
        directory.getBitmapAddressArray()[blockOffset] = bitmapBlockPos;
        directory.setChanged(true);
        directory.keepInMemory(false);
    }

    private DirectoryBlockCachedObject getDirectory(int fileBlockIndex, boolean keep) {
        int indexInRoot = fileBlockIndex / 2048;
        long position = this.rootBlock.getIntArray()[indexInRoot];
        if (position == 0L) {
            return null;
        }
        DirectoryBlockCachedObject directory = (DirectoryBlockCachedObject)this.directoryStore.get(position *= (long)(4096 / this.dataFileScale), keep);
        return directory;
    }

    private void createDirectory(int fileBlockIndex) {
        int blockPosition;
        DirectoryBlockCachedObject directory = new DirectoryBlockCachedObject(2048);
        this.directoryStore.add(directory, false);
        int indexInRoot = fileBlockIndex / 2048;
        this.rootBlock.getIntArray()[indexInRoot] = blockPosition = (int)(directory.getPos() * (long)this.dataFileScale / 4096L);
        this.rootBlock.setChanged(true);
    }

    private int getBlockIndexLimit() {
        int directoryBlockOffset;
        int rootBlockIndex;
        int[] rootArray = this.rootBlock.getIntArray();
        for (rootBlockIndex = 0; rootBlockIndex < rootArray.length && rootArray[rootBlockIndex] != 0; ++rootBlockIndex) {
        }
        if (rootBlockIndex == 0) {
            return 0;
        }
        long position = rootArray[--rootBlockIndex];
        DirectoryBlockCachedObject currentDir = (DirectoryBlockCachedObject)this.directoryStore.get(position *= (long)(4096 / this.dataFileScale), false);
        int[] bitmapArray = currentDir.getBitmapAddressArray();
        for (directoryBlockOffset = 0; directoryBlockOffset < bitmapArray.length && bitmapArray[directoryBlockOffset] != 0; ++directoryBlockOffset) {
        }
        return rootBlockIndex * 2048 + directoryBlockOffset;
    }

    private void initialiseSpaceList() {
        boolean result;
        int maxId = 7;
        this.ba.initialise(false);
        while (result = this.ba.nextBlock()) {
            int currentId = this.ba.getTableId();
            if (currentId > maxId) {
                maxId = currentId;
            }
            if (currentId != 0) continue;
            this.emptySpaceList.addUnique(this.ba.currentBlockIndex);
        }
        this.ba.reset();
        this.spaceIdSequence.set(maxId + 2 & 0xFFFFFFFE);
    }

    private int getExistingBlockIndex(int tableId, int blockCount) {
        int blockIndex = this.emptySpaceList.removeFirstConsecutiveKeys(blockCount, -1);
        if (blockIndex > 0) {
            this.setDirectoryBlocksAsTable(tableId, blockIndex, blockCount);
        }
        return blockIndex;
    }

    private void setDirectoryBlocksAsTable(int tableId, int blockIndex, int blockCount) {
        int directoryIndex = -1;
        CachedObjectBase directory = null;
        for (int i = blockIndex; i < blockIndex + blockCount; ++i) {
            if (directoryIndex != i / 2048) {
                if (directory != null) {
                    directory.setInMemory(false);
                }
                directory = this.getDirectory(i, true);
                directoryIndex = i / 2048;
            }
            int offset = i % 2048;
            ((DirectoryBlockCachedObject)directory).getTableIdArray()[offset] = tableId;
        }
        directory.setInMemory(false);
    }

    @Override
    public TableSpaceManager getDefaultTableSpace() {
        return this.defaultSpaceManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableSpaceManager getTableSpace(int spaceId) {
        if (spaceId == 7) {
            return this.defaultSpaceManager;
        }
        if (spaceId >= this.spaceIdSequence.get()) {
            this.spaceIdSequence.set(spaceId + 2 & 0xFFFFFFFE);
        }
        this.cache.writeLock.lock();
        try {
            TableSpaceManagerBlocks manager = (TableSpaceManagerBlocks)this.spaceManagerList.get(spaceId);
            if (manager == null) {
                int minReuse = this.cache.database.logger.propMinReuse;
                manager = new TableSpaceManagerBlocks(this, spaceId, this.fileBlockSize, this.cache.database.logger.propMaxFreeBlocks, this.dataFileScale, minReuse);
                this.initialiseTableSpace(manager);
                this.spaceManagerList.put(spaceId, manager);
            }
            TableSpaceManagerBlocks tableSpaceManagerBlocks = manager;
            return tableSpaceManagerBlocks;
        }
        finally {
            this.cache.writeLock.unlock();
        }
    }

    @Override
    public int getNewTableSpaceID() {
        return this.spaceIdSequence.getAndAdd(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freeTableSpace(int spaceId) {
        if (spaceId == 7 || spaceId == 1) {
            return;
        }
        this.cache.writeLock.lock();
        try {
            TableSpaceManager tableSpace = (TableSpaceManager)this.spaceManagerList.get(spaceId);
            if (tableSpace != null) {
                tableSpace.reset();
                this.spaceManagerList.remove(spaceId);
            }
            IntIndex list = new IntIndex(16, false);
            this.ba.initialise(true);
            while (this.ba.nextBlockForTable(spaceId)) {
                list.addUnsorted(this.ba.currentBlockIndex);
                this.ba.setTable(0);
                this.emptySpaceList.addUnique(this.ba.currentBlockIndex);
            }
            this.ba.reset();
            this.cache.releaseRange(list, this.fileBlockItemCount);
        }
        finally {
            this.cache.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freeTableSpace(int spaceId, DoubleIntIndex spaceList, long offset, long limit, boolean full) {
        int available;
        if (spaceList.size() == 0 && offset == limit) {
            return;
        }
        spaceList.compactLookupAsIntervals();
        if (!full && (available = spaceList.capacity() - spaceList.size()) > spaceList.capacity() / 4) {
            spaceList.setValuesSearchTarget();
            spaceList.sort();
            return;
        }
        this.cache.writeLock.lock();
        try {
            int units;
            this.ba.initialise(true);
            int[] keys = spaceList.getKeys();
            int[] values = spaceList.getValues();
            for (int i = 0; i < spaceList.size(); ++i) {
                int position = keys[i];
                units = values[i];
                this.freeTableSpacePart(position, units);
            }
            long position = offset / (long)this.dataFileScale;
            units = (int)((limit - offset) / (long)this.dataFileScale);
            this.freeTableSpacePart(position, units);
            this.ba.reset();
        }
        finally {
            this.cache.writeLock.unlock();
        }
        spaceList.clear();
        spaceList.setValuesSearchTarget();
    }

    private void freeTableSpacePart(long position, int units) {
        while (units > 0) {
            int blockIndex = (int)(position / (long)this.fileBlockItemCount);
            int offset = (int)(position % (long)this.fileBlockItemCount);
            int currentUnits = this.fileBlockItemCount - offset;
            if (currentUnits > units) {
                currentUnits = units;
            }
            this.ba.moveToBlock(blockIndex);
            int setCount = this.ba.setRange(offset, currentUnits);
            if (setCount != currentUnits) {
                this.ba.unsetRange(offset, currentUnits);
                this.cache.logSevereEvent("space manager error - recovered", null);
            }
            units -= currentUnits;
            position += (long)currentUnits;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findTableSpace(long position) {
        int blockIndex = (int)(position / (long)this.fileBlockItemCount);
        this.cache.writeLock.lock();
        try {
            this.ba.initialise(false);
            boolean result = this.ba.moveToBlock(blockIndex);
            if (!result) {
                this.ba.reset();
                int n = 7;
                return n;
            }
            int id = this.ba.getTableId();
            this.ba.reset();
            int n = id;
            return n;
        }
        finally {
            this.cache.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLostBlocksSize() {
        long fragment = 0L;
        this.cache.writeLock.lock();
        try {
            boolean result;
            this.ba.initialise(false);
            while (result = this.ba.nextBlock()) {
                if (this.ba.getTableId() == 1) continue;
                fragment += (long)(this.ba.getFreeSpaceValue() * this.dataFileScale);
                if (this.ba.getTableId() != 0) continue;
                fragment += (long)this.fileBlockSize;
            }
            this.ba.reset();
        }
        finally {
            this.cache.writeLock.unlock();
        }
        return fragment;
    }

    @Override
    public int getFileBlockSize() {
        return this.fileBlockSize;
    }

    @Override
    public boolean isModified() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialiseSpaces() {
        this.cache.writeLock.lock();
        try {
            Iterator it = this.spaceManagerList.values().iterator();
            while (it.hasNext()) {
                TableSpaceManagerBlocks tableSpace = (TableSpaceManagerBlocks)it.next();
                this.initialiseTableSpace(tableSpace);
            }
        }
        finally {
            this.cache.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        this.cache.writeLock.lock();
        try {
            Iterator it = this.spaceManagerList.values().iterator();
            while (it.hasNext()) {
                TableSpaceManagerBlocks tableSpace = (TableSpaceManagerBlocks)it.next();
                tableSpace.reset();
            }
        }
        finally {
            this.cache.writeLock.unlock();
        }
    }

    @Override
    public boolean isMultiSpace() {
        return true;
    }

    @Override
    public int getFileBlockItemCount() {
        return this.fileBlockItemCount;
    }

    @Override
    public DirectoryBlockCachedObject[] getDirectoryList() {
        int count = 0;
        int[] rootArray = this.rootBlock.getIntArray();
        while (rootArray[count] != 0) {
            ++count;
        }
        DirectoryBlockCachedObject[] directoryList = new DirectoryBlockCachedObject[count];
        for (int i = 0; i < directoryList.length; ++i) {
            directoryList[i] = this.getDirectory(i * 2048, false);
        }
        return directoryList;
    }

    private void initialiseTableSpace(TableSpaceManagerBlocks tableSpace) {
        int spaceId = tableSpace.getSpaceID();
        char maxFree = '\u0000';
        int blockIndex = -1;
        int lastBlockIndex = tableSpace.getFileBlockIndex();
        if (spaceId == 1) {
            // empty if block
        }
        if (lastBlockIndex >= 0) {
            this.ba.initialise(false);
            boolean result = this.ba.moveToBlock(lastBlockIndex);
            if (result && this.ba.getTableId() == spaceId && this.ba.getFreeBlockValue() > '\u0000') {
                blockIndex = lastBlockIndex;
            }
            this.ba.reset();
        }
        if (blockIndex < 0) {
            this.ba.initialise(false);
            while (this.ba.nextBlockForTable(spaceId)) {
                char currentFree = this.ba.getFreeBlockValue();
                if (currentFree <= maxFree) continue;
                blockIndex = this.ba.currentBlockIndex;
                maxFree = currentFree;
            }
            this.ba.reset();
        }
        if (blockIndex < 0) {
            return;
        }
        this.ba.initialise(true);
        this.ba.moveToBlock(blockIndex);
        char freeItems = this.ba.getFreeBlockValue();
        long blockPos = (long)blockIndex * (long)this.fileBlockSize;
        int unsetCount = this.ba.unsetRange(this.fileBlockItemCount - freeItems, freeItems);
        if (unsetCount == freeItems) {
            tableSpace.initialiseFileBlock(null, blockPos + (long)(this.fileBlockSize - freeItems * this.dataFileScale), blockPos + (long)this.fileBlockSize);
        } else {
            this.cache.logSevereEvent("space manager error - recovered", null);
        }
        this.ba.reset();
    }

    private class BlockAccessor {
        boolean currentKeep;
        int currentBlockIndex = -1;
        int currentDirIndex = -1;
        int currentBlockOffset = -1;
        DirectoryBlockCachedObject currentDir = null;
        BitMapCachedObject currentBitMap = null;

        private BlockAccessor() {
        }

        void initialise(boolean forUpdate) {
            this.currentKeep = forUpdate;
        }

        boolean nextBlock() {
            boolean result = this.moveToBlock(this.currentBlockIndex + 1);
            return result;
        }

        boolean nextBlockForTable(int tableId) {
            do {
                boolean result;
                if (result = this.moveToBlock(this.currentBlockIndex + 1)) continue;
                return false;
            } while (this.getTableId() != tableId);
            return true;
        }

        boolean moveToBlock(int fileBlockIndex) {
            if (this.currentBlockIndex != fileBlockIndex) {
                this.endBlockUpdate();
                this.currentBitMap = null;
                if (this.currentDirIndex != fileBlockIndex / 2048) {
                    this.reset();
                    this.currentDirIndex = fileBlockIndex / 2048;
                    this.currentDir = DataSpaceManagerBlocks.this.getDirectory(fileBlockIndex, this.currentKeep);
                }
                if (this.currentDir == null) {
                    this.reset();
                    return false;
                }
                this.currentBlockIndex = fileBlockIndex;
                this.currentBlockOffset = fileBlockIndex % 2048;
                long position = this.currentDir.getBitmapAddressArray()[this.currentBlockOffset];
                if (position == 0L) {
                    this.reset();
                    return false;
                }
                if (this.currentKeep) {
                    this.currentBitMap = (BitMapCachedObject)DataSpaceManagerBlocks.this.bitMapStore.get(position *= (long)(4096 / DataSpaceManagerBlocks.this.dataFileScale), true);
                }
            }
            return true;
        }

        int setRange(int offset, int currentUnits) {
            this.currentBitMap.setChanged(true);
            return this.currentBitMap.bitMap.setRange(offset, currentUnits);
        }

        int unsetRange(int offset, int currentUnits) {
            this.currentBitMap.setChanged(true);
            return this.currentBitMap.bitMap.unsetRange(offset, currentUnits);
        }

        void reset() {
            this.endBlockUpdate();
            if (this.currentDir != null && this.currentKeep) {
                this.currentDir.keepInMemory(false);
            }
            this.currentBlockIndex = -1;
            this.currentDirIndex = -1;
            this.currentBlockOffset = -1;
            this.currentDir = null;
            this.currentBitMap = null;
        }

        private void endBlockUpdate() {
            if (this.currentBitMap == null) {
                return;
            }
            if (!this.currentBitMap.hasChanged()) {
                this.currentBitMap.keepInMemory(false);
                return;
            }
            int freeUnits = this.currentBitMap.bitMap.countSetBits();
            int freeBlockUnits = this.currentBitMap.bitMap.countSetBitsEnd();
            if (freeUnits == DataSpaceManagerBlocks.this.fileBlockItemCount) {
                this.setTable(0);
                this.currentBitMap.keepInMemory(false);
                DataSpaceManagerBlocks.this.emptySpaceList.addUnique(this.currentBlockIndex);
                ++DataSpaceManagerBlocks.this.released;
                return;
            }
            this.currentDir.getFreeSpaceArray()[this.currentBlockOffset] = (char)freeUnits;
            this.currentDir.getFreeBlockArray()[this.currentBlockOffset] = (char)freeBlockUnits;
            this.currentDir.setChanged(true);
            this.currentBitMap.keepInMemory(false);
        }

        void setTable(int tableId) {
            this.currentDir.getTableIdArray()[this.currentBlockOffset] = tableId;
            this.currentDir.getFreeSpaceArray()[this.currentBlockOffset] = '\u0000';
            this.currentDir.getFreeBlockArray()[this.currentBlockOffset] = '\u0000';
            this.currentDir.setChanged(true);
            this.currentBitMap.bitMap.reset();
            this.currentBitMap.setChanged(true);
        }

        int getTableId() {
            return this.currentDir.getTableIdArray()[this.currentBlockOffset];
        }

        char getFreeSpaceValue() {
            return this.currentDir.getFreeSpaceArray()[this.currentBlockOffset];
        }

        char getFreeBlockValue() {
            return this.currentDir.getFreeBlockArray()[this.currentBlockOffset];
        }
    }
}

