/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.lib.LongLookup;
import org.hsqldb.map.BitMap;
import org.hsqldb.persist.CachedObjectBase;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class BitMapCachedObject
extends CachedObjectBase {
    public static final int fileSizeFactor = 4;
    BitMap bitMap;

    public BitMapCachedObject(int capacity) {
        this.bitMap = new BitMap(new int[capacity]);
        this.hasChanged = true;
    }

    @Override
    public void read(RowInputInterface in) {
        this.position = in.getPos();
        int[] array = this.bitMap.getIntArray();
        int capacity = array.length;
        for (int i = 0; i < capacity; ++i) {
            array[i] = in.readInt();
        }
        this.hasChanged = false;
    }

    @Override
    public int getDefaultCapacity() {
        return this.bitMap.getIntArray().length;
    }

    @Override
    public int getRealSize(RowOutputInterface out) {
        return this.bitMap.getIntArray().length * 4;
    }

    @Override
    public void write(RowOutputInterface out) {
        this.write(out, null);
    }

    @Override
    public void write(RowOutputInterface out, LongLookup lookup) {
        int[] array = this.bitMap.getIntArray();
        int capacity = array.length;
        out.setStorageSize(this.storageSize);
        for (int i = 0; i < capacity; ++i) {
            out.writeInt(array[i]);
        }
        out.writeEnd();
    }

    public BitMap getBitMap() {
        return this.bitMap;
    }
}

