/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.navigator;

import java.io.IOException;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.OrderedLongKeyHashMap;
import org.hsqldb.navigator.RowSetNavigatorDataChange;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;
import org.hsqldb.types.Type;

public class RowSetNavigatorDataChangeMemory
implements RowSetNavigatorDataChange {
    public static RowSetNavigatorDataChangeMemory emptyRowSet = new RowSetNavigatorDataChangeMemory(null);
    int size;
    int currentPos = -1;
    OrderedLongKeyHashMap list;
    Session session;

    public RowSetNavigatorDataChangeMemory(Session session) {
        this.session = session;
        this.list = new OrderedLongKeyHashMap(64, true);
    }

    @Override
    public void release() {
        this.beforeFirst();
        this.list.clear();
        this.size = 0;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int getRowPosition() {
        return this.currentPos;
    }

    @Override
    public boolean next() {
        if (this.currentPos < this.size - 1) {
            ++this.currentPos;
            return true;
        }
        this.currentPos = this.size - 1;
        return false;
    }

    @Override
    public boolean beforeFirst() {
        this.currentPos = -1;
        return true;
    }

    @Override
    public Row getCurrentRow() {
        return (Row)this.list.getValueByIndex(this.currentPos);
    }

    @Override
    public Object[] getCurrentChangedData() {
        return (Object[])this.list.getSecondValueByIndex(this.currentPos);
    }

    @Override
    public int[] getCurrentChangedColumns() {
        return (int[])this.list.getThirdValueByIndex(this.currentPos);
    }

    @Override
    public void write(RowOutputInterface out, ResultMetaData meta) throws IOException {
    }

    @Override
    public void read(RowInputInterface in, ResultMetaData meta) throws IOException {
    }

    @Override
    public void endMainDataSet() {
    }

    @Override
    public boolean addRow(Row row) {
        int lookup = this.list.getLookup(row.getId());
        if (lookup == -1) {
            this.list.put(row.getId(), row, null);
            ++this.size;
            return true;
        }
        if (this.list.getSecondValueByIndex(lookup) != null) {
            if (this.session.database.sqlEnforceTDCD) {
                throw Error.error(3900);
            }
            this.list.setSecondValueByIndex(lookup, null);
            this.list.setThirdValueByIndex(lookup, null);
            return true;
        }
        return false;
    }

    @Override
    public boolean addUpdate(Row row, Object[] data, int[] columnMap) {
        int lookup = this.list.getLookup(row.getId());
        if (lookup == -1) {
            return false;
        }
        this.list.put(row.getId(), row, data);
        this.list.setThirdValueByIndex(lookup, columnMap);
        return true;
    }

    @Override
    public Object[] addRow(Session session, Row row, Object[] data, Type[] types, int[] columnMap) {
        long rowId = row.getId();
        int lookup = this.list.getLookup(rowId);
        if (lookup == -1) {
            this.list.put(rowId, row, data);
            this.list.setThirdValueByIndex(this.size, columnMap);
            ++this.size;
            return data;
        }
        Object[] rowData = ((Row)this.list.getFirstByLookup(lookup)).getData();
        Object[] currentData = (Object[])this.list.getSecondValueByIndex(lookup);
        if (currentData == null) {
            if (session.database.sqlEnforceTDCD) {
                throw Error.error(3900);
            }
            return null;
        }
        for (int i = 0; i < columnMap.length; ++i) {
            int j = columnMap[i];
            if (types[j].compare(session, data[j], currentData[j]) == 0) continue;
            if (types[j].compare(session, rowData[j], currentData[j]) != 0) {
                if (!session.database.sqlEnforceTDCU) continue;
                throw Error.error(3900);
            }
            currentData[j] = data[j];
        }
        int[] currentMap = (int[])this.list.getThirdValueByIndex(lookup);
        currentMap = ArrayUtil.union(currentMap, columnMap);
        this.list.setThirdValueByIndex(lookup, currentMap);
        return currentData;
    }

    @Override
    public boolean containsDeletedRow(Row refRow) {
        int lookup = this.list.getLookup(refRow.getId());
        if (lookup == -1) {
            return false;
        }
        Object[] currentData = (Object[])this.list.getSecondValueByIndex(lookup);
        return currentData == null;
    }

    @Override
    public boolean containsUpdatedRow(Row row, Row refRow, int[] keys) {
        int lookup = this.list.getLookup(refRow.getId());
        if (lookup > -1) {
            return true;
        }
        Object[] rowData = row.getData();
        block0: for (int i = 0; i < this.size; ++i) {
            Row oldRow = (Row)this.list.getValueByIndex(i);
            if (oldRow.getTable() != row.getTable()) continue;
            Type[] types = row.getTable().getColumnTypes();
            Object[] data = (Object[])this.list.getSecondValueByIndex(i);
            for (int j = 0; j < keys.length; ++j) {
                int pos = keys[j];
                if (types[pos].compare(this.session, rowData[pos], data[pos]) != 0) continue block0;
            }
            return true;
        }
        return false;
    }

    @Override
    public Row getNextRow() {
        return null;
    }

    @Override
    public Object[] getNext() {
        return null;
    }

    @Override
    public boolean hasNext() {
        return this.currentPos < this.size - 1;
    }

    @Override
    public void removeCurrent() {
    }

    @Override
    public boolean setRowColumns(boolean[] columns) {
        return false;
    }

    @Override
    public long getRowId() {
        return this.getCurrentRow().getId();
    }

    @Override
    public boolean isBeforeFirst() {
        return this.currentPos == -1;
    }

    @Override
    public Object[] getCurrent() {
        return this.getCurrentRow().getData();
    }

    @Override
    public Object getCurrent(int i) {
        return this.getCurrentRow().getData()[i];
    }

    @Override
    public void setCurrent(Object[] data) {
    }

    @Override
    public Object getRowidObject() {
        return this.getRowId();
    }

    @Override
    public void reset() {
        this.beforeFirst();
    }

    @Override
    public int getRangePosition() {
        return 1;
    }
}

