/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.map;

import java.util.Arrays;

public class HashIndex {
    int[] hashTable;
    int[] linkTable;
    int newNodePointer;
    int elementCount;
    int reclaimedNodePointer = -1;
    boolean fixedSize;
    boolean modified;

    public HashIndex(int hashTableSize, int capacity, boolean fixedSize) {
        if (capacity < hashTableSize) {
            capacity = hashTableSize;
        }
        this.reset(hashTableSize, capacity);
        this.fixedSize = fixedSize;
    }

    public void reset(int hashTableSize, int capacity) {
        int[] newHT = new int[hashTableSize];
        int[] newLT = new int[capacity];
        this.hashTable = newHT;
        this.linkTable = newLT;
        Arrays.fill(this.hashTable, -1);
        this.resetTables();
    }

    public void resetTables() {
        this.newNodePointer = 0;
        this.elementCount = 0;
        this.reclaimedNodePointer = -1;
        this.modified = false;
    }

    public void clear() {
        Arrays.fill(this.linkTable, 0, this.newNodePointer, 0);
        Arrays.fill(this.hashTable, -1);
        this.resetTables();
    }

    public int getHashIndex(int hash) {
        return (hash & Integer.MAX_VALUE) % this.hashTable.length;
    }

    public int getLookup(int hash) {
        if (this.elementCount == 0) {
            return -1;
        }
        int index = (hash & Integer.MAX_VALUE) % this.hashTable.length;
        return this.hashTable[index];
    }

    public int getNextLookup(int lookup) {
        return this.linkTable[lookup];
    }

    public int linkNode(int index, int lastLookup) {
        int nextLookup;
        int lookup = this.reclaimedNodePointer;
        if (lookup == -1) {
            lookup = this.newNodePointer++;
        } else {
            this.reclaimedNodePointer = this.linkTable[lookup];
        }
        if (lastLookup == -1) {
            nextLookup = this.hashTable[index];
            this.hashTable[index] = lookup;
        } else {
            nextLookup = this.linkTable[lastLookup];
            this.linkTable[lastLookup] = lookup;
        }
        this.linkTable[lookup] = nextLookup;
        ++this.elementCount;
        this.modified = true;
        return lookup;
    }

    public void unlinkNode(int index, int lastLookup, int lookup) {
        if (lastLookup == -1) {
            this.hashTable[index] = this.linkTable[lookup];
        } else {
            this.linkTable[lastLookup] = this.linkTable[lookup];
        }
        this.linkTable[lookup] = this.reclaimedNodePointer;
        this.reclaimedNodePointer = lookup;
        --this.elementCount;
        if (this.elementCount == 0) {
            Arrays.fill(this.linkTable, 0, this.newNodePointer, 0);
            this.resetTables();
        }
    }

    public boolean removeEmptyNode(int lookup) {
        boolean found = false;
        int lastLookup = -1;
        int i = this.reclaimedNodePointer;
        while (i >= 0) {
            if (i == lookup) {
                if (lastLookup == -1) {
                    this.reclaimedNodePointer = this.linkTable[lookup];
                } else {
                    this.linkTable[lastLookup] = this.linkTable[lookup];
                }
                found = true;
                break;
            }
            lastLookup = i;
            i = this.linkTable[i];
        }
        if (!found) {
            return false;
        }
        for (i = 0; i < this.newNodePointer; ++i) {
            if (this.linkTable[i] <= lookup) continue;
            int n = i;
            this.linkTable[n] = this.linkTable[n] - 1;
        }
        System.arraycopy(this.linkTable, lookup + 1, this.linkTable, lookup, this.newNodePointer - lookup - 1);
        this.linkTable[this.newNodePointer - 1] = 0;
        --this.newNodePointer;
        for (i = 0; i < this.hashTable.length; ++i) {
            if (this.hashTable[i] <= lookup) continue;
            int n = i;
            this.hashTable[n] = this.hashTable[n] - 1;
        }
        return true;
    }
}

