/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib.tar;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import org.hsqldb.lib.tar.RB;
import org.hsqldb.lib.tar.TarMalformatException;

public class PIFGenerator
extends ByteArrayOutputStream {
    OutputStreamWriter writer;
    String name;
    int fakePid;

    public String getName() {
        return this.name;
    }

    protected PIFGenerator() {
        try {
            this.writer = new OutputStreamWriter((OutputStream)this, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("Serious problem.  JVM can't encode UTF-8", uee);
        }
        this.fakePid = (int)(new Date().getTime() % 100000L);
    }

    public PIFGenerator(int sequenceNum) {
        this();
        if (sequenceNum < 1) {
            throw new IllegalArgumentException("Sequence numbers start at 1");
        }
        this.name = System.getProperty("java.io.tmpdir") + "/GlobalHead." + this.fakePid + '.' + sequenceNum;
    }

    public PIFGenerator(File file) {
        this();
        String parentPath = file.getParentFile() == null ? "." : file.getParentFile().getPath();
        this.name = parentPath + "/PaxHeaders." + this.fakePid + '/' + file.getName();
    }

    public void addRecord(String key, boolean b) throws TarMalformatException, IOException {
        this.addRecord(key, Boolean.toString(b));
    }

    public void addRecord(String key, int i) throws TarMalformatException, IOException {
        this.addRecord(key, Integer.toString(i));
    }

    public void addRecord(String key, long l) throws TarMalformatException, IOException {
        this.addRecord(key, Long.toString(l));
    }

    public void addRecord(String key, String value) throws TarMalformatException, IOException {
        if (key == null || value == null || key.length() < 1 || value.length() < 1) {
            throw new TarMalformatException(RB.zero_write.getString());
        }
        int lenWithoutIlen = key.length() + value.length() + 3;
        int lenW = 0;
        if (lenWithoutIlen < 8) {
            lenW = lenWithoutIlen + 1;
        } else if (lenWithoutIlen < 97) {
            lenW = lenWithoutIlen + 2;
        } else if (lenWithoutIlen < 996) {
            lenW = lenWithoutIlen + 3;
        } else if (lenWithoutIlen < 9995) {
            lenW = lenWithoutIlen + 4;
        } else if (lenWithoutIlen < 99994) {
            lenW = lenWithoutIlen + 5;
        } else {
            throw new TarMalformatException(RB.pif_toobig.getString(99991));
        }
        this.writer.write(Integer.toString(lenW));
        this.writer.write(32);
        this.writer.write(key);
        this.writer.write(61);
        this.writer.write(value);
        this.writer.write(10);
        this.writer.flush();
    }
}

