/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.index;

import java.io.IOException;
import org.hsqldb.RowAVL;
import org.hsqldb.RowAVLDisk;
import org.hsqldb.index.Index;
import org.hsqldb.index.NodeAVL;
import org.hsqldb.lib.LongLookup;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class NodeAVLDisk
extends NodeAVL {
    final RowAVLDisk row;
    private int iLeft = -1;
    private int iRight = -1;
    private int iParent = -1;
    private int iId;
    public static final int SIZE_IN_BYTE = 16;

    public NodeAVLDisk(RowAVLDisk r, RowInputInterface in, int id) throws IOException {
        this.row = r;
        this.iId = id;
        this.iBalance = in.readInt();
        this.iLeft = in.readInt();
        this.iRight = in.readInt();
        this.iParent = in.readInt();
        if (this.iLeft <= 0) {
            this.iLeft = -1;
        }
        if (this.iRight <= 0) {
            this.iRight = -1;
        }
        if (this.iParent <= 0) {
            this.iParent = -1;
        }
    }

    public NodeAVLDisk(RowAVLDisk r, int id) {
        this.row = r;
        this.iId = id;
    }

    @Override
    public void delete() {
        this.iLeft = -1;
        this.iRight = -1;
        this.iParent = -1;
        this.nLeft = null;
        this.nRight = null;
        this.nParent = null;
        this.iBalance = 0;
        this.row.setNodesChanged();
    }

    @Override
    public boolean isInMemory() {
        return this.row.isInMemory();
    }

    @Override
    public boolean isMemory() {
        return false;
    }

    @Override
    public long getPos() {
        return this.row.getPos();
    }

    @Override
    public RowAVL getRow(PersistentStore store) {
        return (RowAVLDisk)store.get((CachedObject)this.row, false);
    }

    @Override
    public Object[] getData(PersistentStore store) {
        return this.row.getData();
    }

    private NodeAVLDisk findNode(PersistentStore store, int pos) {
        NodeAVLDisk ret = null;
        RowAVLDisk r = (RowAVLDisk)store.get(pos, false);
        if (r != null) {
            ret = (NodeAVLDisk)r.getNode(this.iId);
        }
        return ret;
    }

    @Override
    boolean isLeft(NodeAVL n) {
        if (n == null) {
            return this.iLeft == -1;
        }
        return (long)this.iLeft == n.getPos();
    }

    @Override
    boolean isRight(NodeAVL n) {
        if (n == null) {
            return this.iRight == -1;
        }
        return (long)this.iRight == n.getPos();
    }

    @Override
    NodeAVL getLeft(PersistentStore store) {
        NodeAVLDisk node = this;
        RowAVLDisk row = this.row;
        row = (RowAVLDisk)store.get((CachedObject)this.row, false);
        node = (NodeAVLDisk)row.getNode(this.iId);
        if (node.iLeft == -1) {
            return null;
        }
        NodeAVLDisk temp = this.findNode(store, node.iLeft);
        return temp;
    }

    @Override
    NodeAVL getRight(PersistentStore store) {
        NodeAVLDisk node = this;
        RowAVLDisk row = this.row;
        row = (RowAVLDisk)store.get((CachedObject)this.row, false);
        node = (NodeAVLDisk)row.getNode(this.iId);
        if (node.iRight == -1) {
            return null;
        }
        NodeAVLDisk temp = this.findNode(store, node.iRight);
        return temp;
    }

    @Override
    NodeAVL getParent(PersistentStore store) {
        NodeAVLDisk node = this;
        RowAVLDisk row = this.row;
        row = (RowAVLDisk)store.get((CachedObject)this.row, false);
        node = (NodeAVLDisk)row.getNode(this.iId);
        if (node.iParent == -1) {
            return null;
        }
        NodeAVLDisk temp = this.findNode(store, this.iParent);
        return temp;
    }

    @Override
    public int getBalance(PersistentStore store) {
        NodeAVLDisk node = this;
        RowAVLDisk row = this.row;
        row = (RowAVLDisk)store.get((CachedObject)this.row, false);
        node = (NodeAVLDisk)row.getNode(this.iId);
        return node.iBalance;
    }

    @Override
    boolean isRoot(PersistentStore store) {
        NodeAVLDisk node = this;
        RowAVLDisk row = this.row;
        row = (RowAVLDisk)store.get((CachedObject)this.row, false);
        node = (NodeAVLDisk)row.getNode(this.iId);
        return node.iParent == -1;
    }

    @Override
    boolean isFromLeft(PersistentStore store) {
        NodeAVLDisk node = this;
        RowAVLDisk row = this.row;
        row = (RowAVLDisk)store.get((CachedObject)this.row, false);
        node = (NodeAVLDisk)row.getNode(this.iId);
        if (node.iParent == -1) {
            return true;
        }
        NodeAVLDisk temp = this.findNode(store, this.iParent);
        return row.getPos() == (long)temp.iLeft;
    }

    @Override
    public NodeAVL child(PersistentStore store, boolean isleft) {
        return isleft ? this.getLeft(store) : this.getRight(store);
    }

    @Override
    NodeAVL setParent(PersistentStore store, NodeAVL n) {
        NodeAVLDisk node = this;
        RowAVLDisk row = this.row;
        row = (RowAVLDisk)store.get((CachedObject)this.row, true);
        node = (NodeAVLDisk)row.getNode(this.iId);
        row.setNodesChanged();
        node.iParent = n == null ? -1 : (int)n.getPos();
        row.keepInMemory(false);
        return node;
    }

    @Override
    public NodeAVL setBalance(PersistentStore store, int b) {
        NodeAVLDisk node = this;
        RowAVLDisk row = this.row;
        row = (RowAVLDisk)store.get((CachedObject)this.row, true);
        node = (NodeAVLDisk)row.getNode(this.iId);
        row.setNodesChanged();
        node.iBalance = b;
        row.keepInMemory(false);
        return node;
    }

    @Override
    NodeAVL setLeft(PersistentStore store, NodeAVL n) {
        NodeAVLDisk node = this;
        RowAVLDisk row = this.row;
        row = (RowAVLDisk)store.get((CachedObject)this.row, true);
        node = (NodeAVLDisk)row.getNode(this.iId);
        row.setNodesChanged();
        node.iLeft = n == null ? -1 : (int)n.getPos();
        row.keepInMemory(false);
        return node;
    }

    @Override
    NodeAVL setRight(PersistentStore store, NodeAVL n) {
        NodeAVLDisk node = this;
        RowAVLDisk row = this.row;
        row = (RowAVLDisk)store.get((CachedObject)this.row, true);
        node = (NodeAVLDisk)row.getNode(this.iId);
        row.setNodesChanged();
        node.iRight = n == null ? -1 : (int)n.getPos();
        row.keepInMemory(false);
        return node;
    }

    @Override
    public NodeAVL set(PersistentStore store, boolean isLeft, NodeAVL n) {
        NodeAVL x = isLeft ? this.setLeft(store, n) : this.setRight(store, n);
        if (n != null) {
            n.setParent(store, this);
        }
        return x;
    }

    @Override
    public void replace(PersistentStore store, Index index, NodeAVL n) {
        if (this.iParent == -1) {
            if (n != null) {
                n = n.setParent(store, null);
            }
            store.setAccessor(index, n);
        } else {
            boolean isFromLeft = this.isFromLeft(store);
            this.getParent(store).set(store, isFromLeft, n);
        }
    }

    @Override
    boolean equals(NodeAVL n) {
        if (n instanceof NodeAVLDisk) {
            return this == n || this.getPos() == ((NodeAVLDisk)n).getPos();
        }
        return false;
    }

    @Override
    public int getRealSize(RowOutputInterface out) {
        return 16;
    }

    @Override
    public void setInMemory(boolean in) {
    }

    @Override
    public void write(RowOutputInterface out) {
        out.writeInt(this.iBalance);
        out.writeInt(this.iLeft == -1 ? 0 : this.iLeft);
        out.writeInt(this.iRight == -1 ? 0 : this.iRight);
        out.writeInt(this.iParent == -1 ? 0 : this.iParent);
    }

    @Override
    public void write(RowOutputInterface out, LongLookup lookup) {
        out.writeInt(this.iBalance);
        out.writeInt(NodeAVLDisk.getTranslatePointer(this.iLeft, lookup));
        out.writeInt(NodeAVLDisk.getTranslatePointer(this.iRight, lookup));
        out.writeInt(NodeAVLDisk.getTranslatePointer(this.iParent, lookup));
    }

    private static int getTranslatePointer(int pointer, LongLookup lookup) {
        int newPointer = 0;
        if (pointer != -1) {
            newPointer = lookup == null ? pointer : (int)lookup.lookup(pointer);
        }
        return newPointer;
    }

    @Override
    public void restore() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public void updateAccessCount(int count) {
    }

    @Override
    public int getAccessCount() {
        return 0;
    }

    @Override
    public void setStorageSize(int size) {
    }

    @Override
    public int getStorageSize() {
        return 0;
    }

    @Override
    public void setPos(long pos) {
    }

    @Override
    public boolean isNew() {
        return false;
    }

    @Override
    public boolean hasChanged() {
        return false;
    }

    @Override
    public void setChanged(boolean flag) {
    }

    @Override
    public boolean isKeepInMemory() {
        return false;
    }

    @Override
    public boolean keepInMemory(boolean keep) {
        return false;
    }
}

