/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.auth;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.AuthenticationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import org.hsqldb.auth.AuthFunctionBean;
import org.hsqldb.auth.DenyException;
import org.hsqldb.lib.FrameworkLogger;

public class LdapAuthBean
implements AuthFunctionBean {
    private static FrameworkLogger logger = FrameworkLogger.getLog(LdapAuthBean.class);
    private Integer ldapPort;
    private String ldapHost;
    private String principalTemplate;
    private String saslRealm;
    private String parentDn;
    private Pattern roleSchemaValuePattern;
    private Pattern accessValuePattern;
    private String initialContextFactory = "com.sun.jndi.ldap.LdapCtxFactory";
    private boolean tls;
    private String mechanism = "SIMPLE";
    private String rdnAttribute = "uid";
    private boolean initialized;
    private String rolesSchemaAttribute;
    private String accessAttribute;
    protected String[] attributeUnion;

    public void setStartTls(boolean isTls) {
        this.tls = isTls;
    }

    public void setLdapPort(int ldapPort) {
        this.ldapPort = ldapPort;
    }

    public void init() {
        if (this.ldapHost == null) {
            throw new IllegalStateException("Required property 'ldapHost' not set");
        }
        if (this.parentDn == null) {
            throw new IllegalStateException("Required property 'parentDn' not set");
        }
        if (this.initialContextFactory == null) {
            throw new IllegalStateException("Required property 'initialContextFactory' not set");
        }
        if (this.mechanism == null) {
            throw new IllegalStateException("Required property 'mechanism' not set");
        }
        if (this.rdnAttribute == null) {
            throw new IllegalStateException("Required property 'rdnAttribute' not set");
        }
        if (this.rolesSchemaAttribute == null && this.accessAttribute == null) {
            throw new IllegalStateException("You must set property 'rolesSchemaAttribute' and/or property 'accessAttribute'");
        }
        if (this.roleSchemaValuePattern != null && this.rolesSchemaAttribute == null) {
            throw new IllegalStateException("If property 'roleSchemaValuePattern' is set, then you must also set property 'rolesSchemaAttribute' to indicate which attribute to evalueate");
        }
        if (this.accessValuePattern != null && this.accessAttribute == null) {
            throw new IllegalStateException("If property 'accessValuePattern' is set, then you must also set property 'accessAttribute' to indicate which attribute to evalueate");
        }
        this.attributeUnion = this.rolesSchemaAttribute != null && this.accessAttribute != null ? new String[]{this.rolesSchemaAttribute, this.accessAttribute} : (this.rolesSchemaAttribute != null ? new String[]{this.rolesSchemaAttribute} : new String[]{this.accessAttribute});
        this.initialized = true;
    }

    public void setAccessValuePattern(Pattern accessValuePattern) {
        this.accessValuePattern = accessValuePattern;
    }

    public void setAccessValuePatternString(String patternString) {
        this.setAccessValuePattern(Pattern.compile(patternString));
    }

    public void setRoleSchemaValuePattern(Pattern roleSchemaValuePattern) {
        this.roleSchemaValuePattern = roleSchemaValuePattern;
    }

    public void setRoleSchemaValuePatternString(String patternString) {
        this.setRoleSchemaValuePattern(Pattern.compile(patternString));
    }

    public void setSecurityMechanism(String mechanism) {
        this.mechanism = mechanism;
    }

    public void setLdapHost(String ldapHost) {
        this.ldapHost = ldapHost;
    }

    public void setPrincipalTemplate(String principalTemplate) {
        this.principalTemplate = principalTemplate;
    }

    public void setInitialContextFactory(String initialContextFactory) {
        this.initialContextFactory = initialContextFactory;
    }

    public void setSaslRealm(String saslRealm) {
        this.saslRealm = saslRealm;
    }

    public void setParentDn(String parentDn) {
        this.parentDn = parentDn;
    }

    public void setRdnAttribute(String rdnAttribute) {
        this.rdnAttribute = rdnAttribute;
    }

    public void setRolesSchemaAttribute(String attribute) {
        this.rolesSchemaAttribute = attribute;
    }

    public void setAccessAttribute(String attribute) {
        this.accessAttribute = attribute;
    }

    @Override
    public String[] authenticate(String userName, String password) throws DenyException {
        if (!this.initialized) {
            throw new IllegalStateException("You must invoke the 'init' method to initialize the " + LdapAuthBean.class.getName() + " instance.");
        }
        Hashtable<String, String> env = new Hashtable<String, String>(5, 0.75f);
        env.put("java.naming.factory.initial", this.initialContextFactory);
        env.put("java.naming.provider.url", "ldap://" + this.ldapHost + (this.ldapPort == null ? "" : ":" + this.ldapPort));
        StartTlsResponse tlsResponse = null;
        InitialLdapContext ctx = null;
        try {
            Attribute attribute;
            ctx = new InitialLdapContext(env, null);
            if (this.tls) {
                tlsResponse = (StartTlsResponse)ctx.extendedOperation(new StartTlsRequest());
                tlsResponse.negotiate();
            }
            ctx.addToEnvironment("java.naming.security.authentication", this.mechanism);
            ctx.addToEnvironment("java.naming.security.principal", this.principalTemplate == null ? userName : this.principalTemplate.replace("${username}", userName));
            ctx.addToEnvironment("java.naming.security.credentials", password);
            if (this.saslRealm != null) {
                env.put("java.naming.security.sasl.realm", this.saslRealm);
            }
            NamingEnumeration<SearchResult> sRess = null;
            try {
                sRess = ctx.search(this.parentDn, (Attributes)new BasicAttributes(this.rdnAttribute, userName), this.attributeUnion);
            }
            catch (AuthenticationException ae) {
                throw new DenyException();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (!sRess.hasMore()) {
                throw new DenyException();
            }
            SearchResult sRes = sRess.next();
            if (sRess.hasMore()) {
                throw new RuntimeException("> 1 result");
            }
            Attributes attrs = sRes.getAttributes();
            if (this.accessAttribute != null) {
                attribute = attrs.get(this.accessAttribute);
                if (attribute == null) {
                    throw new DenyException();
                }
                if (attribute.size() != 1) {
                    throw new RuntimeException("Access attribute '" + this.accessAttribute + "' has unexpected value count: " + attribute.size());
                }
                if (this.accessValuePattern != null) {
                    Object accessValue = attribute.get(0);
                    if (accessValue == null) {
                        throw new RuntimeException("Access Attr. value is null");
                    }
                    if (!(accessValue instanceof String)) {
                        throw new RuntimeException("Access Attr. value not a String: " + accessValue.getClass().getName());
                    }
                    if (!this.accessValuePattern.matcher((String)accessValue).matches()) {
                        throw new DenyException();
                    }
                }
            }
            if (this.rolesSchemaAttribute == null) {
                attribute = null;
                return attribute;
            }
            ArrayList<String> returns = new ArrayList<String>();
            Attribute attribute2 = attrs.get(this.rolesSchemaAttribute);
            if (attribute2 != null) {
                int valCount = attribute2.size();
                for (int i = 0; i < valCount; ++i) {
                    Object oneVal = attribute2.get(i);
                    if (oneVal == null) {
                        throw new RuntimeException("R/S Attr value #" + i + " is null");
                    }
                    if (!(oneVal instanceof String)) {
                        throw new RuntimeException("R/S Attr value #" + i + " not a String: " + oneVal.getClass().getName());
                    }
                    if (this.roleSchemaValuePattern == null) {
                        returns.add((String)oneVal);
                        continue;
                    }
                    Matcher matcher = this.roleSchemaValuePattern.matcher((String)oneVal);
                    if (!matcher.matches()) continue;
                    returns.add(matcher.groupCount() > 0 ? matcher.group(1) : (String)oneVal);
                }
            }
            if (returns.size() < 1) {
                if (this.accessAttribute == null) {
                    throw new DenyException();
                }
                String[] stringArray = new String[]{};
                return stringArray;
            }
            String[] stringArray = returns.toArray(new String[0]);
            return stringArray;
        }
        catch (DenyException de) {
            throw de;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        catch (NamingException ne) {
            throw new RuntimeException(ne);
        }
        finally {
            if (tlsResponse != null) {
                try {
                    tlsResponse.close();
                }
                catch (IOException ioe) {
                    logger.error("Failed to close TLS Response", ioe);
                }
            }
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException ne) {
                    logger.error("Failed to close LDAP Context", ne);
                }
            }
        }
    }
}

