/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.Row;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.Table;
import org.hsqldb.TransactionManager;
import org.hsqldb.TransactionManagerCommon;
import org.hsqldb.error.Error;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.PersistentStore;

public class TransactionManager2PL
extends TransactionManagerCommon
implements TransactionManager {
    public TransactionManager2PL(Database db) {
        this.database = db;
        this.lobSession = this.database.sessionManager.getSysLobSession();
        this.txModel = 0;
    }

    @Override
    public long getGlobalChangeTimestamp() {
        return this.globalChangeTimestamp.get();
    }

    @Override
    public boolean isMVRows() {
        return false;
    }

    @Override
    public boolean isMVCC() {
        return false;
    }

    @Override
    public int getTransactionControl() {
        return 0;
    }

    @Override
    public void setTransactionControl(Session session, int mode) {
        super.setTransactionControl(session, mode);
    }

    @Override
    public void completeActions(Session session) {
        this.endActionTPL(session);
    }

    @Override
    public boolean prepareCommitActions(Session session) {
        session.actionTimestamp = this.getNextGlobalChangeTimestamp();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean commitTransaction(Session session) {
        if (session.abortTransaction) {
            return false;
        }
        this.writeLock.lock();
        try {
            int limit = session.rowActionList.size();
            session.transactionEndTimestamp = session.actionTimestamp = this.getNextGlobalChangeTimestamp();
            this.endTransaction(session);
            for (int i = 0; i < limit; ++i) {
                RowAction action = (RowAction)session.rowActionList.get(i);
                action.commit(session);
            }
            this.adjustLobUsage(session);
            this.persistCommit(session);
            this.endTransactionTPL(session);
        }
        finally {
            this.writeLock.unlock();
        }
        session.tempSet.clear();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Session session) {
        this.writeLock.lock();
        try {
            session.abortTransaction = false;
            session.transactionEndTimestamp = session.actionTimestamp = this.getNextGlobalChangeTimestamp();
            this.rollbackPartial(session, 0, session.transactionTimestamp);
            this.endTransaction(session);
            this.endTransactionTPL(session);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void rollbackSavepoint(Session session, int index) {
        long timestamp = session.sessionContext.savepointTimestamps.get(index);
        Integer oi = (Integer)session.sessionContext.savepoints.get(index);
        int start = oi;
        while (session.sessionContext.savepoints.size() > index + 1) {
            session.sessionContext.savepoints.remove(session.sessionContext.savepoints.size() - 1);
            session.sessionContext.savepointTimestamps.removeLast();
        }
        this.rollbackPartial(session, start, timestamp);
    }

    @Override
    public void rollbackAction(Session session) {
        this.rollbackPartial(session, session.actionIndex, session.actionStartTimestamp);
        this.endActionTPL(session);
    }

    @Override
    public void rollbackPartial(Session session, int start, long timestamp) {
        int limit = session.rowActionList.size();
        if (start == limit) {
            return;
        }
        for (int i = limit - 1; i >= start; --i) {
            RowAction action = (RowAction)session.rowActionList.get(i);
            if (action == null || action.type == 0 || action.type == 3) continue;
            Row row = action.memoryRow;
            if (row == null) {
                row = (Row)action.store.get(action.getPos(), false);
            }
            if (row == null) continue;
            action.rollback(session, timestamp);
            int type = action.mergeRollback(session, timestamp, row);
            action.store.rollbackRow(session, row, type, this.txModel);
        }
        session.rowActionList.setSize(start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowAction addDeleteAction(Session session, Table table, PersistentStore store, Row row, int[] colMap) {
        RowAction action;
        Row row2 = row;
        synchronized (row2) {
            action = RowAction.addDeleteAction(session, table, row, colMap);
        }
        session.rowActionList.add(action);
        store.delete(session, row);
        row.rowAction = null;
        return action;
    }

    @Override
    public void addInsertAction(Session session, Table table, PersistentStore store, Row row, int[] changedColumns) {
        RowAction action = row.rowAction;
        if (action == null) {
            throw Error.runtimeError(458, "null insert action ");
        }
        store.indexRow(session, row);
        if (table.persistenceScope == 20) {
            row.rowAction = null;
            return;
        }
        session.rowActionList.add(action);
        row.rowAction = null;
    }

    @Override
    public boolean canRead(Session session, PersistentStore store, Row row, int mode, int[] colMap) {
        return true;
    }

    @Override
    public boolean canRead(Session session, PersistentStore store, long id, int mode) {
        return true;
    }

    @Override
    public void addTransactionInfo(CachedObject object) {
    }

    @Override
    public void setTransactionInfo(PersistentStore store, CachedObject object) {
    }

    @Override
    public void removeTransactionInfo(CachedObject object) {
    }

    @Override
    public void beginTransaction(Session session) {
        if (!session.isTransaction) {
            session.transactionTimestamp = session.actionTimestamp = this.getNextGlobalChangeTimestamp();
            session.isTransaction = true;
            ++this.transactionCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginAction(Session session, Statement cs) {
        if (session.hasLocks(cs)) {
            return;
        }
        this.writeLock.lock();
        try {
            boolean canProceed;
            if (cs.getCompileTimestamp() < this.database.schemaManager.getSchemaChangeTimestamp()) {
                session.sessionContext.currentStatement = cs = session.statementManager.getStatement(session, cs);
                if (cs == null) {
                    return;
                }
            }
            if (canProceed = this.setWaitedSessionsTPL(session, cs)) {
                if (session.tempSet.isEmpty()) {
                    this.lockTablesTPL(session, cs);
                } else {
                    this.setWaitingSessionTPL(session);
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void beginActionResume(Session session) {
        session.actionStartTimestamp = session.actionTimestamp = this.getNextGlobalChangeTimestamp();
        if (!session.isTransaction) {
            session.transactionTimestamp = session.actionTimestamp;
            session.isTransaction = true;
            ++this.transactionCount;
        }
    }

    @Override
    public void removeTransactionInfo(long id) {
    }

    @Override
    public void resetSession(Session session, Session targetSession, int mode) {
        super.resetSession(session, targetSession, mode);
    }

    void endTransaction(Session session) {
        if (session.isTransaction) {
            session.isTransaction = false;
            --this.transactionCount;
        }
    }
}

